/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.server;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import org.ros.exception.RosRuntimeException;
import org.ros.internal.transport.ConnectionHeader;
import org.ros.namespace.GraphName;

public class NodeIdentifier {
    private final GraphName name;
    private final URI uri;

    public static NodeIdentifier forName(String name) {
        return new NodeIdentifier(GraphName.of(name), null);
    }

    public static NodeIdentifier forUri(String uri) {
        try {
            return new NodeIdentifier(null, new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new RosRuntimeException(e);
        }
    }

    public static NodeIdentifier forNameAndUri(String name, String uri) {
        try {
            return new NodeIdentifier(GraphName.of(name), new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new RosRuntimeException(e);
        }
    }

    public NodeIdentifier(GraphName name, URI uri) {
        Preconditions.checkArgument((name != null || uri != null ? 1 : 0) != 0);
        if (name != null) {
            Preconditions.checkArgument((boolean)name.isGlobal());
        }
        this.name = name;
        this.uri = uri;
    }

    public GraphName getName() {
        return this.name;
    }

    public URI getUri() {
        return this.uri;
    }

    public ConnectionHeader toConnectionHeader() {
        ConnectionHeader connectionHeader = new ConnectionHeader();
        connectionHeader.addField("callerid", this.name.toString());
        return connectionHeader;
    }

    public String toString() {
        return "NodeIdentifier<" + this.name + ", " + this.uri + ">";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeIdentifier other = (NodeIdentifier)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

