/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.topic;

import com.google.common.base.Preconditions;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.ros.concurrent.ListenerGroup;
import org.ros.concurrent.SignalRunnable;
import org.ros.internal.node.server.NodeIdentifier;
import org.ros.internal.node.topic.DefaultTopicParticipant;
import org.ros.internal.node.topic.PublisherDeclaration;
import org.ros.internal.node.topic.PublisherIdentifier;
import org.ros.internal.node.topic.SubscriberIdentifier;
import org.ros.internal.node.topic.TopicDeclaration;
import org.ros.internal.transport.ConnectionHeader;
import org.ros.internal.transport.queue.OutgoingMessageQueue;
import org.ros.message.MessageFactory;
import org.ros.message.MessageSerializer;
import org.ros.node.topic.DefaultPublisherListener;
import org.ros.node.topic.Publisher;
import org.ros.node.topic.PublisherListener;

public class DefaultPublisher<T>
extends DefaultTopicParticipant
implements Publisher<T> {
    private static final boolean DEBUG = false;
    private static final Log log = LogFactory.getLog(DefaultPublisher.class);
    private static final long DEFAULT_SHUTDOWN_TIMEOUT = 5L;
    private static final TimeUnit DEFAULT_SHUTDOWN_TIMEOUT_UNITS = TimeUnit.SECONDS;
    private final OutgoingMessageQueue<T> outgoingMessageQueue;
    private final ListenerGroup<PublisherListener<T>> listeners;
    private final NodeIdentifier nodeIdentifier;
    private final MessageFactory messageFactory;

    public DefaultPublisher(NodeIdentifier nodeIdentifier, TopicDeclaration topicDeclaration, MessageSerializer<T> serializer, MessageFactory messageFactory, ScheduledExecutorService executorService) {
        super(topicDeclaration);
        this.nodeIdentifier = nodeIdentifier;
        this.messageFactory = messageFactory;
        this.outgoingMessageQueue = new OutgoingMessageQueue<T>(serializer, executorService);
        this.listeners = new ListenerGroup(executorService);
        this.listeners.add(new DefaultPublisherListener<T>(){

            @Override
            public void onMasterRegistrationSuccess(Publisher<T> registrant) {
                log.info((Object)("Publisher registered: " + DefaultPublisher.this));
            }

            @Override
            public void onMasterRegistrationFailure(Publisher<T> registrant) {
                log.info((Object)("Publisher registration failed: " + DefaultPublisher.this));
            }

            @Override
            public void onMasterUnregistrationSuccess(Publisher<T> registrant) {
                log.info((Object)("Publisher unregistered: " + DefaultPublisher.this));
            }

            @Override
            public void onMasterUnregistrationFailure(Publisher<T> registrant) {
                log.info((Object)("Publisher unregistration failed: " + DefaultPublisher.this));
            }
        });
    }

    @Override
    public void setLatchMode(boolean enabled) {
        this.outgoingMessageQueue.setLatchMode(enabled);
    }

    @Override
    public boolean getLatchMode() {
        return this.outgoingMessageQueue.getLatchMode();
    }

    @Override
    public void shutdown(long timeout, TimeUnit unit) {
        this.signalOnShutdown(timeout, unit);
        this.outgoingMessageQueue.shutdown();
    }

    @Override
    public void shutdown() {
        this.shutdown(5L, DEFAULT_SHUTDOWN_TIMEOUT_UNITS);
    }

    public PublisherIdentifier getIdentifier() {
        return new PublisherIdentifier(this.nodeIdentifier, this.getTopicDeclaration().getIdentifier());
    }

    public PublisherDeclaration toDeclaration() {
        return PublisherDeclaration.newFromNodeIdentifier(this.nodeIdentifier, this.getTopicDeclaration());
    }

    @Override
    public boolean hasSubscribers() {
        return this.outgoingMessageQueue.getNumberOfChannels() > 0;
    }

    @Override
    public int getNumberOfSubscribers() {
        return this.outgoingMessageQueue.getNumberOfChannels();
    }

    @Override
    public T newMessage() {
        return (T)this.messageFactory.newFromType(this.getTopicDeclaration().getMessageType());
    }

    @Override
    public void publish(T message) {
        this.outgoingMessageQueue.add(message);
    }

    public ChannelBuffer finishHandshake(ConnectionHeader incomingHeader) {
        String expectedType;
        ConnectionHeader topicDefinitionHeader = this.getTopicDeclarationHeader();
        String incomingType = incomingHeader.getField("type");
        boolean messageTypeMatches = incomingType.equals(expectedType = topicDefinitionHeader.getField("type")) || incomingType.equals("*");
        Preconditions.checkState((boolean)messageTypeMatches, (Object)("Unexpected message type " + incomingType + " != " + expectedType));
        String incomingChecksum = incomingHeader.getField("md5sum");
        String expectedChecksum = topicDefinitionHeader.getField("md5sum");
        boolean checksumMatches = incomingChecksum.equals(expectedChecksum) || incomingChecksum.equals("*");
        Preconditions.checkState((boolean)checksumMatches, (Object)("Unexpected message MD5 " + incomingChecksum + " != " + expectedChecksum));
        ConnectionHeader outgoingConnectionHeader = this.toDeclaration().toConnectionHeader();
        outgoingConnectionHeader.addField("latching", this.getLatchMode() ? "1" : "0");
        return outgoingConnectionHeader.encode();
    }

    public void addSubscriber(SubscriberIdentifier subscriberIdentifer, Channel channel) {
        this.outgoingMessageQueue.addChannel(channel);
        this.signalOnNewSubscriber(subscriberIdentifer);
    }

    @Override
    public void addListener(PublisherListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void signalOnMasterRegistrationSuccess() {
        final DefaultPublisher publisher = this;
        this.listeners.signal(new SignalRunnable<PublisherListener<T>>(){

            @Override
            public void run(PublisherListener<T> listener) {
                listener.onMasterRegistrationSuccess(publisher);
            }
        });
    }

    @Override
    public void signalOnMasterRegistrationFailure() {
        final DefaultPublisher publisher = this;
        this.listeners.signal(new SignalRunnable<PublisherListener<T>>(){

            @Override
            public void run(PublisherListener<T> listener) {
                listener.onMasterRegistrationFailure(publisher);
            }
        });
    }

    @Override
    public void signalOnMasterUnregistrationSuccess() {
        final DefaultPublisher publisher = this;
        this.listeners.signal(new SignalRunnable<PublisherListener<T>>(){

            @Override
            public void run(PublisherListener<T> listener) {
                listener.onMasterUnregistrationSuccess(publisher);
            }
        });
    }

    @Override
    public void signalOnMasterUnregistrationFailure() {
        final DefaultPublisher publisher = this;
        this.listeners.signal(new SignalRunnable<PublisherListener<T>>(){

            @Override
            public void run(PublisherListener<T> listener) {
                listener.onMasterUnregistrationFailure(publisher);
            }
        });
    }

    private void signalOnNewSubscriber(final SubscriberIdentifier subscriberIdentifier) {
        final DefaultPublisher publisher = this;
        this.listeners.signal(new SignalRunnable<PublisherListener<T>>(){

            @Override
            public void run(PublisherListener<T> listener) {
                listener.onNewSubscriber(publisher, subscriberIdentifier);
            }
        });
    }

    private void signalOnShutdown(long timeout, TimeUnit unit) {
        final DefaultPublisher publisher = this;
        try {
            this.listeners.signal(new SignalRunnable<PublisherListener<T>>(){

                @Override
                public void run(PublisherListener<T> listener) {
                    listener.onShutdown(publisher);
                }
            }, timeout, unit);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String toString() {
        return "Publisher<" + this.toDeclaration() + ">";
    }
}

