/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.transport.tcp;

import com.google.common.base.Preconditions;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.ros.exception.RosRuntimeException;
import org.ros.internal.node.server.NodeIdentifier;
import org.ros.internal.node.service.DefaultServiceServer;
import org.ros.internal.node.service.ServiceManager;
import org.ros.internal.node.service.ServiceResponseEncoder;
import org.ros.internal.node.topic.DefaultPublisher;
import org.ros.internal.node.topic.SubscriberIdentifier;
import org.ros.internal.node.topic.TopicIdentifier;
import org.ros.internal.node.topic.TopicParticipantManager;
import org.ros.internal.transport.ConnectionHeader;
import org.ros.namespace.GraphName;

public class TcpServerHandshakeHandler
extends SimpleChannelHandler {
    private final TopicParticipantManager topicParticipantManager;
    private final ServiceManager serviceManager;

    public TcpServerHandshakeHandler(TopicParticipantManager topicParticipantManager, ServiceManager serviceManager) {
        this.topicParticipantManager = topicParticipantManager;
        this.serviceManager = serviceManager;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer incomingBuffer = (ChannelBuffer)e.getMessage();
        ChannelPipeline pipeline = e.getChannel().getPipeline();
        ConnectionHeader incomingHeader = ConnectionHeader.decode(incomingBuffer);
        if (incomingHeader.hasField("service")) {
            this.handleServiceHandshake(e, pipeline, incomingHeader);
        } else {
            this.handleSubscriberHandshake(ctx, e, pipeline, incomingHeader);
        }
    }

    private void handleServiceHandshake(MessageEvent e, ChannelPipeline pipeline, ConnectionHeader incomingHeader) {
        GraphName serviceName = GraphName.of(incomingHeader.getField("service"));
        Preconditions.checkState((boolean)this.serviceManager.hasServer(serviceName));
        DefaultServiceServer<?, ?> serviceServer = this.serviceManager.getServer(serviceName);
        e.getChannel().write((Object)serviceServer.finishHandshake(incomingHeader));
        String probe = incomingHeader.getField("probe");
        if (probe != null && probe.equals("1")) {
            e.getChannel().close();
        } else {
            pipeline.replace("LengthFieldPrepender", "ServiceResponseEncoder", (ChannelHandler)new ServiceResponseEncoder());
            pipeline.replace((ChannelHandler)this, "ServiceRequestHandler", serviceServer.newRequestHandler());
        }
    }

    private void handleSubscriberHandshake(ChannelHandlerContext ctx, MessageEvent e, ChannelPipeline pipeline, ConnectionHeader incomingConnectionHeader) throws InterruptedException, Exception {
        Preconditions.checkState((boolean)incomingConnectionHeader.hasField("topic"), (Object)"Handshake header missing field: topic");
        GraphName topicName = GraphName.of(incomingConnectionHeader.getField("topic"));
        Preconditions.checkState((boolean)this.topicParticipantManager.hasPublisher(topicName), (Object)("No publisher for topic: " + topicName));
        DefaultPublisher<?> publisher = this.topicParticipantManager.getPublisher(topicName);
        ChannelBuffer outgoingBuffer = publisher.finishHandshake(incomingConnectionHeader);
        Channel channel = ctx.getChannel();
        ChannelFuture future = channel.write((Object)outgoingBuffer).await();
        if (!future.isSuccess()) {
            throw new RosRuntimeException(future.getCause());
        }
        String nodeName = incomingConnectionHeader.getField("callerid");
        publisher.addSubscriber(new SubscriberIdentifier(NodeIdentifier.forName(nodeName), new TopicIdentifier(topicName)), channel);
        pipeline.replace((ChannelHandler)this, "DiscardHandler", (ChannelHandler)new SimpleChannelHandler());
    }
}

