/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.resource.BPELResourceSetImpl;
import org.eclipse.bpel.model.resource.SAXParseDiagnostic;
import org.eclipse.bpel.validator.BPELReader;
import org.eclipse.bpel.validator.factory.AdapterFactory;
import org.eclipse.bpel.validator.helpers.ModelQueryImpl;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.Messages;
import org.eclipse.bpel.validator.model.Problem;
import org.eclipse.bpel.validator.model.Runner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.wst.wsdl.WSDLElement;
import org.w3c.dom.Element;

public class Builder
extends IncrementalProjectBuilder {
    public static final String BPEL_CONTENT_TYPE = "org.eclipse.bpel.contenttype";
    Date created = new Date();
    boolean bDebug = false;
    IProblem[] EMPTY_PROBLEMS = new IProblem[0];
    IAdapterManager fAdapterManager = Platform.getAdapterManager();
    BPELResourceSetImpl fResourceSet = new BPELResourceSetImpl();
    BPELReader fReader = new BPELReader();

    public Builder() {
        this.p("Created on " + this.created);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config, propertyName, data);
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        long started = System.currentTimeMillis();
        if (args != null) {
            this.bDebug = this.toBoolean(args.get("debug"), false);
        }
        AdapterFactory.DEBUG = this.bDebug;
        if (this.bDebug) {
            this.p("Clear error messages from the cache ... (will re-load)");
            Messages.clear();
        }
        this.clearCach();
        IProject myProject = this.getProject();
        IResourceDelta resourceDelta = this.getDelta(myProject);
        if (resourceDelta == null) {
            this.validate((IResource)myProject, monitor);
        } else {
            this.processDeltas(resourceDelta.getAffectedChildren(4), monitor);
        }
        long ended = System.currentTimeMillis();
        this.p(" Validation Ended " + (ended - started) + "ms");
        return new IProject[]{myProject};
    }

    void processDeltas(IResourceDelta[] deltas, IProgressMonitor monitor) throws CoreException {
        IResourceDelta[] iResourceDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta = iResourceDeltaArray[n2];
            this.processDeltas(delta.getAffectedChildren(4, 1), monitor);
            IResource resource = delta.getResource();
            if (resource.getType() == 1 && (delta.getFlags() & 0x100) == 256) {
                this.fResourceSet.resourceChanged((IFile)resource);
                this.validate(resource, monitor);
            }
            ++n2;
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        Builder.removeProblemsAndTasksFor((IResource)this.getProject());
    }

    public static void removeProblemsAndTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclispe.bpel.validator.marker", false, 2);
            }
        }
        catch (CoreException coreException) {}
    }

    public void validate(IResource resource, IProgressMonitor monitor) throws CoreException {
        Map loadOptions = this.fResourceSet.getLoadOptions();
        loadOptions.put("TRACK_LOCATION", Boolean.TRUE);
        this.fResourceSet.setLoadOptions(loadOptions);
        switch (resource.getType()) {
            case 2: {
                IFolder folder = (IFolder)resource;
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource next = iResourceArray[n2];
                    this.validate(next, monitor);
                    ++n2;
                }
                break;
            }
            case 1: {
                IFile file = (IFile)resource;
                this.p("File Resource : " + file.getName());
                if (!Builder.isBPELFile((IResource)file) && !"wsdl".equalsIgnoreCase(file.getFileExtension())) break;
                IProject project = file.getProject();
                this.validate((IResource)project, monitor);
                break;
            }
            case 4: {
                for (IFile bpelFile : this.getBPELFilesByProject((IProject)resource)) {
                    this.p("File Resource : " + bpelFile.getName());
                    bpelFile.deleteMarkers("org.eclispe.bpel.validator.marker", true, 2);
                    this.deleteMarkersInReferencialResources(bpelFile);
                    this.makeMarkers(this.validate(bpelFile, monitor));
                }
                break;
            }
        }
    }

    private List<IFile> getBPELFilesByProject(IProject project) {
        final ArrayList<IFile> bpelFolders = new ArrayList<IFile>();
        IResourceVisitor bpelFolderFinder = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource.getType() == 1 && Builder.isBPELFile(resource)) {
                    bpelFolders.add((IFile)resource);
                    return false;
                }
                return true;
            }
        };
        try {
            project.accept(bpelFolderFinder);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return bpelFolders;
    }

    private void deleteMarkersInReferencialResources(IFile bpelFile) throws CoreException {
        this.fResourceSet.resourceChanged(bpelFile);
        this.fReader.read(bpelFile, (ResourceSet)this.fResourceSet);
        Process process = this.fReader.getProcess();
        this.p("Delete markers");
        if (process == null) {
            this.p("Cannot read BPEL Process !!!");
            return;
        }
        IContainer container = bpelFile.getParent();
        for (Import impt : process.getImports()) {
            String fileLocation = impt.getLocation();
            IFile importedFile = container.getFile((IPath)new Path(fileLocation));
            if (importedFile == null || !importedFile.exists()) continue;
            importedFile.deleteMarkers("org.eclispe.bpel.validator.marker", false, 0);
        }
    }

    public void clearCach() {
        this.fResourceSet.getResources().clear();
    }

    public IProblem[] validate(IFile file, IProgressMonitor monitor) {
        this.p("Validating BPEL Resource : " + file.getName());
        this.fResourceSet.resourceChanged(file);
        this.fReader.read(file, (ResourceSet)this.fResourceSet);
        Process process = this.fReader.getProcess();
        if (process == null) {
            Resource resource = this.fReader.getProcessResource();
            if (resource != null && !resource.getErrors().isEmpty()) {
                ArrayList<Problem> problems = new ArrayList<Problem>(resource.getErrors().size());
                for (Resource.Diagnostic d : resource.getErrors()) {
                    Problem problem = new Problem();
                    problem.setAttribute("eResource", resource);
                    if (d instanceof SAXParseDiagnostic && ((SAXParseDiagnostic)d).getSeverity() == 1) {
                        problem.setAttribute("severity", 1);
                    } else {
                        problem.setAttribute("severity", 2);
                    }
                    problem.setAttribute("lineNumber", d.getLine());
                    problem.setAttribute("columnNumber", d.getColumn());
                    problem.setAttribute("message", d.getMessage());
                    problems.add(problem);
                }
                return problems.toArray(new Problem[problems.size()]);
            }
            this.p("Cannot read BPEL Process !!!");
            return this.EMPTY_PROBLEMS;
        }
        this.p("Read in BPEL Model OK");
        this.linkModels((EObject)process);
        this.p("Models Linked");
        INode node = (INode)this.fAdapterManager.getAdapter((Object)process.getElement(), INode.class);
        IProblem[] problemList = new Runner(ModelQueryImpl.getModelQuery(), node).run();
        this.p("Validator Executed");
        return problemList;
    }

    public void makeMarkers(IProblem[] problemList) {
        if (problemList.length < 1) {
            return;
        }
        IProblem[] iProblemArray = problemList;
        int n = problemList.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            this.fAdapterManager.getAdapter((Object)problem, IMarker.class);
            ++n2;
        }
        this.p("Markers Created ");
        this.p(" ------ Done");
    }

    void linkModels(EObject process) {
        TreeIterator emfIterator = process.eAllContents();
        while (emfIterator.hasNext()) {
            WSDLElement wsdle;
            Element el;
            Object obj = emfIterator.next();
            if (!(obj instanceof WSDLElement) || (el = (wsdle = (WSDLElement)obj).getElement()) == null) continue;
            el.setUserData("emf.model", obj, null);
        }
    }

    boolean toBoolean(Object obj, boolean def) {
        if (obj instanceof String) {
            return Boolean.valueOf((String)obj);
        }
        return def;
    }

    void p(String msg) {
        if (this.bDebug) {
            System.out.printf("[%1$s]>> %2$s\n", ((Object)((Object)this)).getClass().getName(), msg);
            System.out.flush();
        }
    }

    public static boolean isBPELFile(IResource res) {
        try {
            IContentType type;
            IContentDescription desc;
            if (res.getType() == 1 && (desc = ((IFile)res).getContentDescription()) != null && (type = desc.getContentType()).getId().equals(BPEL_CONTENT_TYPE)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }
}

