/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.service;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.actions.generator.plantuml.ActionsUmlGenerator;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionConstantBool;
import org.eclipse.comma.expressions.expression.ExpressionConstantInt;
import org.eclipse.comma.expressions.expression.ExpressionConstantReal;
import org.eclipse.comma.expressions.expression.ExpressionConstantString;
import org.eclipse.comma.expressions.expression.ExpressionEnumLiteral;
import org.eclipse.comma.expressions.generator.plantuml.ExpressionsUmlGenerator;
import org.eclipse.comma.project.project.ProjectDescription;
import org.eclipse.comma.signature.comments.InterfaceEventComment;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.comments.SLCommentLocator;
import org.eclipse.comma.types.types.Dimension;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.MapTypeConstructor;
import org.eclipse.comma.types.types.MapTypeDecl;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.comma.types.utilities.CommaUtilities;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.impl.MImageImpl;

public class DocService {
    private static final String VERSION_TEXT = "This document is generated by CommaSuite version " + CommaUtilities.commaVersion() + ".";

    public String getComMAVersionText(ProjectDescription pd) {
        return VERSION_TEXT;
    }

    public List<SimpleTypeDecl> getSimpleTypes(Signature i) {
        return this.getSimpleTypes((List<TypeDecl>)i.getTypes());
    }

    public List<SimpleTypeDecl> getSimpleTypes(ProjectDescription pd, List<TypeDecl> types) {
        return this.getSimpleTypes(types);
    }

    public List<SimpleTypeDecl> getSimpleTypes(List<TypeDecl> types) {
        ArrayList<SimpleTypeDecl> result = new ArrayList<SimpleTypeDecl>();
        for (TypeDecl t : types) {
            if (!(t instanceof SimpleTypeDecl)) continue;
            result.add((SimpleTypeDecl)t);
        }
        return result;
    }

    public List<EnumTypeDecl> getEnums(Signature i) {
        return this.getEnums((List<TypeDecl>)i.getTypes());
    }

    public List<EnumTypeDecl> getEnums(ProjectDescription p, List<TypeDecl> types) {
        return this.getEnums(types);
    }

    public List<EnumTypeDecl> getEnums(List<TypeDecl> types) {
        ArrayList<EnumTypeDecl> result = new ArrayList<EnumTypeDecl>();
        for (TypeDecl t : types) {
            if (!(t instanceof EnumTypeDecl)) continue;
            result.add((EnumTypeDecl)t);
        }
        return result;
    }

    public List<RecordTypeDecl> getRecordTypes(Signature i) {
        return this.getRecordTypes((List<TypeDecl>)i.getTypes());
    }

    public List<RecordTypeDecl> getRecordTypes(ProjectDescription p, List<TypeDecl> types) {
        return this.getRecordTypes(types);
    }

    public List<RecordTypeDecl> getRecordTypes(List<TypeDecl> types) {
        ArrayList<RecordTypeDecl> result = new ArrayList<RecordTypeDecl>();
        for (TypeDecl t : types) {
            if (!(t instanceof RecordTypeDecl)) continue;
            result.add((RecordTypeDecl)t);
        }
        return result;
    }

    public List<VectorTypeDecl> getVectorTypes(Signature i) {
        return this.getVectorTypes((List<TypeDecl>)i.getTypes());
    }

    public List<VectorTypeDecl> getVectorTypes(ProjectDescription p, List<TypeDecl> types) {
        return this.getVectorTypes(types);
    }

    public List<VectorTypeDecl> getVectorTypes(List<TypeDecl> types) {
        ArrayList<VectorTypeDecl> result = new ArrayList<VectorTypeDecl>();
        for (TypeDecl t : types) {
            if (!(t instanceof VectorTypeDecl)) continue;
            result.add((VectorTypeDecl)t);
        }
        return result;
    }

    public boolean isNull(Object o) {
        return o == null;
    }

    public boolean isTriggeredTransition(Transition t) {
        return t instanceof TriggeredTransition;
    }

    public String getTypeName(Type t) {
        StringBuilder builder = new StringBuilder();
        if (t instanceof TypeReference) {
            TypeDecl td = ((TypeReference)t).getType();
            if (td instanceof EnumTypeDecl) {
                builder.append("enum ");
            } else if (td instanceof RecordTypeDecl) {
                builder.append("record ");
            } else if (td instanceof VectorTypeDecl) {
                builder.append("vector ");
            } else if (td instanceof SimpleTypeDecl) {
                builder.append("");
            } else if (td instanceof MapTypeDecl) {
                builder.append("map ");
            }
            builder.append(td.getName());
        } else if (t instanceof VectorTypeConstructor) {
            VectorTypeConstructor vtc = (VectorTypeConstructor)t;
            builder.append(vtc.getType().getName());
            for (Dimension d : vtc.getDimensions()) {
                builder.append("[");
                if (d.getSize() != 0) {
                    builder.append(d.getSize());
                }
                builder.append("]");
            }
        } else if (t instanceof MapTypeConstructor) {
            MapTypeConstructor mtc = (MapTypeConstructor)t;
            builder.append("map<").append(mtc.getType().getName()).append(", ").append(this.getTypeName(mtc.getValueType())).append(">");
        }
        return builder.toString();
    }

    public String getStringFromExpression(Expression expr) {
        if (expr == null) {
            return "";
        }
        ExpressionsUmlGenerator exprConverter = new ExpressionsUmlGenerator("", null);
        return exprConverter.generateExpression(expr).toString();
    }

    public String getStringFromAssignment(Action act) {
        if (act == null) {
            return "";
        }
        return new ActionsUmlGenerator("", null).generateAction((EObject)act).toString();
    }

    public String getVariableName(Action act) {
        if (act instanceof AssignmentAction) {
            return ((AssignmentAction)act).getAssignment().getName();
        }
        return "";
    }

    public String getValue(Action act) {
        if (act instanceof AssignmentAction) {
            return new ActionsUmlGenerator("", null).generateExpression(((AssignmentAction)act).getExp()).toString();
        }
        return "";
    }

    public MImage getDiagram(EObject anObject, String projectPath, String artefactName, Interface behavior) {
        String behaviorFileName = behavior.eResource().getURI().trimFileExtension().lastSegment();
        String path = String.valueOf(projectPath) + behaviorFileName + "_" + artefactName;
        ResourceSet resourceSet = behavior.eResource().getResourceSet();
        if (anObject instanceof StateMachine) {
            path = String.valueOf(path) + "_complete";
        }
        URI uris = URI.createFileURI((String)(String.valueOf(path) + ".png"));
        return new MImageImpl(resourceSet.getURIConverter(), uris);
    }

    public String getDocumentation(EObject anObject) {
        String documentation = this.getDocumentationString(anObject);
        return documentation.replace("\n", " ");
    }

    public String getInlineDocumentation(EObject anObject) {
        return SLCommentLocator.getSLComment((EObject)anObject);
    }

    public boolean returnsVoid(Command ev) {
        return TypeUtilities.isVoid((Type)ev.getType());
    }

    public InterfaceEventComment getCommentObject(InterfaceEvent ev) {
        String coms = this.getDocumentationString((EObject)ev);
        return new InterfaceEventComment(ev, coms);
    }

    public String getReturnComment(InterfaceEventComment coms) {
        return coms.getReturnComment();
    }

    public String getEventComment(InterfaceEventComment coms) {
        return coms.getEventComment();
    }

    public String getCommentForParam(InterfaceEventComment coms, String pName) {
        return coms.getCommentForParam(pName);
    }

    public String formatText(String s) {
        String result = s.replace("\n", "");
        return result.replaceAll("\\s\\s+", " ");
    }

    private String getDocumentationString(EObject anObject) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
            }
        }});
        IEObjectDocumentationProvider documentationProvider = (IEObjectDocumentationProvider)injector.getInstance(IEObjectDocumentationProvider.class);
        String documentation = documentationProvider.getDocumentation(anObject);
        if (documentation != null) {
            return documentation;
        }
        return "";
    }

    public String getPossibleActions(Clause c) {
        List eventCalls = EcoreUtil2.getAllContentsOfType((EObject)c, EventCall.class);
        List replies = EcoreUtil2.getAllContentsOfType((EObject)c, CommandReply.class);
        if (eventCalls.isEmpty() && replies.isEmpty()) {
            return "-";
        }
        String result = "";
        HashMap<InterfaceEvent, EventCall> usedEvents = new HashMap<InterfaceEvent, EventCall>();
        for (EventCall evcall : eventCalls) {
            usedEvents.put(evcall.getEvent(), evcall);
        }
        for (InterfaceEvent e : usedEvents.keySet()) {
            result = String.valueOf(result) + e.getName() + "\n";
        }
        if (!replies.isEmpty()) {
            boolean bareReplyFound = false;
            for (CommandReply r : replies) {
                String replyAsString = this.getStringFromReply(r);
                if (replyAsString.equals("reply")) {
                    result = String.valueOf(result) + (!bareReplyFound ? "reply\n" : "");
                    bareReplyFound = true;
                    continue;
                }
                result = String.valueOf(result) + replyAsString + "\n";
            }
        }
        return result.substring(0, result.length() - 1);
    }

    public String getStringFromReply(CommandReply r) {
        Expression exp;
        if (!r.getParameters().isEmpty() && ((exp = (Expression)r.getParameters().get(0)) instanceof ExpressionConstantBool || exp instanceof ExpressionConstantInt || exp instanceof ExpressionConstantReal || exp instanceof ExpressionConstantString || exp instanceof ExpressionEnumLiteral)) {
            return "reply(" + new ExpressionsUmlGenerator("", null).generateExpression(exp).toString() + ")";
        }
        return "reply";
    }
}

