/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge.compat.packageadmin;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Capability;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PackageAdminImpl
implements PackageAdmin {
    private final BundleContext context;
    protected static final Comparator<ExportedPackage> EXPORT_ORDER = new Comparator<ExportedPackage>(){

        @Override
        public int compare(ExportedPackage c1, ExportedPackage c2) {
            BundleWiring wiring2;
            BundleCapability cap1 = ((ExportedPackageImpl)c1).cap;
            BundleCapability cap2 = ((ExportedPackageImpl)c2).cap;
            int cap1Resolved = cap1.getResource().getWiring() == null ? 0 : 1;
            int cap2Resolved = cap2.getResource().getWiring() == null ? 0 : 1;
            int score = cap2Resolved - cap1Resolved;
            if (score != 0) {
                return score;
            }
            BundleWiring wiring1 = cap1.getResource().getWiring();
            if (wiring1 != null) {
                List wires = wiring1.getProvidedWires("osgi.wiring.package");
                for (BundleWire wire : wires) {
                    if (!wire.getCapability().equals(cap1)) continue;
                    score = -1;
                    break;
                }
            }
            if ((wiring2 = cap2.getResource().getWiring()) != null) {
                List wires = wiring2.getProvidedWires("osgi.wiring.package");
                for (BundleWire wire : wires) {
                    score = 1;
                    if (!wire.getCapability().equals(cap2)) continue;
                    ++score;
                    break;
                }
            }
            if (score != 0) {
                return score;
            }
            Version cap1Version = (Version)cap1.getAttributes().get("version");
            Version cap2Version = (Version)cap2.getAttributes().get("version");
            if (cap1Version == null) {
                cap1Version = Version.emptyVersion;
            }
            if (cap2Version == null) {
                cap2Version = Version.emptyVersion;
            }
            if ((score = cap2Version.compareTo(cap1Version)) != 0) {
                return score;
            }
            long cap1BundleId = cap1.getRevision().getBundle().getBundleId();
            long cap2BundleId = cap2.getRevision().getBundle().getBundleId();
            return (int)(cap1BundleId - cap2BundleId);
        }
    };

    PackageAdminImpl(BundleContext context) {
        this.context = context;
    }

    @Override
    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        if (bundle == null) {
            return this.getExportedPackages((String)null);
        }
        ArrayList<ExportedPackage> result = new ArrayList<ExportedPackage>();
        this.getExportedPackages0(bundle, null, result);
        return this.toArrayOrNull(result, ExportedPackage.class);
    }

    @Override
    public ExportedPackage[] getExportedPackages(String name) {
        Bundle[] bundles = this.context.getBundles();
        ArrayList<ExportedPackage> result = new ArrayList<ExportedPackage>();
        for (Bundle bundle : bundles) {
            this.getExportedPackages0(bundle, name, result);
        }
        return this.toArrayOrNull(result, ExportedPackage.class);
    }

    private void getExportedPackages0(Bundle bundle, String name, ArrayList<ExportedPackage> result) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle==null");
        }
        if (result == null) {
            throw new IllegalArgumentException("result==null");
        }
        List revs = ((BundleRevisions)bundle.adapt(BundleRevisions.class)).getRevisions();
        if (revs.isEmpty()) {
            return;
        }
        for (BundleRevision r : revs) {
            BundleWiring wiring = r.getWiring();
            if (wiring == null || !wiring.isInUse()) continue;
            for (Capability cap : wiring.getCapabilities("osgi.wiring.package")) {
                if (name != null && !name.equals(cap.getAttributes().get("osgi.wiring.package"))) continue;
                result.add(new ExportedPackageImpl((BundleCapability)cap));
            }
        }
    }

    @Override
    public ExportedPackage getExportedPackage(String name) {
        Bundle[] bundles = this.context.getBundles();
        ArrayList<ExportedPackage> result = new ArrayList<ExportedPackage>();
        for (Bundle bundle : bundles) {
            this.getExportedPackages0(bundle, name, result);
        }
        if (result.isEmpty()) {
            return null;
        }
        Collections.sort(result, EXPORT_ORDER);
        System.err.println("MY ORDER IS " + result);
        for (ExportedPackage p : result) {
            System.err.println(p + " exporter " + p.getExportingBundle());
        }
        return result.get(0);
    }

    private FrameworkWiring getFrameworkWiring() {
        return (FrameworkWiring)this.context.getBundle(0L).adapt(FrameworkWiring.class);
    }

    @Override
    public void refreshPackages(Bundle[] bundles) {
        FrameworkWiring wiring = this.getFrameworkWiring();
        wiring.refreshBundles(bundles == null ? null : Arrays.asList(bundles), new FrameworkListener[0]);
    }

    @Override
    public boolean resolveBundles(Bundle[] bundles) {
        FrameworkWiring wiring = this.getFrameworkWiring();
        return wiring.resolveBundles(bundles == null ? null : Arrays.asList(bundles));
    }

    @Override
    public RequiredBundle[] getRequiredBundles(String symbolicName) {
        Bundle[] bundles = this.context.getBundles();
        ArrayList<RequiredBundleImpl> result = new ArrayList<RequiredBundleImpl>();
        for (Bundle bundle : bundles) {
            BundleRevision rev;
            if (bundle.getState() == 2 || bundle.getState() == 1 || this.isFragment(rev = (BundleRevision)bundle.adapt(BundleRevision.class)) || symbolicName != null && !symbolicName.equals(rev.getSymbolicName())) continue;
            result.add(new RequiredBundleImpl(rev));
        }
        return this.toArrayOrNull(result, RequiredBundle.class);
    }

    private void addRequiringBundles(BundleWiring wiring, ArrayList<Bundle> result) {
        List wires = wiring.getProvidedWires("osgi.wiring.bundle");
        for (BundleWire wire : wires) {
            result.add(wire.getRequirer().getBundle());
            if (!"reexport".equals(wire.getRequirement().getDirectives().get("visibility"))) continue;
            this.addRequiringBundles(wire.getRequirer().getWiring(), result);
        }
    }

    @Override
    public Bundle[] getBundles(String symbolicName, String versionRange) {
        if (symbolicName == null) {
            throw new IllegalArgumentException("symbolicName is null");
        }
        VersionRange range = versionRange == null ? null : new VersionRange(versionRange);
        Bundle[] bundles = this.context.getBundles();
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        for (Bundle bundle : bundles) {
            if (!symbolicName.equals(bundle.getSymbolicName()) || range != null && !range.includes(bundle.getVersion())) continue;
            result.add(bundle);
        }
        if (result.isEmpty()) {
            return null;
        }
        Collections.sort(result, new Comparator<Bundle>(){

            @Override
            public int compare(Bundle b1, Bundle b2) {
                return b2.getVersion().compareTo(b1.getVersion());
            }
        });
        return result.toArray(new Bundle[result.size()]);
    }

    @Override
    public Bundle[] getFragments(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            return null;
        }
        List wires = wiring.getProvidedWires("osgi.wiring.host");
        if (wires == null || wires.isEmpty()) {
            return null;
        }
        Bundle[] result = new Bundle[wires.size()];
        Iterator iter = wires.iterator();
        for (int i = 0; i < result.length; ++i) {
            BundleWire wire = (BundleWire)iter.next();
            result[i] = wire.getRequirer().getBundle();
        }
        return result;
    }

    @Override
    public Bundle[] getHosts(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            return null;
        }
        List wires = wiring.getRequiredWires("osgi.wiring.host");
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        for (BundleWire wire : wires) {
            if (wire.getRequirer().getBundle() != bundle) continue;
            result.add(wire.getProvider().getBundle());
        }
        return this.toArrayOrNull(result, Bundle.class);
    }

    @Override
    public Bundle getBundle(Class clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof BundleReference) {
            return ((BundleReference)cl).getBundle();
        }
        return null;
    }

    @Override
    public int getBundleType(Bundle bundle) {
        BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
        return this.isFragment(rev) ? 1 : 0;
    }

    private boolean isFragment(BundleRevision rev) {
        return !rev.getRequirements("osgi.wiring.host").isEmpty();
    }

    private <T> T[] toArrayOrNull(List<T> l, Class<T> t) {
        if (l == null || l.isEmpty()) {
            return null;
        }
        return l.toArray((Object[])Array.newInstance(t, l.size()));
    }

    private class RequiredBundleImpl
    implements RequiredBundle {
        private final BundleRevision rev;

        public RequiredBundleImpl(BundleRevision rev) {
            this.rev = rev;
        }

        public String getSymbolicName() {
            return this.rev.getSymbolicName();
        }

        public Bundle getBundle() {
            return this.rev.getBundle();
        }

        public Bundle[] getRequiringBundles() {
            ArrayList result = new ArrayList();
            BundleWiring wiring = this.rev.getWiring();
            if (wiring != null) {
                PackageAdminImpl.this.addRequiringBundles(wiring, result);
            }
            return (Bundle[])PackageAdminImpl.this.toArrayOrNull(result, Bundle.class);
        }

        public Version getVersion() {
            return this.rev.getVersion();
        }

        public boolean isRemovalPending() {
            return this.rev.getBundle().getState() == 1 || this.rev.getBundle().adapt(BundleRevision.class) != this.rev;
        }

        public String toString() {
            return "RequiredBundle{" + this.rev.toString();
        }
    }

    private class ExportedPackageImpl
    implements ExportedPackage {
        final BundleCapability cap;

        ExportedPackageImpl(BundleCapability cap) {
            this.cap = cap;
        }

        public String getName() {
            return (String)this.cap.getAttributes().get("osgi.wiring.package");
        }

        public Bundle getExportingBundle() {
            return this.cap.getResource().getBundle();
        }

        public Bundle[] getImportingBundles() {
            ArrayList<Bundle> result = new ArrayList<Bundle>();
            BundleWiring wiring = this.cap.getResource().getWiring();
            if (wiring != null) {
                List wires = wiring.getProvidedWires("osgi.wiring.package");
                for (BundleWire wire : wires) {
                    Bundle b;
                    if (!wire.getCapability().equals(this.cap) || (b = wire.getRequirer().getBundle()) == this.cap.getResource().getBundle()) continue;
                    result.add(wire.getRequirer().getBundle());
                }
                PackageAdminImpl.this.addRequiringBundles(wiring, result);
            }
            return (Bundle[])PackageAdminImpl.this.toArrayOrNull(result, Bundle.class);
        }

        public String getSpecificationVersion() {
            Version version = this.getVersion();
            return version == null ? null : version.toString();
        }

        public Version getVersion() {
            return (Version)this.cap.getAttributes().get("version");
        }

        public boolean isRemovalPending() {
            BundleRevision rev = this.cap.getResource();
            return rev.getBundle().getState() == 1 || rev.getBundle().adapt(BundleRevision.class) != rev;
        }

        public String toString() {
            return this.cap.toString();
        }
    }
}

