/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.concierge.AbstractBundle;
import org.eclipse.concierge.Concierge;
import org.eclipse.concierge.ConciergeCollections;
import org.eclipse.concierge.RFC1960Filter;
import org.eclipse.concierge.Resources;
import org.eclipse.concierge.ServiceReferenceImpl;
import org.eclipse.concierge.Utils;
import org.eclipse.concierge.compat.LegacyBundleProcessing;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.HostedCapability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleImpl
extends AbstractBundle
implements BundleStartLevel {
    protected static final Method dexFileLoader;
    protected static final Method dexClassLoader;
    protected static final Pattern DIRECTIVE_LIST;
    private static final int TIMEOUT = 10000;
    private static final String BUNDLE_FILE_NAME = "bundle";
    private static final String CONTENT_DIRECTORY_NAME = "content";
    private static final short FRAGMENT_ATTACHMENT_NEVER = -1;
    private static final short FRAGMENT_ATTACHMENT_RESOLVETIME = 1;
    private static final short FRAGMENT_ATTACHMENT_ALWAYS = 2;
    private String symbolicName;
    private Version version;
    protected static ThreadLocal<ArrayList<AbstractBundle>> activationChain;
    protected List<BundleImpl> hostBundles;
    protected final Concierge framework;
    protected boolean lazyActivation;
    protected boolean beingLazy = false;
    protected String[] activationIncludes;
    protected String[] activationExcludes;
    protected String bundleLocalizationBaseDir;
    protected String bundleLocalizationBaseFilename;
    protected HeaderDictionary headers;
    private Locale lastDefaultLocale;
    private int currentRevisionNumber = -1;

    public BundleImpl(Concierge framework, BundleContext installingContext, String location, long bundleId, InputStream stream) throws BundleException {
        this.framework = framework;
        this.location = location;
        this.bundleId = bundleId;
        this.startlevel = framework.initStartlevel;
        this.lastModified = System.currentTimeMillis();
        if (framework.SECURITY_ENABLED) {
            try {
                Permissions permissions = new Permissions();
                ((PermissionCollection)permissions).add(new FilePermission(framework.STORAGE_LOCATION + bundleId, "read,write,execute,delete"));
                this.domain = new ProtectionDomain(new CodeSource(new URL("file:" + framework.STORAGE_LOCATION + bundleId), (Certificate[])null), permissions);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BundleException("Exception while installing bundle", 7, e);
            }
        }
        this.storageLocation = framework.STORAGE_LOCATION + bundleId + File.separatorChar;
        this.currentRevision = this.readAndProcessInputStream(stream);
        this.symbolicName = this.currentRevision.getSymbolicName();
        this.version = this.currentRevision.getVersion();
        this.revisions.add(0, this.currentRevision);
        framework.checkForCollision(1, installingContext.getBundle(), this.currentRevision);
        this.state = 2;
        if (framework.state != 8 && framework.state != 16) {
            this.updateMetadata();
        }
    }

    public BundleImpl(Concierge framework, File metadata) throws IOException, BundleException {
        this.framework = framework;
        DataInputStream in = new DataInputStream(new FileInputStream(metadata));
        this.currentRevisionNumber = in.readInt();
        this.bundleId = in.readLong();
        this.location = in.readUTF();
        this.storageLocation = framework.STORAGE_LOCATION + this.bundleId + File.separatorChar;
        File file = new File(this.storageLocation, BUNDLE_FILE_NAME + this.currentRevisionNumber);
        File contentDir = new File(this.storageLocation + CONTENT_DIRECTORY_NAME + this.currentRevisionNumber);
        if (file.exists() && file.isFile()) {
            JarFile jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            String[] classpathStrings = BundleImpl.readProperties(manifest.getMainAttributes(), "Bundle-ClassPath", new String[]{"."});
            this.currentRevision = new JarBundleRevision(this.currentRevisionNumber, jarFile, manifest, classpathStrings);
        } else if (contentDir.exists() && contentDir.isDirectory()) {
            Manifest manifest = new Manifest(new FileInputStream(new File(contentDir, "META-INF/MANIFEST.MF")));
            String[] classpathStrings = BundleImpl.readProperties(manifest.getMainAttributes(), "Bundle-ClassPath", new String[]{"."});
            this.currentRevision = new ExplodedJarBundleRevision(this.currentRevisionNumber, contentDir.getAbsolutePath(), manifest, classpathStrings);
        } else {
            in.close();
            throw new BundleException("Bundle revision " + this.currentRevisionNumber + " does not exist", 11);
        }
        this.symbolicName = this.currentRevision.getSymbolicName();
        this.version = this.currentRevision.getVersion();
        this.revisions.add(0, this.currentRevision);
        this.startlevel = in.readInt();
        this.state = 2;
        this.autostart = in.readShort();
        this.lazyActivation = in.readBoolean();
        this.lastModified = in.readLong();
        in.close();
        this.context = framework.createBundleContext(this);
        System.err.println("RESTORED BUNDLE " + this.toString() + " WITH SL " + this.startlevel + " and autostart " + this.autostart);
        if (framework.SECURITY_ENABLED) {
            this.domain = new ProtectionDomain(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateMetadata() {
        FilterOutputStream out = null;
        try {
            out = new DataOutputStream(new FileOutputStream(new File(this.storageLocation, "meta")));
            ((DataOutputStream)out).writeInt(this.currentRevisionNumber);
            ((DataOutputStream)out).writeLong(this.bundleId);
            ((DataOutputStream)out).writeUTF(this.location);
            ((DataOutputStream)out).writeInt(this.startlevel);
            ((DataOutputStream)out).writeShort(this.autostart);
            ((DataOutputStream)out).writeBoolean(this.lazyActivation);
            ((DataOutputStream)out).writeLong(this.lastModified);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Revision readAndProcessInputStream(InputStream inStream) throws BundleException {
        int revisionNumber = ++this.currentRevisionNumber;
        try {
            File file = new File(this.storageLocation, BUNDLE_FILE_NAME + revisionNumber);
            BundleImpl.storeFile(file, inStream);
            JarFile jar = new JarFile(file, false);
            Manifest manifest = jar.getManifest();
            String[] classpathStrings = BundleImpl.readProperties(manifest.getMainAttributes(), "Bundle-ClassPath", new String[]{"."});
            if (this.framework.ALWAYS_DECOMPRESS || this.framework.DECOMPRESS_EMBEDDED && classpathStrings.length > 1) {
                File contentDir = new File(this.storageLocation + CONTENT_DIRECTORY_NAME + revisionNumber);
                if (contentDir.exists()) {
                    Concierge.deleteDirectory(contentDir);
                }
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    File embeddedJar = new File(contentDir, entry.getName());
                    BundleImpl.storeFile(embeddedJar, jar.getInputStream(entry));
                }
                jar.close();
                new File(jar.getName()).delete();
                return new ExplodedJarBundleRevision(revisionNumber, contentDir.getAbsolutePath(), manifest, classpathStrings);
            }
            return new JarBundleRevision(revisionNumber, jar, manifest, classpathStrings);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            Concierge.deleteDirectory(new File(this.storageLocation));
            throw new BundleException("Not a valid bundle: " + this.location + " (tried to write to " + new File(this.storageLocation, BUNDLE_FILE_NAME + revisionNumber) + ")", 11, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void install() throws BundleException {
        Concierge concierge = this.framework;
        synchronized (concierge) {
            this.framework.bundles.add(this);
            this.framework.bundleID_bundles.put(new Long(this.getBundleId()), this);
            this.framework.symbolicName_bundles.insert(this.currentRevision.getSymbolicName(), this);
            this.framework.location_bundles.put(this.location, this);
        }
        if (this.currentRevision.isFrameworkExtension()) {
            this.currentRevision.resolve(false);
        }
    }

    @Override
    public void start() throws BundleException {
        this.start(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int options) throws BundleException {
        if (this.framework.SECURITY_ENABLED) {
            // empty if block
        }
        if (this.state == 1) {
            throw new IllegalStateException("Cannot start uninstalled bundle " + this.toString());
        }
        if (this.currentRevision.isFragment()) {
            throw new BundleException("The fragment bundle " + this.toString() + " cannot be started", 2);
        }
        if (!(this.lazyActivation || this.state != 8 && this.state != 16)) {
            try {
                BundleImpl bundleImpl = this;
                synchronized (bundleImpl) {
                    this.wait(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.state == 8 || this.state == 16) {
                throw new BundleException("Timeout occurred. Bundle was unable to start.", 7);
            }
        }
        if ((options & 1) > 0) {
            if (this.startlevel > this.framework.startlevel) {
                throw new BundleException("Bundle (with start level " + this.startlevel + ") cannot be started due to the framework's current start level of " + this.framework.startlevel, 10);
            }
        } else {
            if ((options & 1) == 0) {
                this.autostart = (short)(options == 0 ? 2 : 1);
            }
            this.updateMetadata();
        }
        if (this.startlevel <= this.framework.startlevel) {
            this.activate(options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void activate(int options) throws BundleException {
        if (this.state == 32) {
            return;
        }
        if (this.currentRevision.isFragment()) {
            return;
        }
        if (this.state == 2) {
            this.currentRevision.resolve(true);
        }
        this.context = this.framework.createBundleContext(this);
        if ((options & 2) > 0 && this.lazyActivation) {
            if (this.state != 8) {
                this.beingLazy = true;
                this.state = 8;
                this.framework.notifyBundleListeners(512, this);
            }
            BundleImpl bundleImpl = this;
            synchronized (bundleImpl) {
                this.notify();
            }
            return;
        }
        this.beingLazy = false;
        this.activate0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activate0() throws BundleException {
        assert (this.state != 2 && this.state != 1);
        this.state = 8;
        this.framework.notifyBundleListeners(128, this);
        try {
            this.context.isValid = true;
            String activatorClassName = this.currentRevision.activatorClassName;
            if (activatorClassName != null) {
                Class<?> activatorClass = this.currentRevision.classloader.loadClass(activatorClassName);
                if (activatorClass == null) {
                    throw new ClassNotFoundException(activatorClassName);
                }
                this.currentRevision.activatorInstance = (BundleActivator)activatorClass.newInstance();
                this.currentRevision.activatorInstance.start(this.context);
                if (this.state == 1) {
                    throw new BundleException("Activator.start uninstalled the bundle!", 5);
                }
            }
            this.state = 32;
            this.framework.notifyBundleListeners(2, this);
            if (this.framework.DEBUG_BUNDLES) {
                this.framework.logger.log(3, "framework: Bundle " + this.toString() + " started.");
            }
            BundleImpl bundleImpl = this;
            synchronized (bundleImpl) {
                this.notify();
            }
        }
        catch (Throwable t) {
            this.framework.notifyBundleListeners(256, this);
            this.framework.clearBundleTrace(this);
            this.state = 4;
            this.framework.notifyBundleListeners(4, this);
            throw new BundleException("Error starting bundle " + this.toString(), 5, t);
        }
    }

    @Override
    public void stop() throws BundleException {
        this.stop(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(int options) throws BundleException {
        if (this.framework.SECURITY_ENABLED) {
            // empty if block
        }
        if (this.state == 1) {
            throw new IllegalStateException("Cannot stop uninstalled bundle " + this.toString());
        }
        if (this.currentRevision.isFragment()) {
            throw new BundleException("The fragment bundle " + this.toString() + " cannot be stopped", 2);
        }
        if (this.state == 8 || this.state == 16) {
            try {
                BundleImpl bundleImpl = this;
                synchronized (bundleImpl) {
                    this.wait(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.state == 1) {
                throw new IllegalStateException("Cannot stop uninstalled bundle " + this.toString());
            }
            if (this.state == 8 || this.state == 16) {
                throw new BundleException("Timeout occurred. Bundle was unable to stop!", 7);
            }
        }
        if (options != 1) {
            this.autostart = 0;
            this.updateMetadata();
        }
        if (this.state != 32 && this.state != 8) {
            return;
        }
        this.stopBundle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void stopBundle() throws BundleException {
        BundleImpl bundleImpl;
        if (this.state == 2) {
            return;
        }
        int oldState = this.state;
        this.state = 16;
        this.framework.notifyBundleListeners(256, this);
        try {
            try {
                if (oldState == 32) {
                    if (this.currentRevision.activatorInstance != null) {
                        this.currentRevision.activatorInstance.stop(this.context);
                    }
                    if (this.state == 1) {
                        throw new BundleException("Activator.stop() uninstalled this bundle!", 5);
                    }
                }
                Object var4_2 = null;
                if (this.currentRevision != null && this.currentRevision.activatorInstance != null) {
                    this.currentRevision.activatorInstance = null;
                }
                this.framework.clearBundleTrace(this);
                this.state = 4;
                this.framework.notifyBundleListeners(4, this);
                if (this.framework.DEBUG_BUNDLES) {
                    this.framework.logger.log(3, "framework: Bundle " + this.toString() + " stopped.");
                }
                if (this.context != null) {
                    this.context.isValid = false;
                }
                this.context = null;
                bundleImpl = this;
            }
            catch (Throwable t) {
                throw new BundleException("Error stopping bundle " + this.toString(), 7, t);
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (this.currentRevision != null && this.currentRevision.activatorInstance != null) {
                this.currentRevision.activatorInstance = null;
            }
            this.framework.clearBundleTrace(this);
            this.state = 4;
            this.framework.notifyBundleListeners(4, this);
            if (this.framework.DEBUG_BUNDLES) {
                this.framework.logger.log(3, "framework: Bundle " + this.toString() + " stopped.");
            }
            if (this.context != null) {
                this.context.isValid = false;
            }
            this.context = null;
            BundleImpl bundleImpl2 = this;
            synchronized (bundleImpl2) {
                this.notify();
                throw throwable;
            }
        }
        synchronized (bundleImpl) {
            this.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void uninstall() throws BundleException {
        if (this.framework.SECURITY_ENABLED) {
            // empty if block
        }
        if (this.state == 1) {
            throw new IllegalStateException("Bundle " + this.toString() + " is already uninstalled.");
        }
        if (this.state == 32) {
            try {
                this.stopBundle();
            }
            catch (Throwable t) {
                this.framework.notifyFrameworkListeners(2, this, t);
            }
        }
        if (this.currentRevision.isFragment()) {
            this.framework.removeFragment(this.currentRevision);
        }
        this.lastDefaultLocale = Locale.getDefault();
        this.headers.headerCache = null;
        this.framework.notifyBundleListeners(64, this);
        this.state = 1;
        Concierge concierge = this.framework;
        synchronized (concierge) {
            this.updateLastModified();
            new File(this.storageLocation, "meta").delete();
            this.framework.symbolicName_bundles.remove(this.currentRevision.getSymbolicName(), this);
            this.currentRevision.cleanup(true);
            this.currentRevision = null;
            this.framework.location_bundles.remove(this.location);
        }
        this.framework.notifyBundleListeners(16, this);
        if (this.context != null) {
            this.context.isValid = false;
            this.context = null;
        }
    }

    @Override
    public synchronized void update() throws BundleException {
        String updateLocation = this.headers.get("Bundle-UpdateLocation");
        try {
            this.update(new URL(updateLocation == null ? this.location : updateLocation).openConnection().getInputStream());
        }
        catch (IOException ioe) {
            throw new BundleException("Could not update " + this.toString() + " from " + updateLocation, 11, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void update(InputStream stream) throws BundleException {
        this.lastModified = System.currentTimeMillis();
        try {
            if (this.framework.SECURITY_ENABLED) {
                // empty if block
            }
            if (this.state == 1) {
                throw new IllegalStateException("Cannot update uninstalled bundle " + this.toString());
            }
            boolean wasActive = false;
            if (this.state == 32) {
                wasActive = true;
                this.stop();
            }
            if (this.currentRevision.isFragment()) {
                this.state = 2;
                this.framework.removeFragment(this.currentRevision);
                this.framework.notifyBundleListeners(8, this);
            } else {
                this.updateLastModified();
                if (this.currentRevision != null) {
                    this.currentRevision.cleanup(false);
                }
            }
            Revision updatedRevision = this.readAndProcessInputStream(stream);
            this.framework.checkForCollision(2, this, updatedRevision);
            this.framework.symbolicName_bundles.remove(this.currentRevision.getSymbolicName(), this);
            this.currentRevision = updatedRevision;
            this.symbolicName = this.currentRevision.getSymbolicName();
            this.version = this.currentRevision.getVersion();
            this.revisions.add(0, updatedRevision);
            this.framework.symbolicName_bundles.insert(this.currentRevision.getSymbolicName(), this);
            if (!this.currentRevision.isFragment()) {
                this.currentRevision.resolve(false);
            }
            this.framework.notifyBundleListeners(8, this);
            if (wasActive) {
                try {
                    this.start();
                }
                catch (BundleException bundleException) {
                    // empty catch block
                }
            }
            if (this.framework.state != 8 && this.framework.state != 16) {
                this.updateMetadata();
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
    }

    void refresh() {
        for (BundleRevision brev : this.revisions) {
            Revision rev = (Revision)brev;
            if (rev.wiring == null) continue;
            rev.wiring.cleanup();
            rev.wiring = null;
        }
        this.revisions.clear();
        if (this.currentRevision != null) {
            this.revisions.add(this.currentRevision);
            this.currentRevision.refresh();
            this.framework.wirings.remove(this.currentRevision);
            this.currentRevision.dynamicImports.clear();
            for (BundleRequirement req : this.currentRevision.requirements.lookup("osgi.wiring.package")) {
                if (!"dynamic".equals(req.getDirectives().get("resolution"))) continue;
                this.currentRevision.dynamicImports.add(req);
            }
        }
    }

    boolean checkActivation(String pkgName) {
        if (this.activationExcludes != null) {
            for (int i = 0; i < this.activationExcludes.length; ++i) {
                if (RFC1960Filter.stringCompare(this.activationExcludes[i].toCharArray(), 0, pkgName.toCharArray(), 0) != 0) continue;
                return false;
            }
        }
        if (this.activationIncludes != null) {
            boolean trigger = false;
            for (int i = 0; i < this.activationIncludes.length; ++i) {
                if (RFC1960Filter.stringCompare(this.activationIncludes[i].toCharArray(), 0, pkgName.toCharArray(), 0) != 0) continue;
                trigger = true;
                break;
            }
            if (!trigger) {
                return false;
            }
        }
        return true;
    }

    void triggerActivation() {
        try {
            this.activate0();
        }
        catch (BundleException be) {
            this.state = 16;
            this.framework.notifyBundleListeners(256, this);
            this.state = 4;
            this.framework.notifyBundleListeners(4, this);
        }
    }

    @Override
    public final String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public final Version getVersion() {
        return this.version;
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        if (this.framework.SECURITY_ENABLED) {
            // empty if block
        }
        return this.headers.localize(this.lastDefaultLocale == null ? Locale.getDefault() : this.lastDefaultLocale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceReference<?>[] getServicesInUse() {
        if (this.state == 1) {
            throw new IllegalStateException("Bundle " + this.toString() + "has been unregistered.");
        }
        if (this.registeredServices == null) {
            return null;
        }
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        ServiceReference[] srefs = this.registeredServices.toArray(new ServiceReference[this.registeredServices.size()]);
        for (int i = 0; i < srefs.length; ++i) {
            Map<Bundle, Integer> map = ((ServiceReferenceImpl)srefs[i]).useCounters;
            synchronized (map) {
                if (((ServiceReferenceImpl)srefs[i]).useCounters.get(this) != null) {
                    result.add(srefs[i]);
                }
                continue;
            }
        }
        if (this.framework.SECURITY_ENABLED) {
            return BundleImpl.checkPermissions(result.toArray(new ServiceReferenceImpl[result.size()]));
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    @Override
    public URL getResource(String name) {
        block9: {
            if (this.state == 1) {
                throw new IllegalStateException("Bundle is uninstalled");
            }
            if (this.currentRevision.isFragment()) {
                return null;
            }
            if (this.state == 2) {
                try {
                    if (this.currentRevision.resolve(false)) break block9;
                    try {
                        if ("/".equals(name)) {
                            return this.currentRevision.createURL("/", null);
                        }
                        for (int i = 0; i < this.currentRevision.classpath.length; ++i) {
                            URL url = this.currentRevision.lookupFile(this.currentRevision.classpath[i], name);
                            if (url == null) continue;
                            return url;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                    return null;
                }
                catch (BundleException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return this.currentRevision.classloader.findResource(name);
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        if (locale == null || this.lastDefaultLocale != null) {
            return this.getHeaders();
        }
        if (locale.length() == 0) {
            return this.headers;
        }
        String[] vars = locale.split("_");
        Locale loc = vars.length > 2 ? new Locale(vars[0], vars[1], vars[2]) : (vars.length > 1 ? new Locale(vars[0], vars[1]) : new Locale(vars[0]));
        return this.headers.localize(loc);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.state == 1) {
            throw new IllegalStateException("Bundle is uninstalled");
        }
        if (this.currentRevision.isFragment()) {
            throw new ClassNotFoundException("This bundle is a fragment and cannot load any classes.");
        }
        if (this.state == 2) {
            try {
                this.currentRevision.resolve(true);
            }
            catch (BundleException be) {
                this.framework.notifyFrameworkListeners(2, this, be);
                throw new ClassNotFoundException(name, be);
            }
        }
        return this.currentRevision.classloader.findClass(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.state == 1) {
            throw new IllegalStateException("Bundle is uninstalled");
        }
        if (this.currentRevision.isFragment()) {
            return null;
        }
        if (this.state == 2) {
            try {
                if (!this.currentRevision.resolve(false)) {
                    Vector<URL> result = new Vector<URL>();
                    for (int i = 0; i < this.currentRevision.classpath.length; ++i) {
                        URL url = this.currentRevision.lookupFile(this.currentRevision.classpath[i], name);
                        if (url == null) continue;
                        result.add(url);
                    }
                    return result.isEmpty() ? null : result.elements();
                }
            }
            catch (BundleException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.currentRevision.classloader.findResources0(name);
    }

    @Override
    public Enumeration<String> getEntryPaths(String path) throws IllegalStateException {
        Vector<URL> urls;
        if (this.state == 1) {
            throw new IllegalStateException("Bundle has been uninstalled. Cannot retrieve entry.");
        }
        if (this.framework.SECURITY_ENABLED) {
            // empty if block
        }
        return (urls = this.currentRevision.searchFiles(null, path, "*", false)).isEmpty() ? null : new Enumeration<String>(){
            final Enumeration<URL> urlEnumeration;
            {
                this.urlEnumeration = urls.elements();
            }

            @Override
            public boolean hasMoreElements() {
                return this.urlEnumeration.hasMoreElements();
            }

            @Override
            public String nextElement() {
                return this.urlEnumeration.nextElement().getFile().substring(1);
            }
        };
    }

    @Override
    public URL getEntry(String path) throws IllegalStateException {
        if (this.state == 1) {
            throw new IllegalStateException("Bundle has been uninstalled. Cannot retrieve entry.");
        }
        if (this.framework.SECURITY_ENABLED) {
            // empty if block
        }
        try {
            if ("/".equals(path)) {
                return this.currentRevision.createURL("/", null);
            }
            return this.currentRevision.lookupFile(null, path);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        if (this.state == 2) {
            try {
                this.currentRevision.resolve(false);
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
        }
        Revision revision = this.currentRevision == null ? (Revision)this.revisions.get(0) : this.currentRevision;
        return revision.findEntries(path, filePattern, recurse);
    }

    @Override
    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    protected boolean isSecurityEnabled() {
        return this.framework.isSecurityEnabled();
    }

    final InputStream getURLResource(URL url, int rev) throws IOException {
        String frag;
        try {
            frag = url.toURI().getFragment();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            frag = null;
        }
        for (BundleRevision brevision : this.revisions) {
            Revision revision = (Revision)brevision;
            if (revision.revId != rev) continue;
            if (frag == null) {
                return revision.retrieveFile(null, url.getPath());
            }
            return revision.retrieveFile(url.getPath(), frag);
        }
        return null;
    }

    final long getResourceLength(URL url, int rev) {
        String frag;
        try {
            frag = url.toURI().getFragment();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            frag = null;
        }
        try {
            for (BundleRevision brevision : this.revisions) {
                Revision revision = (Revision)brevision;
                if (revision.revId != rev) continue;
                if (frag == null) {
                    return revision.retrieveFileLength(null, url.getPath());
                }
                return revision.retrieveFileLength(url.getPath(), frag);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    @Override
    public int getStartLevel() {
        return this.startlevel;
    }

    @Override
    public boolean isPersistentlyStarted() {
        this.checkBundleNotUninstalled();
        return this.autostart != 0;
    }

    @Override
    public boolean isActivationPolicyUsed() {
        this.checkBundleNotUninstalled();
        return this.autostart == 1;
    }

    @Override
    public void setStartLevel(int targetStartLevel) {
        this.checkBundleNotUninstalled();
        if (targetStartLevel <= 0) {
            throw new IllegalArgumentException("Start level " + targetStartLevel + " is not a valid level");
        }
        int oldStartlevel = this.startlevel;
        this.startlevel = targetStartLevel;
        this.updateMetadata();
        if (targetStartLevel <= oldStartlevel && this.state != 32 && this.autostart != 0) {
            final int options = this.isActivationPolicyUsed() ? 0 : 1;
            new Thread(){

                public void run() {
                    try {
                        BundleImpl.this.activate(options);
                    }
                    catch (BundleException be) {
                        be.printStackTrace();
                        BundleImpl.this.framework.notifyFrameworkListeners(2, BundleImpl.this, be);
                    }
                }
            }.start();
        } else if (targetStartLevel > oldStartlevel && this.state != 4 && this.state != 2) {
            new Thread(){

                public void run() {
                    try {
                        BundleImpl.this.stopBundle();
                    }
                    catch (BundleException be) {
                        BundleImpl.this.framework.notifyFrameworkListeners(2, BundleImpl.this, be);
                    }
                }
            }.start();
        }
    }

    protected static String[] readProperties(Attributes attrs, String property, String[] defaultValue) throws BundleException {
        String propString = BundleImpl.readProperty(attrs, property);
        return propString == null ? defaultValue : Utils.splitString(propString, ',');
    }

    protected static String readProperty(Attributes attrs, String property) throws BundleException {
        String value = attrs.getValue(property);
        if (value != null && value.equals("")) {
            throw new BundleException("Broken manifest, " + property + " is empty.", 3);
        }
        return value;
    }

    protected Properties getLocalizationFile(Locale locale, String baseDir, String baseFile) {
        int i;
        if (this.hostBundles != null) {
            return this.hostBundles.get(0).getLocalizationFile(locale, baseDir, baseFile);
        }
        Locale[] locales = new Locale[]{this.lastDefaultLocale == null ? Locale.getDefault() : this.lastDefaultLocale, locale};
        Properties props = new Properties();
        String[] choices = new String[7];
        int counter = 0;
        choices[0] = "";
        for (i = 0; i < 2; ++i) {
            choices[++counter] = "_" + locales[i].getLanguage();
            if (locales[i].getCountry().length() <= 0) continue;
            choices[++counter] = choices[counter - 1] + "_" + locales[i].getCountry();
            if (locales[i].getVariant().length() <= 0) continue;
            choices[++counter] = choices[counter - 1] + "_" + locales[i].getVariant();
        }
        for (i = counter; i >= 0; --i) {
            Enumeration<URL> urls = this.findEntries(baseDir, baseFile + choices[i] + ".properties", false);
            if (urls == null) continue;
            while (urls.hasMoreElements()) {
                try {
                    URL url = urls.nextElement();
                    InputStream stream = url.openStream();
                    props.load(stream);
                    return props;
                }
                catch (IOException iOException) {
                }
            }
        }
        return null;
    }

    public String toString() {
        return "[" + this.getSymbolicName() + "-" + this.getVersion() + "]";
    }

    static String packageOf(String classname) {
        int pos = classname.lastIndexOf(46);
        return pos > -1 ? classname.substring(0, pos) : "";
    }

    protected static String classOf(String classname) {
        int pos = classname.lastIndexOf(46);
        return pos > -1 ? classname.substring(pos + 1, classname.length()) : classname;
    }

    protected static String pseudoClassname(String filename) {
        return filename.replace('.', '-').replace('/', '.').replace('\\', '.');
    }

    protected static String stripTrailing(String filename) {
        return filename.startsWith("/") || filename.startsWith("\\") ? filename.substring(1) : filename;
    }

    protected static String classToFile(String fqc) {
        return fqc.replace('.', '/') + ".class";
    }

    static void storeFile(File file, InputStream input) {
        try {
            int read;
            file.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(file);
            byte[] buffer = new byte[Concierge.CLASSLOADER_BUFFER_SIZE];
            while ((read = input.read(buffer, 0, Concierge.CLASSLOADER_BUFFER_SIZE)) > -1) {
                fos.write(buffer, 0, read);
            }
            input.close();
            fos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    static {
        Method fileloader;
        Method classloader;
        try {
            Class<?> dexFileClass = Class.forName("dalvik.system.DexFile");
            classloader = dexFileClass.getMethod("loadClass", String.class, ClassLoader.class);
            fileloader = dexFileClass.getMethod("loadDex", String.class, String.class, Integer.TYPE);
        }
        catch (Throwable ignore) {
            classloader = null;
            fileloader = null;
        }
        dexClassLoader = classloader;
        dexFileLoader = fileloader;
        DIRECTIVE_LIST = Pattern.compile("\\s*([^:]*)\\s*:=\\s*\"\\s*(.+)*?\\s*\"\\s*");
        activationChain = new ThreadLocal();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExplodedJarBundleRevision
    extends Revision {
        private final String storageLocation;

        ExplodedJarBundleRevision(int revId, String location, Manifest manifest, String[] classpathStrings) throws BundleException {
            super(revId, manifest, classpathStrings);
            this.storageLocation = location;
        }

        @Override
        protected URL lookupFile(String classpath, String filename, HashSet<String> visited) throws IOException {
            return (URL)this.findFile(classpath, filename, 0);
        }

        @Override
        protected InputStream retrieveFile(String classpath, String filename) throws IOException {
            return (InputStream)this.findFile(classpath, filename, 1);
        }

        @Override
        protected long retrieveFileLength(String classpath, String filename) throws IOException {
            return (Long)this.findFile(classpath, filename, 2);
        }

        @Override
        protected URL lookupFile(String classpath, String filename) throws IOException {
            return (URL)this.findFile(classpath, filename, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Object findFile(String classpath, String filename, int mode) throws IOException {
            if (filename.charAt(0) == '/') {
                filename = filename.substring(1);
            }
            if (classpath == null || classpath.equals(".")) {
                File file = new File(this.storageLocation, filename);
                try {
                    if (!file.exists()) return null;
                    switch (mode) {
                        case 0: {
                            return this.createURL(filename, null);
                        }
                        case 1: {
                            return new FileInputStream(file);
                        }
                        case 2: {
                            return file.length();
                        }
                    }
                    return null;
                }
                catch (FileNotFoundException ex) {
                    return null;
                }
            }
            File file = new File(this.storageLocation, classpath);
            if (!file.exists()) return null;
            if (!file.isDirectory()) {
                ZipFile jar = new ZipFile(file);
                try {
                    ZipEntry entry = jar.getEntry(filename);
                    if (entry == null) {
                        Object var7_11 = null;
                        return var7_11;
                    }
                    switch (mode) {
                        case 0: {
                            URL uRL = this.createURL(classpath, filename);
                            return uRL;
                        }
                        case 1: {
                            InputStream inputStream = jar.getInputStream(entry);
                            return inputStream;
                        }
                        case 2: {
                            Long l = entry.getSize();
                            return l;
                        }
                    }
                    return null;
                }
                finally {
                    if (mode != 1) {
                        jar.close();
                    }
                }
            }
            try {
                File source = new File(file, filename);
                if (!file.exists()) return null;
                switch (mode) {
                    case 0: {
                        return this.createURL(filename, null);
                    }
                    case 1: {
                        return new FileInputStream(source);
                    }
                    case 2: {
                        return source.length();
                    }
                }
                return null;
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        @Override
        public Vector<URL> searchFiles(String classpath, String path, String filePattern, boolean recurse) {
            Vector<URL> result = new Vector<URL>();
            String pathString = path;
            if (pathString.length() > 0) {
                if (pathString.charAt(0) == '/') {
                    pathString = pathString.substring(0);
                }
                if (pathString.charAt(pathString.length() - 1) != '/') {
                    pathString = pathString + '/';
                }
            }
            this.testFiles(new File(this.storageLocation, pathString), result, recurse, filePattern);
            return result;
        }

        private void testFiles(File directory, Vector<URL> results, boolean recurse, String filePattern) {
            if (directory.isDirectory()) {
                File[] files = directory.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    File toTest = files[i];
                    if (BundleImpl.this.framework.DEBUG_CLASSLOADING) {
                        BundleImpl.this.framework.logger.log(4, "testing " + toTest.getAbsolutePath() + (toTest.isDirectory() ? "/" : ""));
                    }
                    String basename = toTest.getName();
                    if (filePattern == null || RFC1960Filter.stringCompare(filePattern.toCharArray(), 0, basename.toCharArray(), 0) == 0) {
                        try {
                            String absPath = toTest.getAbsolutePath();
                            results.add(this.createURL(absPath.substring(absPath.indexOf(this.storageLocation) + this.storageLocation.length() + 1) + (toTest.isDirectory() ? "/" : ""), null));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!recurse || !toTest.isDirectory()) continue;
                    this.testFiles(toTest, results, recurse, filePattern);
                }
            }
        }

        @Override
        protected void close() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JarBundleRevision
    extends Revision {
        private final JarFile jarFile;

        protected JarBundleRevision(int revId, JarFile jar, Manifest manifest, String[] classpathStrings) throws BundleException {
            super(revId, manifest, classpathStrings);
            this.jarFile = jar;
        }

        @Override
        protected URL lookupFile(String classpath, String filename) throws IOException {
            return (URL)this.findFile(classpath, filename, 0);
        }

        @Override
        protected URL lookupFile(String classpath, String filename, HashSet<String> visited) throws IOException {
            return (URL)this.findFile(classpath, filename, 0);
        }

        @Override
        public InputStream retrieveFile(String classpath, String filename) throws IOException {
            return (InputStream)this.findFile(classpath, filename, 1);
        }

        @Override
        public long retrieveFileLength(String classpath, String filename) throws IOException {
            Object res = this.findFile(classpath, filename, 2);
            if (res == null) {
                if (BundleImpl.this.framework.DEBUG_CLASSLOADING) {
                    BundleImpl.this.framework.logger.log(4, "Could not retrieveFileLength for filename=" + filename + " from bundle=" + this.toString());
                }
                return -1L;
            }
            return (Long)res;
        }

        private Object findFile(String classpath, String filename, int mode) throws IOException {
            if (filename.charAt(0) == '/') {
                filename = filename.substring(1);
            }
            if (classpath == null || classpath.equals(".")) {
                ZipEntry entry = this.jarFile.getEntry(filename);
                if (entry == null) {
                    return null;
                }
                switch (mode) {
                    case 0: {
                        return this.createURL(entry.getName(), null);
                    }
                    case 1: {
                        return this.jarFile.getInputStream(entry);
                    }
                    case 2: {
                        return entry.getSize();
                    }
                }
            } else {
                JarEntry embeddedEntry;
                ZipEntry entry = this.jarFile.getEntry(classpath);
                if (entry == null) {
                    return null;
                }
                InputStream in = this.jarFile.getInputStream(entry);
                if (in == null) {
                    ZipEntry entry2 = this.jarFile.getEntry(classpath + "/" + filename);
                    if (entry2 == null) {
                        return null;
                    }
                    switch (mode) {
                        case 0: {
                            return this.createURL(entry2.getName(), null);
                        }
                        case 1: {
                            return this.jarFile.getInputStream(entry2);
                        }
                        case 2: {
                            return entry2.getSize();
                        }
                    }
                }
                JarInputStream embeddedJar = new JarInputStream(this.jarFile.getInputStream(entry));
                while ((embeddedEntry = embeddedJar.getNextJarEntry()) != null) {
                    if (!embeddedEntry.getName().equals(filename)) continue;
                    switch (mode) {
                        case 0: {
                            return this.createURL(entry.getName(), embeddedEntry.getName());
                        }
                        case 1: {
                            return embeddedJar;
                        }
                        case 2: {
                            return embeddedEntry.getSize();
                        }
                    }
                }
            }
            return null;
        }

        @Override
        protected Vector<URL> searchFiles(String classpath, String path, String filePattern, boolean recurse) {
            int cpOffset;
            Vector<URL> results = new Vector<URL>();
            String pathString = path.length() > 0 && path.charAt(0) == '/' ? path.substring(1) : path;
            String comp = pathString = path.length() == 0 || path.charAt(path.length() - 1) == '/' ? pathString : pathString + "/";
            if (classpath != null && !".".equals(classpath)) {
                pathString = classpath + "/" + pathString;
                cpOffset = classpath.length() + 1;
            } else {
                cpOffset = 0;
            }
            Enumeration<JarEntry> enums = this.jarFile.entries();
            while (enums.hasMoreElements()) {
                File file;
                String rest;
                String name;
                JarEntry ze = enums.nextElement();
                if (cpOffset == 0 || cpOffset >= ze.getName().length()) {
                    name = ze.getName().replace('\\', '/');
                } else {
                    if (ze.getName().length() < cpOffset) continue;
                    name = ze.getName().substring(cpOffset).replace('\\', '/');
                }
                if (!name.startsWith(comp) || (rest = name.substring(comp.length(), name.length())).length() <= 0 || (file = new File(rest)).getParent() != null & !recurse || filePattern != null && RFC1960Filter.stringCompare(filePattern.toCharArray(), 0, file.getName().toCharArray(), 0) != 0) continue;
                try {
                    results.add(this.createURL(name.charAt(0) == '/' ? name.substring(1) : name, null));
                }
                catch (IOException iOException) {}
            }
            return results;
        }

        @Override
        protected void close() throws IOException {
            this.jarFile.close();
        }

        @Override
        public String toString() {
            return "JarBundleResource {" + this.jarFile.getName() + " of bundle " + BundleImpl.this.toString() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HeaderDictionary
    extends Hashtable<String, String> {
        private static final long serialVersionUID = 6688251578575649710L;
        protected WeakHashMap<Locale, HeaderDictionary> headerCache;
        private final HashMap<String, String> index;
        private boolean hasLocalizedValues;

        public HeaderDictionary(int size) {
            super(size);
            this.index = new HashMap();
        }

        HeaderDictionary localize(Locale locale) {
            HeaderDictionary cached;
            if (!this.hasLocalizedValues) {
                return this;
            }
            if (this.headerCache != null && (cached = this.headerCache.get(locale)) != null) {
                return cached;
            }
            Properties props = BundleImpl.this.getLocalizationFile(locale, BundleImpl.this.bundleLocalizationBaseDir, BundleImpl.this.bundleLocalizationBaseFilename);
            HeaderDictionary localized = (HeaderDictionary)this.clone();
            Enumeration keys = localized.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = localized.get(key);
                if (value == null || value.charAt(0) != '%') continue;
                String rawValue = value.substring(1).trim();
                String localizedValue = props == null ? null : (String)props.get(rawValue);
                localized.put(key, localizedValue == null ? rawValue : localizedValue);
            }
            if (this.headerCache == null) {
                this.headerCache = new WeakHashMap();
                this.headerCache.put(locale, localized);
            }
            return localized;
        }

        @Override
        public String put(String key, String value) {
            if (value.length() > 0 && value.charAt(0) == '%') {
                this.hasLocalizedValues = true;
            }
            this.index.put(key.toLowerCase(), key);
            return super.put(key, value);
        }

        @Override
        public String get(Object key) {
            String result = (String)super.get(key);
            if (result != null) {
                return result;
            }
            String indexedKey = this.index.get(((String)key).toLowerCase());
            return indexedKey == null ? null : (String)super.get(indexedKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Revision
    implements BundleRevision,
    Comparable<Revision> {
        protected static final int GET_URL = 0;
        protected static final int RETRIEVE_INPUT_STREAM = 1;
        protected static final int GET_CONTENT_LENGTH = 2;
        protected final int revId;
        protected final ConciergeCollections.MultiMap<String, BundleCapability> capabilities;
        protected final ConciergeCollections.MultiMap<String, BundleRequirement> requirements;
        private final List<HostedCapability> hostedCapabilities = new ArrayList<HostedCapability>();
        protected final List<BundleRequirement> dynamicImports;
        private BundleCapability identity;
        BundleClassLoader classloader;
        protected final String activatorClassName;
        private String[] nativeCodeStrings;
        protected BundleActivator activatorInstance;
        protected String[] classpath;
        protected Map<String, String> nativeLibraries;
        protected List<Revision> fragments;
        private final String[] classpathStrings;
        private final short fragmentAttachmentPolicy;
        protected Resources.ConciergeBundleWiring wiring;
        protected HashMap<String, BundleWire> packageImportWires;
        protected List<BundleWire> requireBundleWires;
        protected final HashSet<String> exportIndex;

        protected Revision(int revId, Manifest manifest, String[] classpathStrings) throws BundleException {
            Object hosts;
            int pos;
            String bundleLocalizationBaseName;
            int mfVer;
            this.revId = revId;
            this.classpathStrings = classpathStrings;
            this.classloader = new BundleClassLoader();
            Attributes attrs = manifest.getMainAttributes();
            String mfVerStr = attrs.getValue("Bundle-ManifestVersion");
            try {
                mfVer = mfVerStr == null ? 1 : Integer.parseInt(mfVerStr.trim());
            }
            catch (NumberFormatException nfe) {
                throw new BundleException("Illegal value for Bundle-ManifestVersion: `" + mfVerStr + "`", 3);
            }
            String reqStr = attrs.getValue("Require-Capability");
            this.requirements = this.parseRequirements(reqStr);
            String capStr = attrs.getValue("Provide-Capability");
            this.capabilities = this.parseCapabilities(capStr);
            this.dynamicImports = new ArrayList<BundleRequirement>();
            switch (mfVer) {
                default: {
                    LegacyBundleProcessing proc = BundleImpl.this.framework.getService(LegacyBundleProcessing.class, LegacyBundleProcessing.VERSION_ONE);
                    if (proc == null) {
                        throw new BundleException("Bundle manifest version 1 is not supported by this deployment", 1);
                    }
                    ConciergeCollections.Tuple<List<BundleCapability>, List<BundleRequirement>> tuple = proc.processManifest(this, manifest);
                    for (BundleCapability cap : tuple.getFormer()) {
                        this.capabilities.insert(cap.getNamespace(), cap);
                    }
                    for (BundleRequirement req : tuple.getLatter()) {
                        String namespace = req.getNamespace();
                        this.requirements.insert(namespace, req);
                        if (!"osgi.wiring.package".equals(namespace) || !"dynamic".equals(req.getDirectives().get("resolution"))) continue;
                        this.dynamicImports.add(req);
                    }
                    break;
                }
                case 2: {
                    LegacyBundleProcessing proc = BundleImpl.this.framework.getService(LegacyBundleProcessing.class, LegacyBundleProcessing.VERSION_TWO);
                    if (proc == null) {
                        throw new BundleException("Bundle manifest version 2 is not supported by this deployment", 1);
                    }
                    ConciergeCollections.Tuple<List<BundleCapability>, List<BundleRequirement>> tuple2 = proc.processManifest(this, manifest);
                    for (BundleCapability cap : tuple2.getFormer()) {
                        this.capabilities.insert(cap.getNamespace(), cap);
                    }
                    for (BundleRequirement req : tuple2.getLatter()) {
                        String namespace = req.getNamespace();
                        this.requirements.insert(namespace, req);
                        if (!"osgi.wiring.package".equals(namespace) || !"dynamic".equals(req.getDirectives().get("resolution"))) continue;
                        this.dynamicImports.add(req);
                    }
                }
            }
            this.exportIndex = this.createExportIndex();
            if (!this.dynamicImports.isEmpty()) {
                Iterator<BundleRequirement> iter = this.dynamicImports.iterator();
                while (iter.hasNext()) {
                    BundleRequirement req = iter.next();
                    if (!this.exportIndex.contains(req.getDirectives().get("x-int"))) continue;
                    iter.remove();
                }
            }
            this.nativeCodeStrings = BundleImpl.readProperties(attrs, "Bundle-NativeCode", null);
            this.activatorClassName = attrs.getValue("Bundle-Activator");
            String activationPolicy = BundleImpl.readProperty(attrs, "Bundle-ActivationPolicy");
            if (activationPolicy != null) {
                String[] literals = Utils.splitString(activationPolicy, ';');
                if ("lazy".equals(literals[0])) {
                    BundleImpl.this.lazyActivation = true;
                }
                for (int i = 1; i < literals.length; ++i) {
                    Matcher matcher = DIRECTIVE_LIST.matcher(literals[i]);
                    if (!matcher.matches()) continue;
                    String directive = matcher.group(1);
                    String list = matcher.group(2);
                    String[] elems = Utils.splitString(list, ',');
                    if ("include".equals(directive)) {
                        BundleImpl.this.activationIncludes = elems;
                        continue;
                    }
                    if (!"exclude".equals(directive)) continue;
                    BundleImpl.this.activationExcludes = elems;
                }
            }
            if ((bundleLocalizationBaseName = attrs.getValue("Bundle-Localization")) == null) {
                bundleLocalizationBaseName = "OSGI-INF/l10n/bundle";
            }
            if ((pos = bundleLocalizationBaseName.lastIndexOf("/")) > -1) {
                BundleImpl.this.bundleLocalizationBaseDir = bundleLocalizationBaseName.substring(0, pos);
                BundleImpl.this.bundleLocalizationBaseFilename = bundleLocalizationBaseName.substring(pos + 1);
            } else {
                BundleImpl.this.bundleLocalizationBaseDir = "/";
                BundleImpl.this.bundleLocalizationBaseFilename = bundleLocalizationBaseName;
            }
            HeaderDictionary headers = new HeaderDictionary(attrs.size());
            Object[] entries = attrs.keySet().toArray(new Object[attrs.keySet().size()]);
            for (int i = 0; i < entries.length; ++i) {
                headers.put(entries[i].toString(), attrs.get(entries[i]).toString());
            }
            BundleImpl.this.headers = headers;
            Object identities = this.capabilities.get("osgi.identity");
            if (identities != null) {
                this.identity = (BundleCapability)this.capabilities.get("osgi.identity").get(0);
            }
            if ((hosts = this.capabilities.get("osgi.wiring.host")) == null) {
                this.fragmentAttachmentPolicy = (short)-1;
            } else {
                String policy = ((BundleCapability)hosts.get(0)).getDirectives().get("fragment-attachment");
                this.fragmentAttachmentPolicy = this.identity == null || policy == null || "always".equals(policy) ? (short)2 : ("resolve-time".equals(policy) ? (short)1 : ("never".equals(policy) ? (short)-1 : (short)2));
            }
            if (this.isFragment()) {
                BundleImpl.this.framework.addFragment(this);
            } else {
                BundleImpl.this.framework.publishCapabilities(this.capabilities.getAllValues());
            }
        }

        protected void refresh() {
            if (this.fragments != null) {
                this.fragments = null;
            }
            this.classloader = new BundleClassLoader();
        }

        private ConciergeCollections.MultiMap<String, BundleRequirement> parseRequirements(String str) throws BundleException {
            ConciergeCollections.MultiMap<String, BundleRequirement> result = new ConciergeCollections.MultiMap<String, BundleRequirement>();
            if (str == null) {
                return result;
            }
            String[] reqStrs = Utils.splitString(str, ',');
            for (int i = 0; i < reqStrs.length; ++i) {
                Resources.BundleRequirementImpl req = new Resources.BundleRequirementImpl(this, reqStrs[i]);
                String namespace = req.getNamespace();
                result.insert(namespace, req);
            }
            return result;
        }

        private ConciergeCollections.MultiMap<String, BundleCapability> parseCapabilities(String str) throws BundleException {
            ConciergeCollections.MultiMap<String, BundleCapability> result = new ConciergeCollections.MultiMap<String, BundleCapability>();
            if (str == null) {
                return result;
            }
            String[] reqStrs = Utils.splitString(str, ',');
            for (int i = 0; i < reqStrs.length; ++i) {
                Resources.BundleCapabilityImpl cap = new Resources.BundleCapabilityImpl(this, reqStrs[i]);
                String namespace = cap.getNamespace();
                result.insert(namespace, cap);
            }
            return result;
        }

        private HashSet<String> createExportIndex() {
            Object packageReqs = this.capabilities.get("osgi.wiring.package");
            HashSet<String> index = new HashSet<String>();
            if (packageReqs != null) {
                Iterator i$ = packageReqs.iterator();
                while (i$.hasNext()) {
                    BundleCapability req = (BundleCapability)i$.next();
                    index.add((String)req.getAttributes().get("osgi.wiring.package"));
                }
            }
            return index;
        }

        public boolean isFragment() {
            return this.requirements.get("osgi.wiring.host") != null;
        }

        boolean isExtensionBundle() {
            String fragmentHostName = this.getFragmentHost();
            return fragmentHostName.equals("system.bundle") || fragmentHostName.equals("org.eclipse.concierge");
        }

        protected boolean isCurrent() {
            return BundleImpl.this.currentRevision == this;
        }

        @Override
        public Bundle getBundle() {
            return BundleImpl.this;
        }

        @Override
        public String getSymbolicName() {
            return this.identity == null ? null : (String)this.identity.getAttributes().get("osgi.identity");
        }

        @Override
        public Version getVersion() {
            return this.identity == null ? Version.emptyVersion : (Version)this.identity.getAttributes().get("version");
        }

        @Override
        public List<BundleCapability> getDeclaredCapabilities(String namespace) {
            return namespace == null ? this.capabilities.getAllValues() : this.capabilities.lookup(namespace);
        }

        @Override
        public List<BundleRequirement> getDeclaredRequirements(String namespace) {
            return namespace == null ? this.requirements.getAllValues() : this.requirements.lookup(namespace);
        }

        @Override
        public int getTypes() {
            return this.identity == null ? 0 : ("osgi.fragment".equals(this.identity.getAttributes().get("type")) ? 1 : 0);
        }

        @Override
        public BundleWiring getWiring() {
            return this.wiring;
        }

        @Override
        public List<Capability> getCapabilities(String namespace) {
            return Collections.unmodifiableList(new ArrayList<BundleCapability>(this.getDeclaredCapabilities(namespace)));
        }

        @Override
        public List<Requirement> getRequirements(String namespace) {
            return Collections.unmodifiableList(new ArrayList<BundleRequirement>(this.getDeclaredRequirements(namespace)));
        }

        protected boolean resolve(boolean critical) throws BundleException {
            if (!this.resolveMetadata(critical)) {
                return false;
            }
            if (!BundleImpl.this.framework.resolve(Collections.singletonList(this), critical)) {
                return false;
            }
            if (BundleImpl.this.state == 2) {
                BundleImpl.this.state = 4;
                BundleImpl.this.framework.notifyBundleListeners(32, BundleImpl.this);
            }
            return true;
        }

        protected boolean resolveMetadata(boolean critical) throws BundleException {
            try {
                if (this.classpath == null) {
                    for (int i = 0; i < this.classpathStrings.length; ++i) {
                        if (this.classpathStrings[i].equals(".")) continue;
                        try {
                            if (null != this.retrieveFile(null, this.classpathStrings[i])) continue;
                            BundleImpl.this.framework.notifyFrameworkListeners(2, BundleImpl.this, new BundleException("Missing file in bundle classpath " + this.classpathStrings[i], 4));
                            continue;
                        }
                        catch (IOException ioe) {
                            BundleImpl.this.framework.notifyFrameworkListeners(2, BundleImpl.this, ioe);
                        }
                    }
                    this.classpath = this.classpathStrings;
                }
                if (this.nativeCodeStrings != null) {
                    this.nativeLibraries = new HashMap<String, String>(this.nativeCodeStrings.length);
                    if (!this.processNativeLibraries(this.nativeCodeStrings)) {
                        if (critical) {
                            throw new BundleException("No matching native clause");
                        }
                        return false;
                    }
                }
                return true;
            }
            catch (IllegalArgumentException iae) {
                throw new BundleException("Error while resolving bundle " + BundleImpl.this.currentRevision.getSymbolicName(), 4, iae);
            }
        }

        protected boolean isFrameworkExtension() {
            Object hostReqs = this.requirements.get("osgi.wiring.host");
            if (hostReqs == null) {
                return false;
            }
            return "framework".equals(((BundleRequirement)hostReqs.get(0)).getDirectives().get("extension"));
        }

        private boolean processNativeLibraries(String[] nativeStrings) throws BundleException {
            int pos = -1;
            boolean n = false;
            boolean no_n = true;
            boolean l = false;
            boolean no_l = true;
            boolean v = false;
            boolean no_v = true;
            boolean p = false;
            boolean no_p = false;
            boolean s = false;
            boolean no_s = true;
            boolean hasOptional = false;
            boolean hasMatch = false;
            ArrayList<String> libs = new ArrayList<String>();
            for (int i = 0; i < nativeStrings.length; ++i) {
                if (nativeStrings[i].indexOf(";") == -1) {
                    if (nativeStrings[i].equals("*")) {
                        hasOptional = true;
                        continue;
                    }
                    pos = nativeStrings[i].lastIndexOf("/");
                    this.nativeLibraries.put(pos > -1 ? nativeStrings[i].substring(pos + 1) : nativeStrings[i], BundleImpl.stripTrailing(nativeStrings[i]));
                    continue;
                }
                StringTokenizer tokenizer = new StringTokenizer(nativeStrings[i], ";");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    int a = token.indexOf("=");
                    if (a > -1) {
                        String criterium = token.substring(0, a).trim().intern();
                        String value = token.substring(a + 1).trim();
                        if (criterium == "osname") {
                            if (BundleImpl.this.framework.osname.startsWith("Windows")) {
                                n |= value.toLowerCase().startsWith("win");
                            } else {
                                n |= value.equalsIgnoreCase(BundleImpl.this.framework.osname);
                                if (BundleImpl.this.framework.osname.equals("MacOSX")) {
                                    n |= value.equalsIgnoreCase("Mac OS X");
                                } else if (BundleImpl.this.framework.osname.equals("MacOS")) {
                                    n |= value.equalsIgnoreCase("Mac OS");
                                }
                            }
                            no_n = false;
                            continue;
                        }
                        if (criterium == "osversion") {
                            v |= new VersionRange(Utils.unQuote(value)).includes(BundleImpl.this.framework.osversion);
                            no_v = false;
                            continue;
                        }
                        if (criterium == "language") {
                            l |= new Locale(value, "").getLanguage().equals(BundleImpl.this.framework.language);
                            no_l = false;
                            continue;
                        }
                        if (criterium == "processor") {
                            p = BundleImpl.this.framework.processor.equals("x86") ? (p |= value.equals("x86") || value.equals("pentium") || value.equals("i386") || value.equals("i486") || value.equals("i586") || value.equals("i686")) : (BundleImpl.this.framework.processor.equals("x86-64") ? (p |= value.equals("amd64") || value.equals("em64t") || value.equals("x86_64") || value.equals("x86-64")) : (BundleImpl.this.framework.processor.equals("ppc") ? (p |= value.equals("ppc")) : (p |= value.equalsIgnoreCase(BundleImpl.this.framework.processor))));
                            no_p = false;
                            continue;
                        }
                        if (criterium != "selection-filter") continue;
                        try {
                            s |= RFC1960Filter.fromString(Utils.unQuote(value)).match(Concierge.props2Dict(BundleImpl.this.framework.properties));
                            no_s = false;
                        }
                        catch (InvalidSyntaxException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if ("*".equals(token.trim()) && !tokenizer.hasMoreTokens()) {
                        hasMatch = true;
                        continue;
                    }
                    libs.add(token.trim());
                }
                if (!libs.isEmpty() && (no_p || p) && (no_n || n) && (no_v || v) && (no_l || l) && (no_s || s)) {
                    String[] libraries = libs.toArray(new String[libs.size()]);
                    for (int c = 0; c < libraries.length; ++c) {
                        pos = libraries[c].lastIndexOf("/");
                        this.nativeLibraries.put(pos > -1 ? libraries[c].substring(pos + 1) : libraries[c], BundleImpl.stripTrailing(libraries[c]));
                    }
                    hasMatch = true;
                }
                s = false;
                l = false;
                v = false;
                n = false;
                p = false;
                no_s = true;
                no_l = true;
                no_v = true;
                no_n = true;
                no_p = true;
                libs.clear();
            }
            return hasMatch || hasOptional;
        }

        void cleanup(boolean uninstall) {
            BundleImpl.this.framework.removeCapabilities(this);
            if (BundleImpl.this.currentRevision == null) {
                if (this.wiring != null) {
                    this.wiring.cleanup();
                    BundleImpl.this.framework.wirings.remove(this);
                }
                this.wiring = null;
                this.packageImportWires = null;
                this.requireBundleWires = null;
                this.fragments = null;
            }
            if (!uninstall) {
                BundleImpl.this.currentRevision = (Revision)BundleImpl.this.revisions.get(0);
            }
        }

        void markResolved() {
            BundleImpl.this.state = 4;
            BundleImpl.this.framework.notifyBundleListeners(32, BundleImpl.this);
        }

        void setWiring(Resources.ConciergeBundleWiring wiring) {
            this.wiring = wiring;
            this.packageImportWires = wiring.getPackageImportWires();
            this.requireBundleWires = wiring.getRequireBundleWires();
        }

        Resources.ConciergeBundleWiring addAdditionalWires(List<Wire> wires) {
            for (Wire wire : wires) {
                this.wiring.addWire((BundleWire)wire);
            }
            this.packageImportWires = this.wiring.getPackageImportWires();
            this.requireBundleWires = this.wiring.getRequireBundleWires();
            return this.wiring;
        }

        String getFragmentHost() {
            Object hostReqs = this.requirements.get("osgi.wiring.host");
            if (hostReqs == null) {
                return null;
            }
            return ((BundleRequirement)hostReqs.get(0)).getDirectives().get("osgi.wiring.host");
        }

        final boolean allowsFragmentAttachment() {
            return this.fragmentAttachmentPolicy != -1;
        }

        List<Revision> getAttachedFragments() {
            return this.fragments;
        }

        boolean attachFragment(Revision fragment) throws BundleException {
            List<Capability> newExports;
            String[] newNativeStrings;
            Object newRequiredBundle;
            Object newImports;
            if (this.fragments != null && this.fragments.contains(fragment)) {
                return false;
            }
            if (BundleImpl.this.state == 32 || BundleImpl.this.state == 8) {
                if (this.fragmentAttachmentPolicy == 1) {
                    throw new BundleException("Host bundle does not allow to attach fragment at runtime", 4);
                }
                List<Requirement> imports = fragment.getRequirements("osgi.wiring.package");
                HashSet<String> importPkgs = new HashSet<String>();
                for (Requirement pkgImport : imports) {
                    importPkgs.add(pkgImport.getDirectives().get("x-int"));
                }
                importPkgs.remove("org.osgi.framework");
                if (!importPkgs.isEmpty()) {
                    List<BundleRequirement> wiredImports = this.wiring.getRequirements("osgi.wiring.package");
                    for (Requirement requirement : wiredImports) {
                        importPkgs.remove(requirement.getDirectives().get("x-int"));
                    }
                    if (!importPkgs.isEmpty()) {
                        throw new BundleException("Imports of this Fragment are not satisfiable without restart of the host bundle", 4);
                    }
                }
                if (!fragment.getRequirements("osgi.wiring.bundle").isEmpty()) {
                    throw new BundleException("Fragment must not add new require bundle entries", 4);
                }
            }
            ArrayList<String> newClasspaths = new ArrayList<String>(this.classpath != null ? this.classpath.length : 0);
            if (this.classpath != null) {
                for (int k = 0; k < this.classpath.length; ++k) {
                    newClasspaths.add(this.classpath[k]);
                }
            }
            if ((newImports = fragment.requirements.get("osgi.wiring.package")) != null) {
                this.checkConflicts((List)newImports, (List)this.requirements.get("osgi.wiring.package"), "osgi.wiring.package", "import");
            }
            if ((newRequiredBundle = fragment.requirements.get("osgi.wiring.bundle")) != null) {
                this.checkConflicts((List)newRequiredBundle, (List)this.requirements.get("osgi.wiring.bundle"), "osgi.wiring.bundle", "requireBundle");
            }
            if (fragment.nativeCodeStrings == null) {
                newNativeStrings = this.nativeCodeStrings;
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (this.nativeCodeStrings != null) {
                    arrayList.addAll(Arrays.asList(this.nativeCodeStrings));
                }
                arrayList.addAll(Arrays.asList(fragment.nativeCodeStrings));
                newNativeStrings = arrayList.toArray(new String[arrayList.size()]);
            }
            BundleImpl bundleImpl = (BundleImpl)fragment.getBundle();
            if (newImports != null) {
                this.requirements.insertAll("osgi.wiring.package", (Collection<BundleRequirement>)newImports);
            }
            if (newRequiredBundle != null) {
                this.requirements.insertAll("osgi.wiring.bundle", (Collection<BundleRequirement>)newRequiredBundle);
            }
            if ((newExports = fragment.getCapabilities("osgi.wiring.package")) != null) {
                for (Capability cap : newExports) {
                    this.exportIndex.add((String)cap.getAttributes().get("osgi.wiring.package"));
                }
            }
            if (this.fragments == null) {
                this.fragments = new ArrayList<Revision>();
            }
            this.fragments.add(fragment);
            Collections.sort(this.fragments);
            if (bundleImpl.hostBundles == null) {
                bundleImpl.hostBundles = new ArrayList<BundleImpl>();
            }
            bundleImpl.hostBundles.add(BundleImpl.this);
            if (bundleImpl.state != 4) {
                fragment.wiring = new Resources.ConciergeBundleWiring(fragment, null);
                bundleImpl.state = 4;
                BundleImpl.this.framework.notifyBundleListeners(32, bundleImpl);
            }
            for (int n = 0; n < fragment.classpathStrings.length; ++n) {
                if (newClasspaths.contains(fragment.classpathStrings[n])) continue;
                newClasspaths.add(fragment.classpathStrings[n]);
            }
            if (newClasspaths.size() > 0) {
                this.classpath = newClasspaths.toArray(new String[newClasspaths.size()]);
            }
            this.nativeCodeStrings = newNativeStrings;
            if (this.nativeCodeStrings != null) {
                this.nativeLibraries = new HashMap<String, String>(this.nativeCodeStrings.length);
                this.processNativeLibraries(newNativeStrings);
            }
            return true;
        }

        private <T extends Requirement> void checkConflicts(List<T> list1, List<T> list2, String namespace, String s) throws BundleException {
            String attr;
            List<T> longer;
            List<T> shorter;
            if (list1 == null) {
                throw new IllegalArgumentException("list1 == null");
            }
            if (list2 == null) {
                return;
            }
            int list1size = list1.size();
            int list2size = list2.size();
            if (list1size == 0 || list2size == 0) {
                return;
            }
            if (list1size > list2size) {
                shorter = list2;
                longer = list1;
            } else {
                shorter = list1;
                longer = list2;
            }
            HashMap<String, Requirement> index = new HashMap<String, Requirement>();
            for (Requirement element : longer) {
                attr = element.getDirectives().get("x-int");
                if (attr == null) continue;
                index.put(attr, element);
            }
            for (Requirement element : shorter) {
                attr = element.getDirectives().get("x-int");
                if (attr == null || !index.containsKey(attr)) continue;
                throw new BundleException("Conflicting " + s + " statement " + element.getAttributes().get(namespace) + " from " + element, 4);
            }
        }

        protected Object checkActivationChain(Object result) {
            ArrayList<AbstractBundle> activationList = activationChain.get();
            if (activationList != null && activationList.size() > 0 && activationList.get(0) == BundleImpl.this) {
                activationChain.set(new ArrayList());
                for (int i = activationList.size() - 1; i >= 0; --i) {
                    BundleImpl toActivate = (BundleImpl)activationList.get(i);
                    if (!toActivate.beingLazy) continue;
                    toActivate.triggerActivation();
                }
                activationChain.set(null);
            }
            return result;
        }

        public String toString() {
            return "[Revision " + this.revId + " of " + BundleImpl.this + "]";
        }

        protected Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
            Vector<URL> result = this.searchFiles(null, path, filePattern, recurse);
            if (this.fragments != null) {
                for (Revision fragment : this.fragments) {
                    Vector<URL> fragResult = fragment.searchFiles(null, path, filePattern, recurse);
                    result.addAll(fragResult);
                }
            }
            return result.isEmpty() ? null : result.elements();
        }

        protected abstract URL lookupFile(String var1, String var2) throws IOException;

        protected abstract URL lookupFile(String var1, String var2, HashSet<String> var3) throws IOException;

        protected abstract Vector<URL> searchFiles(String var1, String var2, String var3, boolean var4);

        protected abstract InputStream retrieveFile(String var1, String var2) throws IOException;

        protected abstract long retrieveFileLength(String var1, String var2) throws IOException;

        protected abstract void close() throws IOException;

        URL createURL(String name1, String fragment) throws MalformedURLException {
            String name = name1.replace('\\', '/');
            return new URL(BundleImpl.BUNDLE_FILE_NAME, BundleImpl.this.bundleId + "." + this.revId, (name.charAt(0) == '/' ? name : "/" + name) + (fragment == null ? "" : "#" + fragment));
        }

        void addHostedCapability(HostedCapability hostedCap) {
            this.hostedCapabilities.add(hostedCap);
        }

        List<HostedCapability> getHostedCapabilities() {
            return this.hostedCapabilities;
        }

        @Override
        public int compareTo(Revision other) {
            int ids = (int)(BundleImpl.this.bundleId - other.getBundle().getBundleId());
            return ids != 0 ? ids : this.revId - other.revId;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WovenClassImpl
        implements WovenClass {
            private final String clazzName;
            private byte[] bytes;
            private boolean weavingComplete;
            private Class<?> clazz;
            private List<String> dynamicImports;
            protected List<BundleRequirement> dynamicImportRequirements;
            private ProtectionDomain domain;

            WovenClassImpl(String clazzName, byte[] bytes, final Revision revision2, ProtectionDomain domain) {
                this.bytes = bytes;
                this.clazzName = clazzName;
                this.dynamicImportRequirements = new ArrayList<BundleRequirement>();
                this.dynamicImports = new ArrayList<String>(){
                    private static final long serialVersionUID = 975783807443126126L;

                    @Override
                    public boolean add(String dynImport) {
                        this.checkDynamicImport(dynImport);
                        return super.add(dynImport);
                    }

                    @Override
                    public boolean addAll(Collection<? extends String> c) {
                        for (String string : c) {
                            this.checkDynamicImport(string);
                        }
                        return super.addAll(c);
                    }

                    private void checkDynamicImport(String dynImport) throws IllegalArgumentException {
                        try {
                            String[] literals = Utils.splitString(dynImport, ';');
                            if (literals[0].contains(";")) {
                                throw new IllegalArgumentException(dynImport);
                            }
                            ConciergeCollections.ParseResult parseResult = Utils.parseLiterals(literals, 1);
                            HashMap<String, String> dirs = parseResult.getDirectives();
                            dirs.put("filter", Utils.createFilter("osgi.wiring.package", literals[0], (Map)parseResult.getLatter()));
                            dirs.put("resolution", "dynamic");
                            dirs.put("x-int", literals[0]);
                            Resources.BundleRequirementImpl req = new Resources.BundleRequirementImpl(revision2, "osgi.wiring.package", dirs, null, "DynamicImport-Package " + dynImport);
                            WovenClassImpl.this.dynamicImportRequirements.add(req);
                        }
                        catch (BundleException be) {
                            throw new IllegalArgumentException("Unvalid dynamic import " + dynImport);
                        }
                    }
                };
                this.domain = domain;
            }

            @Override
            public byte[] getBytes() {
                return this.bytes;
            }

            @Override
            public void setBytes(byte[] newBytes) {
                if (newBytes == null) {
                    throw new NullPointerException("newBytes");
                }
                if (this.weavingComplete) {
                    throw new IllegalStateException("Weaving is complete");
                }
                this.bytes = newBytes;
            }

            @Override
            public List<String> getDynamicImports() {
                return this.dynamicImports;
            }

            @Override
            public boolean isWeavingComplete() {
                return this.weavingComplete;
            }

            @Override
            public String getClassName() {
                return this.clazzName;
            }

            @Override
            public ProtectionDomain getProtectionDomain() {
                return this.domain;
            }

            @Override
            public Class<?> getDefinedClass() {
                return this.clazz;
            }

            @Override
            public BundleWiring getBundleWiring() {
                return Revision.this.getWiring();
            }

            void setDefinedClass(Class<?> clazz) {
                this.clazz = clazz;
            }

            void setProtectionDomain(ProtectionDomain protectionDomain) {
                this.domain = protectionDomain;
            }

            void setComplete() {
                this.weavingComplete = true;
                this.bytes = (byte[])this.bytes.clone();
                this.dynamicImports = Collections.unmodifiableList(this.dynamicImports);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class BundleClassLoader
        extends ClassLoader
        implements BundleReference {
            private Object dexFile;

            public BundleClassLoader() {
                super(BundleImpl.this.framework.parentClassLoader);
                this.dexFile = null;
            }

            @Override
            public final Class<?> loadClass(String name) throws ClassNotFoundException {
                return this.findClass(name);
            }

            @Override
            protected final Class<?> findClass(String name) throws ClassNotFoundException {
                Class result = (Class)this.findResource0(BundleImpl.packageOf(name), name, true, false);
                if (result == null) {
                    throw new ClassNotFoundException(name);
                }
                return result;
            }

            @Override
            public Enumeration<URL> getResources(String name) {
                return this.findResources(name);
            }

            @Override
            public URL getResource(String name) {
                return this.findResource(name);
            }

            @Override
            public Bundle getBundle() {
                return BundleImpl.this;
            }

            @Override
            protected URL findResource(String name) {
                String strippedName = BundleImpl.stripTrailing(name);
                try {
                    return (URL)this.findResource0(BundleImpl.packageOf(BundleImpl.pseudoClassname(strippedName)), strippedName, false, false);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            protected Enumeration<URL> findResources(String name) {
                Enumeration<URL> result = this.findResources0(name);
                return result == null ? Collections.enumeration(Collections.emptyList()) : result;
            }

            protected Enumeration<URL> findResources0(String name) {
                String strippedName = BundleImpl.stripTrailing(name);
                try {
                    Vector results = (Vector)this.findResource0(BundleImpl.packageOf(BundleImpl.pseudoClassname(strippedName)), strippedName, false, true);
                    return results == null || results.isEmpty() ? null : results.elements();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private synchronized Object findResource0(String pkg, String name, boolean isClass, boolean multiple) throws ClassNotFoundException {
                Resources.BundleCapabilityImpl cap;
                BundleWire delegation;
                Vector<URL> resources;
                block13: {
                    Vector<URL> vector = resources = multiple ? new Vector<URL>() : null;
                    if (BundleImpl.this.state == 1) {
                        throw new IllegalStateException("Cannot " + (isClass ? "load class" : "find resource") + ", bundle " + Revision.this.getSymbolicName() + " has been uninstalled.");
                    }
                    if (BundleImpl.this.state == 2) {
                        try {
                            Revision.this.resolve(true);
                        }
                        catch (BundleException be) {
                            if (!isClass) break block13;
                            BundleImpl.this.framework.notifyFrameworkListeners(2, BundleImpl.this, be);
                            throw new ClassNotFoundException(name, be);
                        }
                    }
                }
                if (pkg.startsWith("java.") || BundleImpl.this.framework.bootdelegation(pkg)) {
                    if (isClass) {
                        return this.getParent().loadClass(name);
                    }
                    if (!multiple) return this.getParent().getResource(name);
                    try {
                        Enumeration<URL> e = this.getParent().getResources(name);
                        while (e.hasMoreElements()) {
                            resources.add(e.nextElement());
                        }
                    }
                    catch (IOException e) {}
                }
                if (Revision.this.wiring == null || (delegation = Revision.this.packageImportWires.get(pkg)) == null || (cap = (Resources.BundleCapabilityImpl)delegation.getCapability()).hasExcludes() && !cap.filter(BundleImpl.classOf(name))) return this.findResource1(pkg, name, isClass, multiple, resources);
                if (delegation.getProvider().getBundle().getBundleId() != 0L) return ((Revision)delegation.getProvider()).classloader.findResource1(pkg, name, isClass, multiple, resources);
                if (isClass) {
                    return BundleImpl.this.framework.systemBundleClassLoader.loadClass(name);
                }
                if (!multiple) return BundleImpl.this.framework.systemBundleClassLoader.getResource(name);
                try {
                    Enumeration<URL> e = BundleImpl.this.framework.systemBundleClassLoader.getResources(name);
                    while (e.hasMoreElements()) {
                        resources.add(e.nextElement());
                    }
                    return this.findResource1(pkg, name, isClass, multiple, resources);
                }
                catch (IOException iOException) {
                    return this.findResource1(pkg, name, isClass, multiple, resources);
                }
            }

            private synchronized Object findResource1(String pkg, String name, boolean isClass, boolean multiple, Vector<URL> resources) throws ClassNotFoundException {
                if (isClass && BundleImpl.this.lazyActivation && BundleImpl.this.getState() == 8 && BundleImpl.this.checkActivation(pkg)) {
                    ArrayList<AbstractBundle> activationList = activationChain.get();
                    if (activationList == null) {
                        activationList = new ArrayList();
                        activationList.add(BundleImpl.this);
                        activationChain.set(activationList);
                    } else if (!activationList.isEmpty() && !activationList.contains(BundleImpl.this)) {
                        activationList.add(BundleImpl.this);
                    }
                }
                if (Revision.this.requireBundleWires != null) {
                    HashSet<Bundle> visited = new HashSet<Bundle>();
                    visited.add(BundleImpl.this);
                    for (BundleWire wire : Revision.this.requireBundleWires) {
                        if (wire.getProvider().getBundle().getBundleId() == 0L) continue;
                        Object result = ((Revision)wire.getProvider()).classloader.requireBundleLookup(pkg, name, isClass, multiple, resources, visited);
                        if (multiple || result == null) continue;
                        return isClass ? Revision.this.checkActivationChain(result) : result;
                    }
                }
                if (isClass) {
                    Class<?> clazz = this.findOwnClass(name);
                    if (clazz != null) {
                        return Revision.this.checkActivationChain(clazz);
                    }
                } else {
                    Object result = this.findOwnResources(BundleImpl.stripTrailing(name), true, multiple, resources);
                    if (!multiple && result != null) {
                        return result;
                    }
                }
                if (Revision.this.exportIndex.contains(pkg)) {
                    return null;
                }
                if (!Revision.this.dynamicImports.isEmpty()) {
                    Iterator<BundleRequirement> iter = Revision.this.dynamicImports.iterator();
                    while (iter.hasNext()) {
                        BundleRevision rev;
                        boolean wildcard;
                        List<BundleCapability> matches;
                        BundleRequirement dynImport = iter.next();
                        String dynImportPackage = dynImport.getDirectives().get("x-int");
                        if (RFC1960Filter.stringCompare(dynImportPackage.toCharArray(), 0, pkg.toCharArray(), 0) != 0 || (matches = BundleImpl.this.framework.resolveDynamic(Revision.this, pkg, dynImportPackage, dynImport, wildcard = "multiple".equals(dynImport.getDirectives().get("cardinality")))) == null || matches.size() <= 0) continue;
                        BundleCapability bundleCap = matches.get(0);
                        Resources.ConciergeBundleWire wire = new Resources.ConciergeBundleWire(bundleCap, dynImport);
                        if (Revision.this.wiring == null) {
                            Revision.this.setWiring(new Resources.ConciergeBundleWiring(Revision.this, null));
                        }
                        Revision.this.wiring.addWire(wire);
                        ((Resources.ConciergeBundleWiring)bundleCap.getRevision().getWiring()).addWire(wire);
                        Revision.this.packageImportWires.put((String)bundleCap.getAttributes().get("osgi.wiring.package"), wire);
                        if (!wildcard) {
                            iter.remove();
                        }
                        if (!((rev = bundleCap.getRevision()) instanceof Revision)) {
                            if (isClass) {
                                return BundleImpl.this.framework.systemBundleClassLoader.loadClass(name);
                            }
                            if (multiple) {
                                try {
                                    Enumeration<URL> e = BundleImpl.this.framework.systemBundleClassLoader.getResources(name);
                                    while (e.hasMoreElements()) {
                                        resources.add(e.nextElement());
                                    }
                                    continue;
                                }
                                catch (IOException iOException) {
                                    continue;
                                }
                            }
                            return BundleImpl.this.framework.systemBundleClassLoader.getResource(name);
                        }
                        return ((Revision)bundleCap.getRevision()).classloader.findResource1(pkg, name, isClass, multiple, resources);
                    }
                }
                if ("".equals(pkg) && !isClass && !multiple) {
                    return this.getParent().getResource(name);
                }
                return resources;
            }

            Set<String> listResources(String path, String filePattern, int options, HashSet<String> visited) {
                String pkg = BundleImpl.pseudoClassname(BundleImpl.stripTrailing(path.endsWith("/") ? path.substring(0, path.length() - 1) : path));
                HashSet<String> result = new HashSet<String>();
                if (Revision.this.wiring != null) {
                    if ((options & 1) != 0) {
                        for (Map.Entry<String, BundleWire> entry : Revision.this.packageImportWires.entrySet()) {
                            BundleWire delegation;
                            Resources.BundleCapabilityImpl cap;
                            String importPackage = entry.getKey();
                            if (!importPackage.startsWith(pkg) || (cap = (Resources.BundleCapabilityImpl)(delegation = entry.getValue()).getCapability()).hasExcludes() && !cap.filter(BundleImpl.classOf(filePattern))) continue;
                            if ((options & 2) == 0) {
                                result.addAll(((Revision)delegation.getProvider()).classloader.listResources(importPackage.replace('.', '/'), filePattern, options, visited));
                            }
                            visited.add(importPackage);
                        }
                    } else {
                        Resources.BundleCapabilityImpl cap;
                        BundleWire delegation = Revision.this.packageImportWires.get(pkg);
                        if (delegation != null && (!(cap = (Resources.BundleCapabilityImpl)delegation.getCapability()).hasExcludes() || cap.filter(BundleImpl.classOf(filePattern)))) {
                            if ((options & 2) == 0) {
                                result.addAll(((Revision)delegation.getProvider()).classloader.listResources(path, filePattern, options, visited));
                            }
                            visited.add(pkg);
                        }
                    }
                    if (Revision.this.requireBundleWires != null && (options & 2) == 0) {
                        for (BundleWire wire : Revision.this.requireBundleWires) {
                            result.addAll(((Revision)wire.getProvider()).classloader.listResources(path, filePattern, options, new HashSet<String>()));
                        }
                    }
                    result.addAll(this.listOwnResources(path, filePattern, options, visited));
                }
                return new HashSet<String>(result);
            }

            @Override
            protected String findLibrary(String libname) {
                if (Revision.this.nativeLibraries == null) {
                    throw new UnsatisfiedLinkError(libname);
                }
                String lib = null;
                String[] libnames = BundleImpl.this.framework.getLibraryName(libname);
                for (int i = 0; i < libnames.length && (lib = Revision.this.nativeLibraries.get(libnames[i])) == null; ++i) {
                }
                if (BundleImpl.this.framework.DEBUG_CLASSLOADING) {
                    BundleImpl.this.framework.logger.log(4, "Requested " + libname);
                    BundleImpl.this.framework.logger.log(3, "Native libraries " + Revision.this.nativeLibraries);
                }
                if (lib == null) {
                    throw new UnsatisfiedLinkError(libname);
                }
                try {
                    File libfile = new File(BundleImpl.this.storageLocation + "lib", lib);
                    URL url = (URL)this.findOwnResources(lib, true, false, null);
                    BundleImpl.storeFile(libfile, url.openStream());
                    BundleImpl.this.framework.execPermission(libfile);
                    return libfile.getAbsolutePath();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return null;
                }
            }

            /*
             * Exception decompiling
             */
            private synchronized Class<?> findOwnClass(String classname) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private Class<?> findDexClass(String classname) {
                try {
                    if (this.dexFile == null) {
                        String fileName = BundleImpl.this.storageLocation + BundleImpl.BUNDLE_FILE_NAME + Revision.this.revId;
                        this.dexFile = dexFileLoader.invoke(null, fileName, BundleImpl.this.storageLocation + "classes.dex", new Integer(0));
                    }
                    if (this.dexFile != null) {
                        return (Class)dexClassLoader.invoke(this.dexFile, classname.replace('.', '/'), this);
                    }
                }
                catch (Exception e) {
                    return null;
                }
                return null;
            }

            List<String> listOwnResources(String path, String filePattern, int options, HashSet<String> visited) {
                ArrayList<String> result = new ArrayList<String>();
                for (int i = 0; i < Revision.this.classpath.length; ++i) {
                    Vector<URL> urls = Revision.this.searchFiles(Revision.this.classpath[i], path, filePattern, (options & 1) != 0);
                    if (urls == null) continue;
                    for (URL url : urls) {
                        int pos = url.getPath().lastIndexOf(47);
                        String pkg = BundleImpl.pseudoClassname(url.getPath().substring(1, pos));
                        if (visited.contains(pkg)) continue;
                        result.add(url.getPath().substring(1));
                    }
                }
                if (Revision.this.fragments != null) {
                    for (Revision fragment : Revision.this.fragments) {
                        for (int i = 0; i < Revision.this.classpath.length; ++i) {
                            Vector<URL> urls = fragment.searchFiles(Revision.this.classpath[i], path, filePattern, (options & 1) != 0);
                            if (urls == null) continue;
                            for (URL url : urls) {
                                int pos = url.getPath().lastIndexOf(47);
                                String pkg = BundleImpl.pseudoClassname(url.getPath().substring(1, pos));
                                if (visited.contains(pkg)) continue;
                                result.add(url.getPath().substring(1));
                            }
                        }
                    }
                }
                return result;
            }

            Object findOwnResources(String name, boolean useFragments, boolean multiple, Vector<URL> resources) {
                if ("".equals(name)) {
                    return resources;
                }
                Vector<URL> results = resources == null ? new Vector<URL>() : resources;
                try {
                    for (int i = 0; i < Revision.this.classpath.length; ++i) {
                        URL url = Revision.this.lookupFile(Revision.this.classpath[i], name);
                        if (url == null) continue;
                        if (!multiple) {
                            return url;
                        }
                        results.add(url);
                    }
                    if (useFragments && Revision.this.fragments != null) {
                        for (Revision fragment : Revision.this.fragments) {
                            if (fragment == null) {
                                throw new IllegalStateException("REVISION IS NULL");
                            }
                            for (int i = 0; i < Revision.this.classpath.length; ++i) {
                                URL url = fragment.lookupFile(Revision.this.classpath[i], name);
                                if (url == null) continue;
                                if (!multiple) {
                                    return url;
                                }
                                results.add(url);
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                return results.isEmpty() ? resources : results;
            }

            private Object requireBundleLookup(String pkg, String name, boolean isClass, boolean multiple, Vector<URL> resources, Set<Bundle> visited) throws ClassNotFoundException {
                Object result;
                if (visited.contains(BundleImpl.this)) {
                    return null;
                }
                visited.add(BundleImpl.this);
                if (Revision.this.requireBundleWires != null) {
                    for (BundleWire wire : Revision.this.requireBundleWires) {
                        if (!"reexport".equals(wire.getRequirement().getDirectives().get("visibility"))) continue;
                        result = ((Revision)wire.getProvider()).classloader.requireBundleLookup(pkg, name, isClass, multiple, resources, visited);
                        if (!multiple && result != null) {
                            return result;
                        }
                        if (result == null) continue;
                        resources.addAll((Vector)result);
                    }
                }
                if (Revision.this.exportIndex.contains(pkg)) {
                    BundleWire delegation = Revision.this.packageImportWires.get(pkg);
                    BundleClassLoader exportLoader = delegation != null ? ((Revision)delegation.getProvider()).classloader : this;
                    if (isClass) {
                        return exportLoader.findOwnClass(name);
                    }
                    result = exportLoader.findOwnResources(name, true, multiple, resources);
                    if (!multiple) {
                        return result;
                    }
                    if (result != null) {
                        resources.addAll((Vector)result);
                    }
                }
                return null;
            }

            private void definePackage(String pkg) {
                try {
                    this.definePackage(pkg, null, null, null, null, null, null, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }
}

