/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge.service.log;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogServiceImpl
implements LogReaderService {
    private final Vector<LogEntryImpl> logBuffer;
    private final List<LogListener> logListeners = new ArrayList<LogListener>(0);
    private final int LOG_BUFFER_SIZE;
    private final int LOG_LEVEL;
    private final boolean QUIET;
    protected static final String[] LEVELS = new String[]{"NULL", "ERROR", "WARNING", "INFO", "DEBUG"};
    public final ServiceFactory<LogService> factory = new LogServiceFactory();

    protected static final String getLevelString(int level) {
        if (level < 0 || level > 4) {
            return Integer.toString(level);
        }
        return LEVELS[level];
    }

    public LogServiceImpl(int buffersize, int loglevel, boolean quiet) {
        this.LOG_BUFFER_SIZE = buffersize;
        this.LOG_LEVEL = loglevel < 0 ? 0 : (loglevel > 4 ? 4 : loglevel);
        this.QUIET = quiet;
        this.logBuffer = new Vector(this.LOG_BUFFER_SIZE);
        if (!this.QUIET) {
            System.out.println("Logger initialized, loglevel is " + LEVELS[this.LOG_LEVEL]);
        }
    }

    protected void log(int level, String message, Throwable throwable, ServiceReference<?> sref, Bundle bundle) {
        if (level <= this.LOG_LEVEL) {
            LogEntryImpl entry = LogEntryImpl.getEntry(level, message, throwable, sref, bundle);
            this.logBuffer.add(entry);
            if (this.logBuffer.size() > this.LOG_BUFFER_SIZE) {
                LogEntryImpl.releaseEntry(this.logBuffer.remove(0));
            }
            Iterator<LogListener> listeners = this.logListeners.iterator();
            while (listeners.hasNext()) {
                listeners.next().logged(entry);
            }
            if (!this.QUIET) {
                System.out.println(entry);
            }
        }
    }

    @Override
    public void addLogListener(LogListener listener) {
        this.logListeners.add(listener);
    }

    @Override
    public void removeLogListener(LogListener listener) {
        this.logListeners.remove(listener);
    }

    @Override
    public Enumeration<? extends LogEntry> getLog() {
        return this.logBuffer.elements();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LogEntryImpl
    implements LogEntry {
        private int level;
        private String message;
        private ServiceReference<?> sref;
        private Throwable exception;
        private Bundle bundle;
        private long time;
        private static final List<LogEntryImpl> entryRecyclingList = new ArrayList<LogEntryImpl>(5);
        private static final int THRESHOLD = 5;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static LogEntryImpl getEntry(int level, String message, Throwable throwable, ServiceReference<?> sref, Bundle bundle) {
            List<LogEntryImpl> list = entryRecyclingList;
            synchronized (list) {
                LogEntryImpl entry = entryRecyclingList.isEmpty() ? new LogEntryImpl() : entryRecyclingList.remove(0);
                entry.log(level, message, throwable, sref, bundle);
                return entry;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static void releaseEntry(LogEntryImpl entry) {
            List<LogEntryImpl> list = entryRecyclingList;
            synchronized (list) {
                if (entryRecyclingList.size() < 5) {
                    entry.log(0, null, null, null, null);
                    entryRecyclingList.add(entry);
                }
            }
        }

        private LogEntryImpl() {
        }

        private void log(int level, String message, Throwable exception, ServiceReference<?> sref, Bundle bundle) {
            this.level = level;
            this.message = message;
            this.exception = exception;
            this.sref = sref;
            this.bundle = bundle;
            this.time = System.currentTimeMillis();
        }

        @Override
        public Bundle getBundle() {
            return this.bundle;
        }

        @Override
        public ServiceReference<?> getServiceReference() {
            return this.sref;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public Throwable getException() {
            return this.exception;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("[").append(new Date(this.time)).append("] [").append(LogServiceImpl.getLevelString(this.level)).append("] ");
            if (this.sref != null) {
                buffer.append("Bundle: ");
                buffer.append(this.sref.getBundle());
                buffer.append(" ");
                buffer.append("ServiceReference: ");
                buffer.append(this.sref);
                buffer.append(" ");
            }
            buffer.append(this.message);
            if (this.exception != null) {
                buffer.append("\n\tException: ");
                buffer.append(this.exception.getMessage());
            }
            return buffer.toString();
        }
    }

    private final class LogServiceInstance
    implements LogService {
        private final Bundle bundle;

        protected LogServiceInstance(Bundle bundle) {
            this.bundle = bundle;
        }

        public void log(int level, String message) {
            LogServiceImpl.this.log(level, message, null, null, this.bundle);
        }

        public void log(int level, String message, Throwable exception) {
            LogServiceImpl.this.log(level, message, exception, null, this.bundle);
        }

        public void log(ServiceReference sr, int level, String message) {
            LogServiceImpl.this.log(level, message, null, sr, this.bundle);
        }

        public void log(ServiceReference sr, int level, String message, Throwable exception) {
            LogServiceImpl.this.log(level, message, exception, sr, this.bundle);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class LogServiceFactory
    implements ServiceFactory<LogService> {
        LogServiceFactory() {
        }

        @Override
        public LogService getService(Bundle bundle, ServiceRegistration<LogService> registration) {
            return new LogServiceInstance(bundle);
        }

        @Override
        public void ungetService(Bundle bundle, ServiceRegistration<LogService> registration, LogService service) {
        }
    }
}

