/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.db;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.datasource.DBSupportedTypesMap;
import org.eclipse.dirigible.repository.datasource.db.dialect.IDialectSpecifier;
import org.eclipse.dirigible.repository.ext.db.AbstractDataUpdater;
import org.eclipse.dirigible.repository.ext.db.DBUtils;
import org.eclipse.dirigible.repository.ext.db.Messages;
import org.eclipse.dirigible.repository.logging.Logger;

public class DatabaseUpdater
extends AbstractDataUpdater {
    private static final String DASH = " - ";
    private static final String AUTOMATIC_DROP_COLUMN_NOT_SUPPORTED = Messages.getString("DatabaseUpdater.AUTOMATIC_DROP_COLUMN_NOT_SUPPORTED");
    private static final String AS = " AS ";
    private static final String CREATE_VIEW = "CREATE VIEW ";
    private static final String DROP_VIEW = "DROP VIEW ";
    private static final String QUERY = "query";
    private static final String CANNOT_BE_CHANGED_TO = Messages.getString("DatabaseUpdater.CANNOT_BE_CHANGED_TO");
    private static final String TYPE2 = Messages.getString("DatabaseUpdater.TYPE2");
    private static final String ADDING_PRIMARY_KEY_COLUMN = Messages.getString("DatabaseUpdater.ADDING_PRIMARY_KEY_COLUMN");
    private static final String ADDING_NOT_NULL_COLUMN = Messages.getString("DatabaseUpdater.ADDING_NOT_NULL_COLUMN");
    private static final String AND_COLUMN = Messages.getString("DatabaseUpdater.AND_COLUMN");
    private static final String INCOMPATIBLE_CHANGE_OF_TABLE = Messages.getString("DatabaseUpdater.INCOMPATIBLE_CHANGE_OF_TABLE");
    private static final String ADD = "ADD ";
    private static final String ALTER_TABLE = "ALTER TABLE ";
    private static final String COLUMN_DEFAULT_VALUE = "defaultValue";
    private static final String COLUMN_PRIMARY_KEY = "primaryKey";
    private static final String COLUMN_NOT_NULL = "notNull";
    private static final String COLUMN_LENGTH = "length";
    private static final String COLUMN_TYPE = "type";
    private static final String COLUMN_NAME = "name";
    private static final String COLUMNS = "columns";
    private static final String CREATE_TABLE = "CREATE TABLE ";
    private static final String VIEW_NAME = "viewName";
    private static final String TABLE_NAME = "tableName";
    private static final String DEFAULT = "DEFAULT ";
    private static final String PRIMARY_KEY = "PRIMARY KEY ";
    private static final String NOT_NULL = "NOT NULL ";
    private static final Logger logger = Logger.getLogger(DatabaseUpdater.class);
    public static final String EXTENSION_TABLE = ".table";
    public static final String EXTENSION_VIEW = ".view";
    public static final String REGISTRY_DATA_STRUCTURES_DEFAULT = "/db/dirigible/registry/public/DataStructures";
    private IRepository repository;
    private DataSource dataSource;
    private String location;
    private DBUtils dbUtils;

    public DatabaseUpdater(IRepository repository, DataSource dataSource, String location) {
        this.repository = repository;
        this.dataSource = dataSource;
        this.location = location;
        this.dbUtils = new DBUtils(dataSource);
    }

    @Override
    public void executeUpdate(List<String> knownFiles, List<String> errors) throws Exception {
        if (knownFiles.size() == 0) {
            return;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            String productName = connection.getMetaData().getDatabaseProductName();
            IDialectSpecifier dialectSpecifier = DBUtils.getDialectSpecifier(productName);
            try {
                for (String dsDefinition : knownFiles) {
                    try {
                        if (dsDefinition.endsWith(EXTENSION_TABLE)) {
                            this.executeTableUpdateMain(connection, dialectSpecifier, dsDefinition);
                            continue;
                        }
                        if (!dsDefinition.endsWith(EXTENSION_VIEW)) continue;
                        this.executeViewUpdateMain(connection, dialectSpecifier, dsDefinition);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        if (errors == null) continue;
                        errors.add(e.getMessage());
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void executeUpdate(List<String> knownFiles, HttpServletRequest request, List<String> errors) throws Exception {
        this.executeUpdate(knownFiles, errors);
    }

    private void executeTableUpdateMain(Connection connection, IDialectSpecifier dialectSpecifier, String dsDefinition) throws SQLException, IOException {
        JsonObject dsDefinitionObject = this.parseTable(dsDefinition);
        String tableName = dsDefinitionObject.get(TABLE_NAME).getAsString();
        tableName = tableName.toUpperCase();
        ResultSet rs = null;
        try {
            boolean exists = DBUtils.isTableOrViewExists(connection, tableName);
            if (exists) {
                this.executeTableUpdate(connection, dialectSpecifier, dsDefinitionObject);
            } else {
                this.executeTableCreate(connection, dialectSpecifier, dsDefinitionObject);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    private void executeViewUpdateMain(Connection connection, IDialectSpecifier dialectSpecifier, String dsDefinition) throws SQLException, IOException {
        JsonObject dsDefinitionObject = this.parseView(dsDefinition);
        String viewName = dsDefinitionObject.get(VIEW_NAME).getAsString();
        viewName = viewName.toUpperCase();
        this.executeViewCreateOrReplace(connection, dsDefinitionObject);
    }

    private void executeTableCreate(Connection connection, IDialectSpecifier dialectSpecifier, JsonObject dsDefinitionObject) throws SQLException {
        StringBuilder sql = new StringBuilder();
        String tableName = dsDefinitionObject.get(TABLE_NAME).getAsString();
        sql.append(CREATE_TABLE + tableName + " (");
        JsonArray columns = dsDefinitionObject.get(COLUMNS).getAsJsonArray();
        int i = 0;
        for (JsonElement jsonElement : columns) {
            if (jsonElement instanceof JsonObject) {
                if (i > 0 && i < columns.size()) {
                    sql.append(", ");
                }
                JsonObject jsonObject = (JsonObject)jsonElement;
                String name = jsonObject.get(COLUMN_NAME).getAsString();
                String type = this.dbUtils.specifyDataType(connection, jsonObject.get(COLUMN_TYPE).getAsString());
                String length = jsonObject.get(COLUMN_LENGTH).getAsString();
                boolean notNull = jsonObject.get(COLUMN_NOT_NULL).getAsBoolean();
                boolean primaryKey = jsonObject.get(COLUMN_PRIMARY_KEY).getAsBoolean();
                String defaultValue = jsonObject.get(COLUMN_DEFAULT_VALUE).getAsString();
                sql.append(String.valueOf(name) + " " + type);
                if ("VARCHAR".equals(type) || "CHAR".equals(type)) {
                    sql.append("(" + length + ") ");
                } else {
                    sql.append(" ");
                }
                if (notNull) {
                    sql.append(NOT_NULL);
                }
                if (primaryKey) {
                    sql.append(PRIMARY_KEY);
                }
                if (defaultValue != null && !"".equals(defaultValue)) {
                    sql.append(DEFAULT + defaultValue + " ");
                }
            }
            ++i;
        }
        sql.append(")");
        String sqlExpression = sql.toString();
        try {
            logger.info(sqlExpression);
            this.executeUpdateSQL(connection, sqlExpression);
        }
        catch (SQLException e) {
            logger.error(sqlExpression);
            throw new SQLException(sqlExpression, e);
        }
    }

    private void executeUpdateSQL(Connection connection, String sql) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.executeUpdate();
    }

    private void executeTableUpdate(Connection connection, IDialectSpecifier dialectSpecifier, JsonObject dsDefinitionObject) throws SQLException {
        StringBuilder sql = new StringBuilder();
        String tableName = dsDefinitionObject.get(TABLE_NAME).getAsString().toUpperCase();
        HashMap<String, String> columnDefinitions = new HashMap<String, String>();
        ResultSet rsColumns = DBUtils.getColumns(connection, tableName);
        while (rsColumns.next()) {
            String typeName = this.dbUtils.specifyDataType(connection, DBSupportedTypesMap.getTypeName((int)rsColumns.getInt(5)));
            columnDefinitions.put(rsColumns.getString(4).toUpperCase(), typeName);
        }
        sql.append(ALTER_TABLE + tableName + " ");
        JsonArray columns = dsDefinitionObject.get(COLUMNS).getAsJsonArray();
        int i = 0;
        StringBuffer addSql = new StringBuffer();
        String alterAddOpen = dialectSpecifier.getAlterAddOpen();
        if (alterAddOpen != null) {
            addSql.append(alterAddOpen);
        }
        for (JsonElement jsonElement : columns) {
            if (!(jsonElement instanceof JsonObject)) continue;
            JsonObject jsonObject = (JsonObject)jsonElement;
            String name = jsonObject.get(COLUMN_NAME).getAsString().toUpperCase();
            String type = this.dbUtils.specifyDataType(connection, jsonObject.get(COLUMN_TYPE).getAsString().toUpperCase());
            String length = jsonObject.get(COLUMN_LENGTH).getAsString();
            boolean notNull = jsonObject.get(COLUMN_NOT_NULL).getAsBoolean();
            boolean primaryKey = jsonObject.get(COLUMN_PRIMARY_KEY).getAsBoolean();
            String defaultValue = jsonObject.get(COLUMN_DEFAULT_VALUE).getAsString();
            if (!columnDefinitions.containsKey(name)) {
                String alterAddCloseEach;
                String alterAddOpenEach;
                if (i > 0) {
                    addSql.append(", ");
                }
                if ((alterAddOpenEach = dialectSpecifier.getAlterAddOpenEach()) != null) {
                    addSql.append(alterAddOpenEach);
                }
                addSql.append(String.valueOf(name) + " " + type);
                if ("VARCHAR".equals(type) || "CHAR".equals(type)) {
                    addSql.append("(" + length + ") ");
                } else {
                    addSql.append(" ");
                }
                if (notNull) {
                    throw new SQLException(String.valueOf(INCOMPATIBLE_CHANGE_OF_TABLE) + tableName + AND_COLUMN + name + ADDING_NOT_NULL_COLUMN);
                }
                if (primaryKey) {
                    throw new SQLException(String.valueOf(INCOMPATIBLE_CHANGE_OF_TABLE) + tableName + AND_COLUMN + name + ADDING_PRIMARY_KEY_COLUMN);
                }
                if (defaultValue != null && !"".equals(defaultValue)) {
                    sql.append(DEFAULT + defaultValue + " ");
                }
                if ((alterAddCloseEach = dialectSpecifier.getAlterAddCloseEach()) != null) {
                    addSql.append(alterAddCloseEach);
                }
                ++i;
                continue;
            }
            if (((String)columnDefinitions.get(name)).equals(type)) continue;
            throw new SQLException(String.valueOf(INCOMPATIBLE_CHANGE_OF_TABLE) + tableName + AND_COLUMN + name + TYPE2 + (String)columnDefinitions.get(name) + CANNOT_BE_CHANGED_TO + type);
        }
        if (i > 0) {
            String alterAddClose = dialectSpecifier.getAlterAddClose();
            if (alterAddClose != null) {
                addSql.append(alterAddClose);
            }
            sql.append(addSql.toString());
        }
        if (columnDefinitions.size() > columns.size()) {
            throw new SQLException(String.valueOf(INCOMPATIBLE_CHANGE_OF_TABLE) + tableName + DASH + AUTOMATIC_DROP_COLUMN_NOT_SUPPORTED);
        }
        if (i > 0) {
            String sqlExpression = sql.toString();
            try {
                logger.info(sqlExpression);
                this.executeUpdateSQL(connection, sqlExpression);
            }
            catch (SQLException e) {
                logger.error(sqlExpression);
                throw new SQLException(sqlExpression, e);
            }
        }
    }

    private JsonObject parseTable(String dsDefinition) throws IOException {
        IRepository repository = this.repository;
        IResource resource = repository.getResource(dsDefinition);
        String content = new String(resource.getContent());
        JsonParser parser = new JsonParser();
        JsonObject dsDefinitionObject = (JsonObject)parser.parse(content);
        return dsDefinitionObject;
    }

    private void executeViewCreateOrReplace(Connection connection, JsonObject dsDefinitionObject) throws SQLException {
        StringBuilder sql = new StringBuilder();
        String viewName = dsDefinitionObject.get(VIEW_NAME).getAsString().toUpperCase();
        String query = dsDefinitionObject.get(QUERY).getAsString();
        String sqlExpression = null;
        boolean exists = DBUtils.isTableOrViewExists(connection, viewName);
        if (exists) {
            sql.append(DROP_VIEW + viewName);
            sqlExpression = sql.toString();
            try {
                logger.info(sqlExpression);
                this.executeUpdateSQL(connection, sqlExpression);
            }
            catch (SQLException e) {
                logger.error(sqlExpression);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        sql = new StringBuilder();
        sql.append(CREATE_VIEW + viewName + AS + query);
        sqlExpression = sql.toString();
        try {
            logger.info(sqlExpression);
            this.executeUpdateSQL(connection, sqlExpression);
        }
        catch (SQLException e) {
            logger.error(sqlExpression);
            throw new SQLException(sqlExpression, e);
        }
    }

    private JsonObject parseView(String dsDefinition) throws IOException {
        IRepository repository = this.repository;
        IResource resource = repository.getResource(dsDefinition);
        String content = new String(resource.getContent());
        JsonParser parser = new JsonParser();
        JsonObject dsDefinitionObject = (JsonObject)parser.parse(content);
        return dsDefinitionObject;
    }

    @Override
    public void enumerateKnownFiles(ICollection collection, List<String> dsDefinitions) throws IOException {
        if (collection.exists()) {
            List resources = collection.getResources();
            for (IResource resource : resources) {
                if (resource == null || resource.getName() == null || !resource.getName().endsWith(EXTENSION_TABLE) && !resource.getName().endsWith(EXTENSION_VIEW)) continue;
                String fullPath = resource.getPath();
                dsDefinitions.add(fullPath);
            }
            List collections = collection.getCollections();
            for (ICollection subCollection : collections) {
                this.enumerateKnownFiles(subCollection, dsDefinitions);
            }
        }
    }

    @Override
    public IRepository getRepository() {
        return this.repository;
    }

    @Override
    public String getLocation() {
        return this.location;
    }
}

