/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.wiki;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.wiki.Messages;
import org.eclipse.dirigible.runtime.wiki.WikiUtils;

public class WikiProcessor {
    private static final Logger logger = Logger.getLogger(WikiProcessor.class);
    public static final String DEFAULT_WIKI_EXTENSION = ".wiki";
    public static final String CONFLUENCE_EXTENSION = ".confluence";
    public static final String MARKDOWN_EXTENSION = ".markdown";
    public static final String MARKDOWN_EXTENSION2 = ".mdown";
    public static final String MARKDOWN_EXTENSION3 = ".mkdn";
    public static final String MARKDOWN_EXTENSION4 = ".md";
    public static final String MARKDOWN_EXTENSION5 = ".mkd";
    public static final String MARKDOWN_EXTENSION6 = ".mdwn";
    public static final String TEXTILE_EXTENSION = ".textile";
    public static final String TRACWIKI_EXTENSION = ".tracwiki";
    public static final String TWIKI_EXTENSION = ".twiki";
    public static final String BATCH_EXTENSION = ".wikis";
    private static final String ERROR_READING_BATCH_WITH_WIKI_PAGES = Messages.getString("WikiRegistryServlet.ERROR_READING_BATCH_WITH_WIKI_PAGES");
    private static final int WIKI_CACHE_LIMIT = 10000;

    public static byte[] processContent(byte[] rawContent, IEntity entity) throws IOException {
        String name = entity.getName();
        if (name.endsWith(CONFLUENCE_EXTENSION) || name.endsWith(DEFAULT_WIKI_EXTENSION)) {
            return WikiProcessor.wikiToHtml(rawContent, entity, "CONFLUENCE");
        }
        if (name.endsWith(MARKDOWN_EXTENSION) || name.endsWith(MARKDOWN_EXTENSION2) || name.endsWith(MARKDOWN_EXTENSION3) || name.endsWith(MARKDOWN_EXTENSION4) || name.endsWith(MARKDOWN_EXTENSION5) || name.endsWith(MARKDOWN_EXTENSION6)) {
            return WikiProcessor.wikiToHtml(rawContent, entity, "MARKDOWN");
        }
        if (name.endsWith(TEXTILE_EXTENSION)) {
            return WikiProcessor.wikiToHtml(rawContent, entity, "TEXTILE");
        }
        if (name.endsWith(TRACWIKI_EXTENSION)) {
            return WikiProcessor.wikiToHtml(rawContent, entity, "TRACWIKI");
        }
        if (name.endsWith(TWIKI_EXTENSION)) {
            return WikiProcessor.wikiToHtml(rawContent, entity, "TWIKI");
        }
        if (name.endsWith(BATCH_EXTENSION)) {
            return WikiProcessor.batchToHtml(rawContent, entity);
        }
        return null;
    }

    private static byte[] wikiToHtml(byte[] rawContent, IEntity entity, String format) throws IOException {
        byte[] result = null;
        WikiUtils wikiUtils = new WikiUtils();
        String htmlContent = wikiUtils.toHtml(new String(rawContent, "UTF8"), format);
        result = htmlContent.getBytes("UTF8");
        return result;
    }

    private static byte[] batchToHtml(byte[] rawContent, IEntity entity) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(rawContent)));
        String line = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            while ((line = reader.readLine()) != null) {
                IResource wikiResource = entity.getRepository().getResource(String.valueOf(entity.getParent().getPath()) + "/" + line);
                if (wikiResource.exists()) {
                    outputStream.write(WikiProcessor.wikiToHtml(wikiResource.getContent(), (IEntity)wikiResource, "CONFLUENCE"));
                    continue;
                }
                logger.error(String.format("Error while render batch of wiki pages. Resource %s does not exist", wikiResource.getPath()));
            }
        }
        catch (IOException e) {
            throw new IOException(ERROR_READING_BATCH_WITH_WIKI_PAGES, e);
        }
        return outputStream.toByteArray();
    }
}

