/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.helpgenerator.documentation.linkcreators;

import java.io.IOException;
import org.eclipse.ease.helpgenerator.AbstractModuleDoclet;
import org.eclipse.ease.helpgenerator.documentation.ReferenceTokenizer;
import org.eclipse.ease.helpgenerator.documentation.linkcreators.ILinkCreator;

public class ModuleLinkCreator
implements ILinkCreator {
    @Override
    public String createLink(String reference) throws IOException {
        ReferenceTokenizer tokenizer = new ReferenceTokenizer(reference);
        if (tokenizer.isModule()) {
            if (tokenizer.isMethod()) {
                return this.createMethodLink(tokenizer.getQualifiedName(), tokenizer.getMethod(), tokenizer.getParameters());
            }
            if (tokenizer.isField()) {
                return this.createFieldLink(tokenizer.getQualifiedName(), tokenizer.getMethod());
            }
            if (tokenizer.isClass()) {
                return this.createClassLink(tokenizer.getQualifiedName());
            }
        }
        throw new IOException("Unknown reference: '" + reference + "'");
    }

    private String createFieldLink(String qualifiedName, String field) {
        StringBuilder builder = new StringBuilder();
        builder.append("<a href='");
        if (!qualifiedName.isEmpty()) {
            builder.append(this.createModuleString(qualifiedName));
        }
        builder.append('#');
        builder.append(field);
        builder.append("'>");
        if (!qualifiedName.isEmpty()) {
            builder.append(ReferenceTokenizer.getSimpleClassName(qualifiedName));
            builder.append('.');
        }
        builder.append(field);
        builder.append("</a>");
        return builder.toString();
    }

    private String createMethodLink(String qualifiedName, String method, String parameters) {
        StringBuilder builder = new StringBuilder();
        builder.append("<a href='");
        if (!qualifiedName.isEmpty()) {
            builder.append(this.createModuleString(qualifiedName));
        }
        builder.append('#');
        builder.append(method);
        builder.append("'>");
        if (!qualifiedName.isEmpty()) {
            builder.append(ReferenceTokenizer.getSimpleClassName(qualifiedName));
            builder.append('.');
        }
        builder.append(method);
        builder.append("()");
        builder.append("</a>");
        return builder.toString();
    }

    private String createClassLink(String qualifiedName) {
        StringBuilder builder = new StringBuilder();
        builder.append("<a href='");
        builder.append(this.createModuleString(qualifiedName));
        builder.append("'>");
        builder.append(ReferenceTokenizer.getSimpleClassName(qualifiedName));
        builder.append("</a>");
        return builder.toString();
    }

    private String createModuleString(String qualifiedName) {
        StringBuilder builder = new StringBuilder();
        builder.append("../../");
        builder.append(ReferenceTokenizer.getPackageName(qualifiedName));
        builder.append("/help/");
        builder.append(AbstractModuleDoclet.createHTMLFileName(qualifiedName));
        return builder.toString();
    }
}

