/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ease.Logger;
import org.eclipse.ease.lang.javascript.JavaScriptHelper;
import org.eclipse.ease.modules.AbstractModuleWrapper;
import org.eclipse.ease.modules.IEnvironment;

public class JavaScriptModuleWrapper
extends AbstractModuleWrapper {
    public static List<String> RESERVED_KEYWORDS = new ArrayList<String>();

    static {
        RESERVED_KEYWORDS.add("for");
        RESERVED_KEYWORDS.add("while");
        RESERVED_KEYWORDS.add("delete");
    }

    private static boolean isValidMethodName(String methodName) {
        return JavaScriptHelper.isSaveName(methodName) && !RESERVED_KEYWORDS.contains(methodName);
    }

    public String classInstantiation(Class<?> clazz, String[] parameters) {
        StringBuilder code = new StringBuilder();
        code.append("new Packages.").append(clazz.getName()).append("(");
        if (parameters != null) {
            String[] stringArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                code.append(parameter).append(", ");
                ++n2;
            }
            if (parameters.length > 0) {
                code.delete(code.length() - 2, code.length());
            }
        }
        code.append(")");
        return code.toString();
    }

    public String createFunctionWrapper(IEnvironment environment, String moduleVariable, Method method) {
        StringBuilder javaScriptCode = new StringBuilder();
        List parameters = JavaScriptModuleWrapper.parseParameters((Method)method);
        StringBuilder parameterList = new StringBuilder();
        for (AbstractModuleWrapper.Parameter parameter : parameters) {
            parameterList.append(", ").append(parameter.getName());
        }
        if (parameterList.length() > 2) {
            parameterList.delete(0, 2);
        }
        StringBuilder body = new StringBuilder();
        body.append((CharSequence)this.verifyParameters(parameters));
        body.append(JavaScriptModuleWrapper.getPreExecutionCode((IEnvironment)environment, (Method)method));
        body.append("\tvar ").append("__result").append(" = ").append(moduleVariable).append('.').append(method.getName()).append('(');
        body.append((CharSequence)parameterList);
        body.append(");\n");
        body.append(JavaScriptModuleWrapper.getPostExecutionCode((IEnvironment)environment, (Method)method));
        body.append("\treturn ").append("__result").append(";\n");
        for (String name : JavaScriptModuleWrapper.getMethodNames((Method)method)) {
            if (!JavaScriptModuleWrapper.isValidMethodName(name)) {
                Logger.logError((String)("The method name \"" + name + "\" from the module \"" + moduleVariable + "\" can not be wrapped because it's name is reserved"), (String)"org.eclipse.ease");
                continue;
            }
            if (name.isEmpty()) continue;
            javaScriptCode.append("function ").append(name).append("(").append((CharSequence)parameterList).append(") {\n");
            javaScriptCode.append((CharSequence)body);
            javaScriptCode.append("}\n");
        }
        return javaScriptCode.toString();
    }

    public String createStaticFieldWrapper(IEnvironment environment, String moduleVariable, Field field) {
        return "const " + JavaScriptHelper.getSaveName(field.getName()) + " = " + moduleVariable + "." + field.getName() + ";\n";
    }

    protected String getNullString() {
        return "null";
    }

    public String getSaveVariableName(String variableName) {
        return JavaScriptHelper.getSaveName(variableName);
    }

    private StringBuilder verifyParameters(List<AbstractModuleWrapper.Parameter> parameters) {
        StringBuilder data = new StringBuilder();
        if (!parameters.isEmpty()) {
            AbstractModuleWrapper.Parameter parameter = parameters.get(parameters.size() - 1);
            data.append("\tif (typeof " + parameter.getName() + " === \"undefined\") {\n");
            if (parameter.isOptional()) {
                data.append("\t\t" + parameter.getName() + " = " + this.getDefaultValue(parameter) + ";\n");
            } else {
                data.append("\t\tthrow new java.lang.RuntimeException('Parameter " + parameter.getName() + " is not optional');\n");
            }
            data.append((CharSequence)this.verifyParameters(parameters.subList(0, parameters.size() - 1)));
            data.append("\t}\n");
        }
        return data;
    }
}

