/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.ease.ui.scripts.repository.IScriptLocation;
import org.eclipse.ease.ui.scripts.repository.impl.FileSystemParser;
import org.eclipse.ease.ui.scripts.repository.impl.HttpParser;
import org.eclipse.ease.ui.scripts.repository.impl.RepositoryService;
import org.eclipse.ease.ui.scripts.repository.impl.WorkspaceParser;

public class UpdateRepositoryJob
extends Job {
    private final RepositoryService fRepositoryService;

    public UpdateRepositoryJob(RepositoryService repositoryService) {
        super("Updating script repository");
        this.fRepositoryService = repositoryService;
    }

    protected IStatus run(IProgressMonitor monitor) {
        Collection<IScriptLocation> locations = this.fRepositoryService.getLocations();
        for (IScriptLocation location : locations) {
            if (!location.isUpdatePending()) continue;
            for (IScript script : location.getScripts()) {
                script.setUpdatePending(true);
            }
            Object content = location.getResource();
            if (content instanceof IResource && ((IResource)content).exists()) {
                new WorkspaceParser().parse((IResource)content, location);
            } else if (content instanceof File && ((File)content).exists()) {
                new FileSystemParser().parse((File)content, location);
            } else if (content instanceof URI) {
                try {
                    new HttpParser().parse(((URI)content).toURL().toString(), location);
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                boolean cfr_ignored_0 = content instanceof InputStream;
            }
            for (IScript script : new HashSet<IScript>((Collection<IScript>)location.getScripts())) {
                if (!script.isUpdatePending()) continue;
                this.fRepositoryService.removeScript(script);
            }
        }
        this.fRepositoryService.save();
        this.schedule(1800000L);
        return Status.OK_STATUS;
    }

    synchronized void update(IScriptLocation entry) {
        entry.setUpdatePending(true);
        if (this.getState() != 4) {
            this.cancel();
        }
        this.schedule(300L);
    }

    synchronized void update() {
        for (IScriptLocation location : this.fRepositoryService.getLocations()) {
            location.setUpdatePending(true);
        }
        if (this.getState() != 4) {
            this.cancel();
        }
        this.schedule(300L);
    }

    synchronized void update(IScript script) {
        script.setUpdatePending(true);
        if (this.getState() != 4) {
            this.cancel();
        }
        this.schedule(300L);
    }
}

