/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.debugger;

import java.io.File;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.ease.ExitException;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.AbstractEaseDebugger;
import org.eclipse.ease.debugging.EaseDebugFrame;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.IScriptRegistry;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.debugging.dispatcher.IEventProcessor;
import org.eclipse.ease.lang.python.debugger.ICodeTracer;
import org.eclipse.ease.lang.python.debugger.IPyFrame;
import org.eclipse.ease.lang.python.debugger.IPythonScriptRegistry;

public class PythonDebugger
extends AbstractEaseDebugger
implements IEventProcessor,
IExecutionListener {
    public static final String PYTHON_DEBUGGER_VARIABLE = "_pyease_debugger";
    private ICodeTracer fCodeTracer;
    private boolean fBreakpointsDisabled = false;

    public PythonDebugger(IDebugEngine engine, boolean showDynamicCode) {
        super(engine, showDynamicCode);
    }

    public void setCodeTracer(ICodeTracer tracer) {
        this.fCodeTracer = tracer;
    }

    protected ScriptStackTrace getStacktrace(IPyFrame origin) {
        ScriptStackTrace trace = new ScriptStackTrace();
        IPythonScriptRegistry registry = this.getScriptRegistry();
        if (registry == null) {
            return trace;
        }
        IPyFrame frame = origin;
        while (frame != null) {
            Script script = registry.getScript(frame.getFilename());
            if (script != null && this.isTrackedScript(registry.getScript(frame.getFilename()))) {
                trace.add((Object)new PythonDebugFrame(frame));
            }
            frame = frame.getParent();
        }
        return trace;
    }

    public void traceDispatch(IPyFrame frame, String type) {
        Script script = null;
        IPythonScriptRegistry registry = this.getScriptRegistry();
        if (registry != null) {
            script = registry.getScript(frame.getFilename());
        }
        if (script != null && this.isTrackedScript(script)) {
            this.setStacktrace(this.getStacktrace(frame));
            if (frame.getLineNumber() != 0) {
                this.fBreakpointsDisabled = "return".equals(type) || "call".equals(type);
                this.processLine(script, frame.getLineNumber());
            }
        }
    }

    protected boolean isActiveBreakpoint(Script script, int lineNumber) {
        if (!this.fBreakpointsDisabled) {
            return super.isActiveBreakpoint(script, lineNumber);
        }
        return false;
    }

    public Object execute(Script script) {
        try {
            String reference = script.getTitle();
            IPythonScriptRegistry registry = this.getScriptRegistry();
            if (registry != null) {
                registry.put(script);
                reference = registry.getReference(script);
            }
            return this.fCodeTracer.run(script, reference);
        }
        catch (Exception e) {
            if (this.getThreadState((Object)this.getThread()).fResumeType == 8) {
                throw new ExitException((Object)"Debug aborted by user");
            }
            throw e;
        }
    }

    public IPythonScriptRegistry getScriptRegistry() {
        IScriptRegistry scriptRegistry = super.getScriptRegistry();
        if (scriptRegistry instanceof IPythonScriptRegistry) {
            return (IPythonScriptRegistry)scriptRegistry;
        }
        return null;
    }

    public class PythonDebugFrame
    extends EaseDebugFrame
    implements IScriptDebugFrame {
        private final IPyFrame fFrame;

        public PythonDebugFrame(IPyFrame frame) {
            super(PythonDebugger.this.getScriptRegistry() != null ? PythonDebugger.this.getScriptRegistry().getScript(frame.getFilename()) : null, frame.getLineNumber(), 1);
            this.fFrame = frame;
        }

        public String getName() {
            Script script = this.getScript();
            if (script.isDynamic()) {
                String title = this.getScript().getTitle();
                return title != null ? "Dynamic: " + title : "(Dynamic)";
            }
            Object command = this.getScript().getCommand();
            if (command != null) {
                if (command instanceof IFile) {
                    return ((IFile)command).getName();
                }
                if (command instanceof File) {
                    return ((File)command).getName();
                }
                return command.toString();
            }
            return "(unknown source)";
        }

        public Map<String, Object> getVariables() {
            return this.fFrame.getVariables();
        }

        public void setVariable(String name, Object content) {
            this.fFrame.setVariable(name, content);
        }

        public Object inject(String expression) throws Throwable {
            return PythonDebugger.this.getEngine().inject((Object)expression);
        }
    }
}

