/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest;

import java.util.List;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.lang.unittest.AssertionException;
import org.eclipse.ease.lang.unittest.IAssertion;

public class DefaultAssertion
implements IAssertion {
    private final String fErrorMessage;
    private final boolean fValid;
    private final List<IScriptDebugFrame> fStackTrace;

    public DefaultAssertion(List<IScriptDebugFrame> stackTrace, boolean valid, String errorDescription) {
        this.fStackTrace = stackTrace;
        this.fValid = valid;
        this.fErrorMessage = errorDescription;
    }

    public DefaultAssertion(boolean valid, String errorDescription) {
        this(null, valid, errorDescription);
    }

    public DefaultAssertion(String errorDescription) {
        this(null, false, errorDescription);
    }

    @Override
    public boolean isValid() {
        return this.fValid;
    }

    public List<IScriptDebugFrame> getStackTrace() {
        return this.fStackTrace;
    }

    public String toString() {
        if (this.isValid()) {
            return IAssertion.VALID.toString();
        }
        return this.fErrorMessage != null ? this.fErrorMessage : IAssertion.INVALID.toString();
    }

    @Override
    public void throwOnError() throws AssertionException {
        if (!this.isValid()) {
            throw new AssertionException(this.toString());
        }
    }
}

