/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.runtime.impl;

import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.lang.unittest.runtime.IMetadata;
import org.eclipse.ease.lang.unittest.runtime.IRuntimeFactory;
import org.eclipse.ease.lang.unittest.runtime.IRuntimePackage;
import org.eclipse.ease.lang.unittest.runtime.IStackTraceContainer;
import org.eclipse.ease.lang.unittest.runtime.ITest;
import org.eclipse.ease.lang.unittest.runtime.ITestClass;
import org.eclipse.ease.lang.unittest.runtime.ITestFile;
import org.eclipse.ease.lang.unittest.runtime.ITestFolder;
import org.eclipse.ease.lang.unittest.runtime.ITestResult;
import org.eclipse.ease.lang.unittest.runtime.ITestSuite;
import org.eclipse.ease.lang.unittest.runtime.TestStatus;
import org.eclipse.ease.lang.unittest.runtime.impl.Metadata;
import org.eclipse.ease.lang.unittest.runtime.impl.StackTraceContainer;
import org.eclipse.ease.lang.unittest.runtime.impl.Test;
import org.eclipse.ease.lang.unittest.runtime.impl.TestClass;
import org.eclipse.ease.lang.unittest.runtime.impl.TestFile;
import org.eclipse.ease.lang.unittest.runtime.impl.TestFolder;
import org.eclipse.ease.lang.unittest.runtime.impl.TestResult;
import org.eclipse.ease.lang.unittest.runtime.impl.TestSuite;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class RuntimeFactory
extends EFactoryImpl
implements IRuntimeFactory {
    public static IRuntimeFactory init() {
        try {
            IRuntimeFactory theRuntimeFactory = (IRuntimeFactory)EPackage.Registry.INSTANCE.getEFactory("http://eclipse.org/ease/unittest/runtime");
            if (theRuntimeFactory != null) {
                return theRuntimeFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new RuntimeFactory();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 2: {
                return this.createTest();
            }
            case 3: {
                return this.createTestSuite();
            }
            case 4: {
                return this.createTestFolder();
            }
            case 5: {
                return this.createTestClass();
            }
            case 6: {
                return this.createTestResult();
            }
            case 7: {
                return this.createTestFile();
            }
            case 8: {
                return this.createStackTraceContainer();
            }
            case 9: {
                return this.createMetadata();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 10: {
                return this.createTestStatusFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 10: {
                return this.convertTestStatusToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public ITest createTest() {
        Test test = new Test();
        return test;
    }

    @Override
    public ITestSuite createTestSuite() {
        TestSuite testSuite = new TestSuite();
        return testSuite;
    }

    @Override
    public ITestFolder createTestFolder() {
        TestFolder testFolder = new TestFolder();
        return testFolder;
    }

    @Override
    public ITestClass createTestClass() {
        TestClass testClass = new TestClass();
        return testClass;
    }

    @Override
    public ITestResult createTestResult() {
        TestResult testResult = new TestResult();
        return testResult;
    }

    @Override
    public ITestFile createTestFile() {
        TestFile testFile = new TestFile();
        return testFile;
    }

    @Override
    public IStackTraceContainer createStackTraceContainer() {
        StackTraceContainer stackTraceContainer = new StackTraceContainer();
        return stackTraceContainer;
    }

    @Override
    public IMetadata createMetadata() {
        Metadata metadata = new Metadata();
        return metadata;
    }

    public TestStatus createTestStatusFromString(EDataType eDataType, String initialValue) {
        TestStatus result = TestStatus.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertTestStatusToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public IScriptEngine createScriptEngineFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null || initialValue.isEmpty()) {
            return null;
        }
        throw new RuntimeException("Script engine lookup not implemented");
    }

    @Override
    public IRuntimePackage getRuntimePackage() {
        return (IRuntimePackage)this.getEPackage();
    }

    @Deprecated
    public static IRuntimePackage getPackage() {
        return IRuntimePackage.eINSTANCE;
    }
}

