/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.examples.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;

public class FindInstanceRefsAction
extends Action {
    protected TreeSelection activeSelection = null;
    protected EObject refObject = null;

    public FindInstanceRefsAction(EObject refObject, IStructuredSelection selection) {
        super(FindInstanceRefsAction.extractText(refObject));
        this.refObject = refObject;
        this.activeSelection = (TreeSelection)selection;
    }

    public void run() {
        if (this.activeSelection != null) {
            TreeSelection typeSelection = this.getRefSelection();
            ExtendedPlatformUI.getActivePage().getActivePart().getSite().getSelectionProvider().setSelection((ISelection)typeSelection);
        }
    }

    private static String extractText(EObject refObject) {
        ArrayList<EObject> objectList = new ArrayList<EObject>();
        String text = "";
        text = String.valueOf(text) + refObject.eClass().getName();
        text = String.valueOf(text) + " [";
        EObject parent = refObject.eContainer();
        objectList.add(parent);
        while (parent.eContainer() != null) {
            parent = parent.eContainer();
            objectList.add(parent);
        }
        Collections.reverse(objectList);
        for (EObject obj : objectList) {
            EStructuralFeature eStructuralFeature = obj.eClass().getEStructuralFeature("shortName");
            text = String.valueOf(text) + (eStructuralFeature != null ? obj.eGet(eStructuralFeature) : "");
            text = String.valueOf(text) + "/";
        }
        text = String.valueOf(text) + "]";
        return text;
    }

    private TreeSelection getRefSelection() {
        ArrayList<Object> objectList = new ArrayList<Object>();
        objectList.add(this.refObject);
        EObject parent = this.refObject.eContainer();
        objectList.add(parent);
        while (parent.eContainer() != null) {
            parent = parent.eContainer();
            objectList.add(parent);
        }
        this.addHead(objectList);
        Collections.reverse(objectList);
        TreePath treePath = new TreePath(objectList.toArray());
        TreeSelection selection = new TreeSelection(treePath);
        return selection;
    }

    private void addHead(List<Object> objectList) {
        TreePath treePath = this.activeSelection.getPaths()[0];
        objectList.add(treePath.getSegment(1));
        objectList.add(treePath.getSegment(0));
    }
}

