/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.examples.explorer;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.eatop.common.ui.util.ModelSearcher;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.StaticSelectionCommandAction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.explorer.actions.providers.BasicModelEditActionProvider;
import org.eclipse.sphinx.platform.ui.util.SelectionUtil;

public class ModelExampleActionProvider
extends BasicModelEditActionProvider {
    protected void updateActions(ISelection selection) {
        TransactionalEditingDomain editingDomain = this.getEditingDomainFromSelection(selection);
        this.cutAction.setEditingDomain((EditingDomain)editingDomain);
        this.copyAction.setEditingDomain((EditingDomain)editingDomain);
        this.pasteAction.setEditingDomain((EditingDomain)editingDomain);
        this.deleteAction.setEditingDomain((EditingDomain)editingDomain);
        IStructuredSelection structuredSelection = SelectionUtil.getStructuredSelection((ISelection)selection);
        this.cutAction.selectionChanged(structuredSelection);
        this.copyAction.selectionChanged(structuredSelection);
        this.pasteAction.selectionChanged(structuredSelection);
        this.deleteAction.selectionChanged(structuredSelection);
        if (this.shouldCreateCreateChildActions(structuredSelection.getFirstElement())) {
            Collection newChildDescriptors = null;
            Collection newSiblingDescriptors = null;
            if (editingDomain != null && structuredSelection.size() == 1) {
                newChildDescriptors = this.getNewChildDescriptors(editingDomain, structuredSelection.getFirstElement(), null);
                newSiblingDescriptors = this.getNewChildDescriptors(editingDomain, null, structuredSelection.getFirstElement());
            }
            this.createChildActions = this.generateCreateChildActions(editingDomain, newChildDescriptors, selection);
            this.createChildSubmenuActions = this.extractSubmenuActions(this.createChildActions, selection);
            this.createSiblingActions = this.generateCreateSiblingActions(editingDomain, newSiblingDescriptors, selection);
            this.createSiblingSubmenuActions = this.extractSubmenuActions(this.createSiblingActions, selection);
        }
    }

    public void fillContextMenu(IMenuManager menuManager) {
        this.updateActions(this.getContext().getSelection());
        MenuManager createChildMenuManager = new MenuManager("New Child");
        this.populateManager((IContributionManager)createChildMenuManager, this.createChildSubmenuActions, null);
        this.populateManager((IContributionManager)createChildMenuManager, this.createChildActions, null);
        menuManager.appendToGroup("group.new", (IContributionItem)createChildMenuManager);
        MenuManager createSiblingMenuManager = new MenuManager("New Sibling");
        this.populateManager((IContributionManager)createSiblingMenuManager, this.createSiblingSubmenuActions, null);
        this.populateManager((IContributionManager)createSiblingMenuManager, this.createSiblingActions, null);
        menuManager.appendToGroup("group.new", (IContributionItem)createSiblingMenuManager);
        menuManager.appendToGroup("group.edit", (IContributionItem)new ActionContributionItem((IAction)this.cutAction));
        menuManager.appendToGroup("group.edit", (IContributionItem)new ActionContributionItem((IAction)this.copyAction));
        menuManager.appendToGroup("group.edit", (IContributionItem)new ActionContributionItem((IAction)this.pasteAction));
        menuManager.appendToGroup("group.edit", (IContributionItem)new ActionContributionItem((IAction)this.deleteAction));
    }

    protected Map<String, Collection<IAction>> extractSubmenuActions(Collection<IAction> createActions, ISelection selection) {
        TreeMap<String, Collection<IAction>> createSubmenuActions = new TreeMap<String, Collection<IAction>>();
        if (createActions != null) {
            Iterator<IAction> actions = createActions.iterator();
            while (actions.hasNext()) {
                StringTokenizer st;
                IAction action = actions.next();
                if (action.getText() == null) continue;
                String txt = action.getText();
                Command c = this.getCommandFromAction((StaticSelectionCommandAction)action);
                if (c != null) {
                    CreateChildCommand childCommand = (CreateChildCommand)c;
                    txt = this.prepareAddChildCommandText(childCommand, txt);
                    txt = this.formatOriginalPackageNameText(childCommand, txt);
                }
                if ((st = new StringTokenizer(txt, "|")).countTokens() < 2) continue;
                String first = txt.substring(0, txt.lastIndexOf(124));
                String packagePart = first.lastIndexOf(124) > -1 ? first.substring(0, first.lastIndexOf(124)).trim() : first.trim();
                first = ModelSearcher.getPrettyPackageName((String)packagePart);
                String tail = txt.substring(txt.lastIndexOf(124) + 1);
                IStructuredSelection structuredSelection = SelectionUtil.getStructuredSelection((ISelection)selection);
                if (this.isTransient(structuredSelection.getFirstElement())) {
                    action.setText(first.trim());
                    continue;
                }
                Collection<IAction> submenuActions = (ArrayList<IAction>)createSubmenuActions.get(first.trim());
                if (submenuActions == null) {
                    submenuActions = new ArrayList<IAction>();
                    createSubmenuActions.put(first.trim(), submenuActions);
                }
                action.setText(tail.trim());
                submenuActions.add(action);
                submenuActions = (Collection)createSubmenuActions.get("All");
                if (submenuActions == null) {
                    submenuActions = new ArrayList();
                    createSubmenuActions.put("All", submenuActions);
                }
                submenuActions.add(action);
                actions.remove();
            }
        }
        return createSubmenuActions;
    }

    private String prepareAddChildCommandText(CreateChildCommand childCommand, String oldText) {
        Collection o = childCommand.getResult();
        String text = oldText;
        if (o instanceof Collection) {
            o = o.iterator().next();
        }
        if (o instanceof EObject) {
            EObject eo = (EObject)o;
            if (ModelSearcher.isInstanceRef((EObject)eo)) {
                text = text.replace("|", "(Instance Ref) |");
            }
            EStructuralFeature nameFeature = eo.eClass().eContainer().eClass().getEStructuralFeature("name");
            String packageName = eo.eClass().eContainer().eGet(nameFeature).toString();
            if (packageName != null) {
                text = String.valueOf(packageName) + " | " + text;
            }
            return text;
        }
        return oldText;
    }

    private String formatOriginalPackageNameText(CreateChildCommand childCommand, String oldText) {
        Collection o = childCommand.getResult();
        String text = oldText;
        if (o instanceof Collection) {
            o = o.iterator().next();
        }
        if (o instanceof EObject) {
            String annotation = EcoreUtil.getAnnotation((EModelElement)((EObject)o).eClass(), (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"documentation");
            String qualifiedName = annotation.substring(annotation.indexOf("<em><b>") + "<em><b>".length(), annotation.lastIndexOf("</b></em>"));
            String packageName = qualifiedName.substring(qualifiedName.indexOf("EAST-ADL.") + "EAST-ADL.".length());
            packageName = packageName.substring(0, packageName.indexOf("."));
            text = text.substring(text.lastIndexOf("|"));
            text = String.valueOf(packageName) + " " + text;
            return text;
        }
        return text;
    }

    private Command getCommandFromAction(StaticSelectionCommandAction action) {
        try {
            Field f = action.getClass().getSuperclass().getDeclaredField("command");
            f.setAccessible(true);
            Command c = (Command)f.get(action);
            return c;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void populateManager(IContributionManager manager, Map<String, Collection<IAction>> submenuActions, String contributionId) {
        if (submenuActions != null) {
            for (Map.Entry<String, Collection<IAction>> entry : submenuActions.entrySet()) {
                StringTokenizer st = new StringTokenizer(entry.getKey(), "|");
                int count = st.countTokens();
                IContributionManager lastManager = manager;
                int i = 0;
                while (i < count) {
                    MenuManager submenuManager = new MenuManager(st.nextToken());
                    if (contributionId != null) {
                        lastManager.insertBefore(contributionId, (IContributionItem)submenuManager);
                    } else {
                        lastManager.add((IContributionItem)submenuManager);
                    }
                    lastManager = submenuManager;
                    if (i == count - 1) {
                        this.populateManager((IContributionManager)submenuManager, entry.getValue(), null);
                    }
                    ++i;
                }
            }
        }
    }
}

