/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.examples.explorer.decorators;

import java.util.Collection;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.eatop.common.ui.util.ModelSearcher;
import org.eclipse.eatop.examples.explorer.internal.messages.Messages;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.sphinx.emf.domain.factory.EditingDomainFactoryListenerRegistry;
import org.eclipse.sphinx.emf.domain.factory.ITransactionalEditingDomainFactoryListener;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.util.WorkspaceTransactionUtil;
import org.eclipse.sphinx.emf.workspace.domain.WorkspaceEditingDomainManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ModelReferenceDecorator
implements ILightweightLabelDecorator,
ITransactionalEditingDomainFactoryListener {
    private static ImageDescriptor referenceOverlay = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.eatop.examples.explorer", (String)Messages.Path_ReferenceOverlayImage);
    private static ImageDescriptor instanceRefOverlay = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.eatop.examples.explorer", (String)Messages.Path_InstanceRefOverlayImage);
    private IOperationHistoryListener affectedObjectsListener = this.createAffectedObjectsListener();

    public ModelReferenceDecorator() {
        Assert.isNotNull((Object)this.affectedObjectsListener);
        EditingDomainFactoryListenerRegistry.INSTANCE.addListener(MetaModelDescriptorRegistry.ANY_MM, null, (ITransactionalEditingDomainFactoryListener)this, null);
        for (TransactionalEditingDomain editingDomain : WorkspaceEditingDomainManager.INSTANCE.getEditingDomainMapping().getEditingDomains()) {
            WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)editingDomain).addOperationHistoryListener(this.affectedObjectsListener);
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        if (this.elementIsReferenced(element) && this.elementIsInstanceReferenced(element)) {
            decoration.addOverlay(referenceOverlay, 0);
            decoration.addOverlay(instanceRefOverlay, 3);
        } else if (this.elementIsReferenced(element)) {
            decoration.addOverlay(referenceOverlay, 0);
        } else if (this.elementIsInstanceReferenced(element)) {
            decoration.addOverlay(instanceRefOverlay, 3);
        } else {
            decoration.addOverlay(null);
        }
    }

    private boolean elementIsReferenced(Object element) {
        if (element instanceof EObject) {
            return ModelSearcher.findReferences((EObject)((EObject)element)).size() > 0;
        }
        return false;
    }

    private boolean elementIsInstanceReferenced(Object element) {
        if (element instanceof EObject) {
            return ModelSearcher.findInstanceReferences((EObject)((EObject)element)).size() > 0;
        }
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void postCreateEditingDomain(TransactionalEditingDomain editingDomain) {
        WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)editingDomain).addOperationHistoryListener(this.affectedObjectsListener);
    }

    public void preDisposeEditingDomain(TransactionalEditingDomain editingDomain) {
        if (this.affectedObjectsListener != null) {
            WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)editingDomain).removeOperationHistoryListener(this.affectedObjectsListener);
        }
    }

    protected IOperationHistoryListener createAffectedObjectsListener() {
        return new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                if (event.getEventType() == 4 || event.getEventType() == 10 || event.getEventType() == 9) {
                    this.handleOperationFinished(event.getOperation());
                }
            }

            private void handleOperationFinished(final IUndoableOperation operation) {
                IWorkbenchPartSite site;
                IWorkbenchPart workbenchPart;
                IWorkbenchPage workbenchPage;
                IWorkbenchWindow workbenchWindow;
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (workbenchPage = workbenchWindow.getActivePage()) != null && (workbenchPart = workbenchPage.getActivePart()) != null && (site = workbenchPart.getSite()) != null) {
                    site.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Command command;
                            if (operation instanceof EMFCommandOperation && (command = ((EMFCommandOperation)operation).getCommand()) != null) {
                                Collection results = command.getResult();
                                for (Object result : results) {
                                    if (!(result instanceof EObject)) continue;
                                    PlatformUI.getWorkbench().getDecoratorManager().update(Messages.Decorator_ID);
                                }
                            }
                        }
                    });
                }
            }
        };
    }
}

