/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.workspace.ui.decorators;

import java.net.URL;
import java.util.MissingResourceException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.eatop.common.metamodel.EastADLReleaseDescriptor;
import org.eclipse.eatop.workspace.natures.EastADLNature;
import org.eclipse.eatop.workspace.preferences.IEastADLWorkspacePreferences;
import org.eclipse.eatop.workspace.ui.internal.Activator;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class EastADLProjectLabelDecorator
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        IItemLabelProvider itemLabelProvider;
        EastADLReleaseDescriptor eastADLRelease;
        if (element instanceof IProject && (eastADLRelease = (EastADLReleaseDescriptor)IEastADLWorkspacePreferences.EAST_ADL_RELEASE.get((IProject)element)) != null && this.hasEastADLNatureOnly((IProject)element) && (itemLabelProvider = (IItemLabelProvider)Platform.getAdapterManager().loadAdapter((Object)eastADLRelease, IItemLabelProvider.class.getName())) != null) {
            try {
                Object imageURL = itemLabelProvider.getImage((Object)eastADLRelease);
                if (imageURL instanceof URL) {
                    ImageDescriptor imageDescriptor = Activator.getPlugin().getImageDescriptor((URL)imageURL);
                    decoration.addOverlay(imageDescriptor, 0);
                }
            }
            catch (MissingResourceException ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
    }

    public boolean hasEastADLNatureOnly(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            return project.hasNature(EastADLNature.ID) && natures.length == 1;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }
}

