/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.workspace.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.eatop.common.metamodel.EastADLReleaseDescriptor;
import org.eclipse.eatop.workspace.jobs.CreateEastADLFileJob;
import org.eclipse.eatop.workspace.preferences.IEastADLWorkspacePreferences;
import org.eclipse.eatop.workspace.ui.internal.Activator;
import org.eclipse.eatop.workspace.ui.internal.messages.Messages;
import org.eclipse.eatop.workspace.ui.messages.ErrorUIMessages;
import org.eclipse.eatop.workspace.ui.messages.WorkspaceUIMessages;
import org.eclipse.eatop.workspace.util.EastADLPlatformUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class BasicEastADLFileWizard
extends BasicNewResourceWizard {
    private static final String WIZBAN_ICON_FILE = "full/wizban/neweafile_wiz.png";
    protected EastADLFileWizardNewFileCreationPage fNewFileCreationPage;
    protected boolean fLoggedNoValidFileExtensionsFoundProblem = false;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(WorkspaceUIMessages.wizard_newEastadlFile_title);
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(Activator.getPlugin().getImageDescriptor(WIZBAN_ICON_FILE));
    }

    protected String getEastADLFileContentTypeId(IProject project) {
        EastADLReleaseDescriptor eastadlRelease = (EastADLReleaseDescriptor)IEastADLWorkspacePreferences.EAST_ADL_RELEASE.get(project);
        return eastadlRelease.getDefaultContentTypeId();
    }

    protected Collection<String> getValidEastADLFileExtensions(IProject project) {
        String contentTypeId = this.getEastADLFileContentTypeId(project);
        ArrayList<String> validFileExtensions = new ArrayList<String>(ExtendedPlatform.getContentTypeFileExtensions((String)contentTypeId));
        if (validFileExtensions.size() == 0) {
            if (!this.fLoggedNoValidFileExtensionsFoundProblem) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)new RuntimeException("No valid file extensions for content type identifer '" + contentTypeId + "' found."));
                this.fLoggedNoValidFileExtensionsFoundProblem = true;
            }
            validFileExtensions.add("eaxml");
        }
        return validFileExtensions;
    }

    public void addPages() {
        Object selectedElement;
        this.fNewFileCreationPage = new EastADLFileWizardNewFileCreationPage("Whatever", this.selection);
        this.fNewFileCreationPage.setTitle(WorkspaceUIMessages.label_eastadlFileWizard);
        this.fNewFileCreationPage.setDescription(WorkspaceUIMessages.description_eastadlFileWizard);
        this.fNewFileCreationPage.setFileName(String.valueOf(WorkspaceUIMessages.defaultFileName) + "." + WorkspaceUIMessages.defaultFileExtension);
        this.addPage((IWizardPage)this.fNewFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.fNewFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultFileBaseName = WorkspaceUIMessages.defaultFileName;
                String defaultFileExtension = WorkspaceUIMessages.defaultFileExtension;
                String fileName = String.valueOf(defaultFileBaseName) + "." + defaultFileExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(fileName) != null) {
                    fileName = String.valueOf(defaultFileBaseName) + i + "." + defaultFileExtension;
                    ++i;
                }
                this.fNewFileCreationPage.setFileName(fileName);
            }
        }
    }

    public boolean performFinish() {
        final IFile eastadlFile = this.fNewFileCreationPage.getEastADLFile();
        String eaPackageName = this.fNewFileCreationPage.getEAPackageName();
        CreateEastADLFileJob job = new CreateEastADLFileJob(Messages.job_creatingEastADLFile_name, eastadlFile, (EastADLReleaseDescriptor)IEastADLWorkspacePreferences.EAST_ADL_RELEASE.get(eastadlFile.getProject()), eaPackageName);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display display;
                if (event.getResult() != null && event.getResult().isOK() && (display = ExtendedPlatformUI.getDisplay()) != null) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            BasicEastADLFileWizard.selectAndReveal((IResource)eastadlFile, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                        }
                    });
                }
            }
        });
        job.schedule();
        return true;
    }

    public class EastADLFileWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        private Button fCreatePackage;
        private Text fPackageName;

        public EastADLFileWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected void createAdvancedControls(Composite parent) {
            super.createAdvancedControls(parent);
            Group fGroup = new Group(parent, 0);
            fGroup.setText(WorkspaceUIMessages.label_EAPackageCreation);
            fGroup.setLayout((Layout)new GridLayout(2, false));
            fGroup.setLayoutData((Object)new GridData(768));
            this.fCreatePackage = new Button((Composite)fGroup, 32);
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            this.fCreatePackage.setLayoutData((Object)gd);
            this.fCreatePackage.setText(WorkspaceUIMessages.label_WithEAPackage);
            this.fCreatePackage.setSelection(true);
            this.fPackageName = new Text((Composite)fGroup, 2052);
            this.fPackageName.setLayoutData((Object)new GridData(768));
            this.fPackageName.setText(WorkspaceUIMessages.text_defaultEaPackageName);
            this.fCreatePackage.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EastADLFileWizardNewFileCreationPage.this.fPackageName.setEnabled(EastADLFileWizardNewFileCreationPage.this.fCreatePackage.getSelection());
                }
            });
        }

        protected boolean validatePage() {
            if (!super.validatePage()) {
                return false;
            }
            IFolder selectedFolder = this.getSelectedFolder();
            if (selectedFolder != null && !EastADLPlatformUtil.hasEastADLNature((IProject)selectedFolder.getProject())) {
                this.setErrorMessage(Messages.error_selectedFolderIsNotInEastADLProject);
                return false;
            }
            IProject selectedProject = this.getSelectedProject();
            if (selectedProject != null && !EastADLPlatformUtil.hasEastADLNature((IProject)selectedProject)) {
                this.setErrorMessage(Messages.error_selectedProjectIsNoEastADLProject);
                return false;
            }
            String fileExtension = new Path(this.getFileName()).getFileExtension();
            Collection<String> validFileExtensions = BasicEastADLFileWizard.this.getValidEastADLFileExtensions(selectedProject);
            if (!validFileExtensions.contains(fileExtension)) {
                this.setErrorMessage(NLS.bind((String)ErrorUIMessages.error_fileNameExtension, (Object)this.convertFileExtensionsToString(validFileExtensions)));
                return false;
            }
            return true;
        }

        private String convertFileExtensionsToString(Collection<String> fileExtensions) {
            Assert.isNotNull(fileExtensions);
            StringBuilder buf = new StringBuilder();
            ListIterator<String> iter = new ArrayList<String>(fileExtensions).listIterator();
            while (iter.hasNext()) {
                if (iter.hasPrevious()) {
                    buf.append(", ");
                }
                buf.append("*.");
                buf.append(iter.next());
            }
            return buf.toString();
        }

        public IProject getSelectedProject() {
            if (this.getContainerFullPath().segmentCount() == 1) {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getContainerFullPath().segment(0));
            }
            IFolder selectedFolder = this.getSelectedFolder();
            if (selectedFolder != null) {
                return selectedFolder.getProject();
            }
            return null;
        }

        public IFolder getSelectedFolder() {
            if (this.getContainerFullPath().segmentCount() > 1) {
                return ResourcesPlugin.getWorkspace().getRoot().getFolder(this.getContainerFullPath());
            }
            return null;
        }

        public IFile getEastADLFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }

        public String getEAPackageName() {
            if (this.fCreatePackage.getSelection() && this.fPackageName.getText().length() != 0) {
                return this.fPackageName.getText();
            }
            return null;
        }
    }
}

