/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.common.mc.frame;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.eclipse.scada.protocol.ngp.common.mc.frame.Frame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameEncoder
implements ProtocolEncoder {
    private static final Logger logger = LoggerFactory.getLogger(FrameEncoder.class);

    public void dispose(IoSession session) throws Exception {
    }

    public void encode(IoSession session, Object message, ProtocolEncoderOutput output) throws Exception {
        if (!(message instanceof Frame)) {
            throw new IllegalStateException(String.format("Can only encode messages of type Frame but got %s", message.getClass()));
        }
        Frame frame = (Frame)message;
        if (logger.isTraceEnabled()) {
            logger.trace("Encode frame - type: {}, data: {}", (Object)frame.getType(), (Object)frame.getData());
        }
        IoBuffer buffer = IoBuffer.allocate((int)(6 + frame.getData().remaining()));
        buffer.put((byte)1);
        buffer.put((byte)frame.getType().ordinal());
        buffer.putInt(frame.getData().remaining());
        buffer.put(frame.getData());
        buffer.flip();
        output.write((Object)buffer);
    }
}

