/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocols.tkpt;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPKTFilter
extends IoFilterAdapter {
    private static final Logger logger = LoggerFactory.getLogger(TPKTFilter.class);
    private static final String SESSION_BUFFER_ATTR = "tpkt.sessionBuffer";
    private final int version;

    public TPKTFilter(int version) {
        this.version = version;
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (!(message instanceof IoBuffer)) {
            nextFilter.messageReceived(session, message);
            return;
        }
        IoBuffer in = (IoBuffer)message;
        IoBuffer sessionBuffer = this.getSessionBuffer(session);
        sessionBuffer.position(sessionBuffer.limit());
        sessionBuffer.put(in);
        sessionBuffer.flip();
        while (sessionBuffer.remaining() >= 4) {
            int len = sessionBuffer.getUnsignedShort(2);
            if (sessionBuffer.remaining() < len) {
                logger.debug("Next packet requires {} bytes", new Object[]{len});
                return;
            }
            IoBuffer data = IoBuffer.allocate((int)(len - 4));
            sessionBuffer.get();
            sessionBuffer.get();
            sessionBuffer.getUnsignedShort();
            sessionBuffer.get(data.array());
            nextFilter.messageReceived(session, (Object)data);
            logger.debug("{} bytes left in session buffer", (Object)sessionBuffer.remaining());
        }
        if (sessionBuffer.hasRemaining()) {
            sessionBuffer.compact();
        } else {
            sessionBuffer.clear().flip();
        }
    }

    private IoBuffer getSessionBuffer(IoSession session) {
        IoBuffer buffer = (IoBuffer)session.getAttribute((Object)SESSION_BUFFER_ATTR);
        if (buffer == null) {
            buffer = IoBuffer.allocate((int)0);
            buffer.setAutoExpand(true);
            session.setAttribute((Object)SESSION_BUFFER_ATTR, (Object)buffer);
        }
        return buffer;
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.clearSessionBuffer(session);
        nextFilter.sessionClosed(session);
    }

    private void clearSessionBuffer(IoSession session) {
        session.removeAttribute((Object)SESSION_BUFFER_ATTR);
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        if (writeRequest.getMessage() instanceof IoBuffer) {
            IoBuffer inData = (IoBuffer)writeRequest.getMessage();
            final IoBuffer outData = IoBuffer.allocate((int)(inData.remaining() + 4));
            outData.put((byte)this.version);
            outData.put((byte)0);
            outData.putShort((short)(inData.remaining() + 4));
            outData.put(inData);
            outData.flip();
            logger.debug("TPKT out: {}", (Object)outData);
            nextFilter.filterWrite(session, (WriteRequest)new WriteRequestWrapper(writeRequest){

                public Object getMessage() {
                    return outData;
                }
            });
        } else {
            nextFilter.filterWrite(session, writeRequest);
        }
    }
}

