/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.relp;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.protocol.relp.data.OpenRequest;
import org.eclipse.scada.protocol.relp.data.ServerCloseMessage;
import org.eclipse.scada.protocol.relp.data.SyslogRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelpHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(RelpHandler.class);
    private boolean opened;
    private final int timeout;
    private ScheduledFuture<?> timeoutTask;

    public RelpHandler() {
        this(Integer.getInteger("org.eclipse.scada.protocol.relp.openTimeout", 20000));
    }

    public RelpHandler(int timeout) {
        this.timeout = timeout;
    }

    public void channelActive(final ChannelHandlerContext ctx) throws Exception {
        if (this.timeout > 0) {
            logger.debug("Adding timeout: {} seconds", (Object)this.timeout);
            this.timeoutTask = ctx.executor().schedule(new Runnable(){

                @Override
                public void run() {
                    RelpHandler.this.processTimeout(ctx);
                }
            }, (long)this.timeout, TimeUnit.MILLISECONDS);
        }
    }

    protected void processTimeout(ChannelHandlerContext ctx) {
        ctx.writeAndFlush((Object)ServerCloseMessage.INSTANCE);
        ctx.close();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof OpenRequest) {
            this.handleOpen(ctx, (OpenRequest)msg);
        } else if (msg instanceof SyslogRequest) {
            this.handleSyslog(ctx, (SyslogRequest)msg);
        }
    }

    protected void handleSyslog(ChannelHandlerContext ctx, SyslogRequest msg) {
        logger.debug("Process syslog command: {}", (Object)msg);
        ctx.fireChannelRead((Object)msg.getData());
        ctx.writeAndFlush((Object)msg.replyOk());
    }

    protected void handleOpen(ChannelHandlerContext ctx, OpenRequest msg) {
        if (this.opened) {
            logger.warn("Duplicate open request. Closing channel.");
            ctx.close();
            return;
        }
        this.opened = true;
        logger.debug("Removing timeout");
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel(false);
        }
        logger.debug("Process open command: {}", (Object)msg);
        String cs = msg.getOffers().get("commands");
        if (cs == null) {
            ctx.write((Object)ServerCloseMessage.INSTANCE);
            throw new IllegalStateException("Offer 'commands' not found in open command");
        }
        HashSet<String> commands = new HashSet<String>(Arrays.asList(cs.split(",")));
        logger.debug("Supported commands: {}", commands);
        if (!commands.contains("syslog")) {
            ctx.write((Object)ServerCloseMessage.INSTANCE);
            throw new IllegalStateException("Command 'syslog' not supported");
        }
        HashMap<String, String> result = new HashMap<String, String>(1);
        result.put("commands", "syslog");
        result.put("relp_version", "0");
        ctx.writeAndFlush((Object)msg.replyOk(result));
        ctx.fireChannelActive();
    }
}

