/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.relp.data;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class Frame {
    private final long transactionId;
    private final String command;
    private final ByteBuf data;

    public Frame(long transactionId, String command, ByteBuf data) {
        this.transactionId = transactionId;
        this.command = command;
        this.data = data;
    }

    public Frame(long transactionId, String command, String data) {
        this.transactionId = transactionId;
        this.command = command;
        this.data = data == null ? null : Unpooled.copiedBuffer((CharSequence)data, (Charset)StandardCharsets.UTF_8);
    }

    public String getCommand() {
        return this.command;
    }

    public ByteBuf getData() {
        return this.data;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public String toString() {
        return String.format("[Frame - txnr: %s, command: %s, data: %s]", this.transactionId, this.command, this.data);
    }
}

