/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.syslog.time;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CodecException;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scada.protocol.syslog.time.TimestampParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternTimestampParser
implements TimestampParser {
    private static final Logger logger = LoggerFactory.getLogger(PatternTimestampParser.class);
    private final Pattern pattern;
    private final byte endMarker;
    private final Charset charset;

    public PatternTimestampParser(Pattern pattern, byte endMarker, Charset charset) {
        this.pattern = pattern;
        this.endMarker = endMarker;
        this.charset = charset;
    }

    @Override
    public Calendar parseTimestamp(ByteBuf data) {
        int index = data.bytesBefore(this.endMarker);
        if (index < 0) {
            throw new CodecException("Unable to find timestamp");
        }
        String timestampString = data.readSlice(index).toString(this.charset);
        logger.debug("Timestamp string: '{}'", (Object)timestampString);
        Matcher m = this.pattern.matcher(timestampString);
        if (!m.matches()) {
            throw new CodecException("Timestamp string does not match pattern: " + this.pattern.pattern());
        }
        int year = Integer.parseInt(m.group("year"));
        int month = Integer.parseInt(m.group("month")) - 1;
        int day = Integer.parseInt(m.group("day"));
        int hour = Integer.parseInt(m.group("hour"));
        int minute = Integer.parseInt(m.group("minute"));
        int second = Integer.parseInt(m.group("second"));
        int ms = Integer.parseInt(m.group("subsec")) / 1000;
        TimeZone timezone = TimeZone.getDefault();
        String tz = m.group("tz");
        if (!tz.isEmpty()) {
            timezone = "Z".equals(tz) ? TimeZone.getTimeZone("UTC") : TimeZone.getTimeZone("GMT" + tz);
        }
        GregorianCalendar c = new GregorianCalendar(year, month, day, hour, minute, second);
        ((Calendar)c).setTimeZone(timezone);
        c.set(14, ms);
        data.skipBytes(1);
        return c;
    }
}

