/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.common;

import java.util.LinkedList;
import java.util.List;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.ssl.SslContextFactory;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.Handshake;
import org.eclipse.scada.protocol.ngp.common.mc.protocol.ProtocolDescriptor;
import org.eclipse.scada.protocol.ngp.common.mc.protocol.serialize.ObjectSerializationProtocolDescriptor;

public class ProtocolConfiguration {
    private static final ProtocolConfiguration DEFAULT_CONFIGURATION = new ProtocolConfiguration(null);
    private int streamCompressionLevel = 0;
    private int handshakeTimeout = Integer.getInteger("org.eclipse.scada.protocol.ngp.common.handshakeTimeout", 10000);
    private int pingFrequency = 3;
    private int timeout = 10000;
    private SslContextFactory sslContextFactory;
    private boolean sslRequired = false;
    private List<String> preferredProtocols = new LinkedList<String>();
    private List<ProtocolDescriptor> protocols = new LinkedList<ProtocolDescriptor>();
    private List<Handshake> handshakeHandlers = new LinkedList<Handshake>();

    public ProtocolConfiguration(ClassLoader classLoader) {
        this.protocols.add(new ObjectSerializationProtocolDescriptor(null, classLoader));
    }

    public ProtocolConfiguration() {
    }

    public List<Handshake> getHandshakeHandlers() {
        return this.handshakeHandlers;
    }

    public void setHandshakeHandlers(List<Handshake> handshakeHandlers) {
        this.handshakeHandlers = handshakeHandlers;
    }

    public void addHandshakeHandler(Handshake handshake) {
        this.handshakeHandlers.add(handshake);
    }

    public void setPreferredProtocols(List<String> preferredProtocols) {
        this.preferredProtocols = preferredProtocols;
    }

    public List<String> getPreferredProtocols() {
        return this.preferredProtocols;
    }

    public void setSslContextFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    public void setSslRequired(boolean sslRequired) {
        this.sslRequired = sslRequired;
    }

    public boolean isSslRequired() {
        return this.sslRequired;
    }

    public void setPingFrequency(int pingFrequency) {
        this.pingFrequency = pingFrequency;
    }

    public int getPingFrequency() {
        return this.pingFrequency;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setStreamCompressionLevel(int streamCompressionLevel) {
        this.streamCompressionLevel = streamCompressionLevel;
    }

    public int getStreamCompressionLevel() {
        return this.streamCompressionLevel;
    }

    public void setHandshakeTimeout(int handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
    }

    public int getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public static ProtocolConfiguration fromSession(IoSession session) {
        Object result = session.getAttribute((Object)"protocol.configuration");
        if (result != null) {
            return (ProtocolConfiguration)result;
        }
        return DEFAULT_CONFIGURATION;
    }

    public void assign(IoSession session) {
        session.setAttribute((Object)"protocol.configuration", (Object)this);
    }

    public List<ProtocolDescriptor> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<ProtocolDescriptor> protocols) {
        this.protocols = protocols;
    }
}

