/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.common.mc.handshake;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.Handshake;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.HandshakeContext;
import org.eclipse.scada.protocol.ngp.common.mc.protocol.ProtocolDescriptor;
import org.eclipse.scada.utils.str.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageProtocolHandshake
implements Handshake {
    private static final String PROP_CLIENT_PROTOCOL_PREFS = "preferredClientProtocols";
    private static final Logger logger = LoggerFactory.getLogger(MessageProtocolHandshake.class);

    @Override
    public void request(HandshakeContext context, Map<String, String> helloProperties) {
        List<ProtocolDescriptor> protocols = context.getProtocolConfiguration().getProtocols();
        for (ProtocolDescriptor protocol : protocols) {
            logger.debug("Offering protocol : {}", (Object)protocol.getProtocolId());
            helloProperties.put("protocol." + protocol.getProtocolId(), "true");
        }
        if (context.getProtocolConfiguration().getPreferredProtocols() != null) {
            helloProperties.put(PROP_CLIENT_PROTOCOL_PREFS, StringHelper.join(context.getProtocolConfiguration().getPreferredProtocols(), (String)", "));
        }
    }

    @Override
    public void handshake(HandshakeContext context, Map<String, String> helloProperties, Map<String, String> acceptedProperties) throws Exception {
        List<ProtocolDescriptor> protocols = context.getProtocolConfiguration().getProtocols();
        List<String> preferredProtocols = context.getProtocolConfiguration().getPreferredProtocols();
        LinkedList<String> possibleProtocols = new LinkedList<String>();
        for (ProtocolDescriptor protocol : protocols) {
            if (!helloProperties.containsKey("protocol." + protocol.getProtocolId())) continue;
            logger.debug("Adding '{}' as possible protocol", (Object)protocol.getProtocolId());
            possibleProtocols.add(protocol.getProtocolId());
        }
        if (possibleProtocols.isEmpty()) {
            throw new IllegalStateException("Unable to negotiate protocol. None found!");
        }
        String chosenProtocol = null;
        for (String protocol : preferredProtocols) {
            if (!possibleProtocols.contains(protocol)) continue;
            chosenProtocol = protocol;
            break;
        }
        logger.debug("After preference selection: {}", chosenProtocol);
        if (chosenProtocol == null) {
            String preferredClientProtocols = helloProperties.get(PROP_CLIENT_PROTOCOL_PREFS);
            logger.debug("Client preferences: {}", (Object)preferredClientProtocols);
            if (preferredClientProtocols != null) {
                String[] toks;
                String[] stringArray = toks = preferredClientProtocols.split(", *");
                int n = toks.length;
                int n2 = 0;
                while (n2 < n) {
                    String tok = stringArray[n2];
                    if (possibleProtocols.contains(tok)) {
                        chosenProtocol = tok;
                        break;
                    }
                    ++n2;
                }
            }
            logger.debug("After client selection: {}", (Object)chosenProtocol);
        }
        if (chosenProtocol == null) {
            chosenProtocol = (String)possibleProtocols.iterator().next();
            logger.debug("After any selection: {}", (Object)chosenProtocol);
        }
        logger.info("Using protocol: {}", (Object)chosenProtocol);
        acceptedProperties.put("protocol", chosenProtocol);
    }

    @Override
    public void apply(HandshakeContext context, Map<String, String> acceptedProperties) throws Exception {
        String protocolId = acceptedProperties.get("protocol");
        logger.debug("Activating protocol: {}", (Object)protocolId);
        if (protocolId == null) {
            throw new IllegalStateException("Selected protocol cannot be null");
        }
        List<ProtocolDescriptor> protocols = context.getProtocolConfiguration().getProtocols();
        for (ProtocolDescriptor protocol : protocols) {
            if (!protocolId.equals(protocol.getProtocolId())) continue;
            protocol.activate(context.getSession());
        }
    }

    @Override
    public void postApply(HandshakeContext context, Map<String, String> acceptedProperties) throws Exception {
    }

    @Override
    public void sessionStarted(HandshakeContext context, Map<String, String> acceptedProperties) throws Exception {
    }
}

