/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.syslog;

import java.util.Calendar;
import org.eclipse.scada.protocol.syslog.Facility;
import org.eclipse.scada.protocol.syslog.Severity;

public class SyslogMessage {
    private final Facility facility;
    private final Severity severity;
    private final Calendar timestamp;
    private final String hostname;
    private final String processName;
    private final Long processId;
    private final String message;

    public SyslogMessage(Facility facility, Severity severity, Calendar timestamp, String hostname, String processName, Long processId, String message) {
        this.facility = facility;
        this.severity = severity;
        this.timestamp = timestamp;
        this.hostname = hostname;
        this.processName = processName;
        this.processId = processId;
        this.message = message;
    }

    public Facility getFacility() {
        return this.facility;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Calendar getTimestamp() {
        return this.timestamp;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getProcessName() {
        return this.processName;
    }

    public Long getProcessId() {
        return this.processId;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        String proc = this.processId != null ? String.valueOf(this.processName) + "[" + this.processId + "]" : this.processName;
        return String.format("%tc %s %s.%s %s: %s", new Object[]{this.timestamp, this.hostname, this.facility, this.severity, proc, this.message});
    }
}

