/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.apci;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.ReferenceCountUtil;
import java.nio.ByteOrder;
import org.eclipse.neoscada.protocol.iec60870.apci.APCIBase;
import org.eclipse.neoscada.protocol.iec60870.apci.InformationTransfer;
import org.eclipse.neoscada.protocol.iec60870.apci.Supervisory;
import org.eclipse.neoscada.protocol.iec60870.apci.UnnumberedControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APDUEncoder
extends MessageToByteEncoder<APCIBase> {
    private static final Logger logger = LoggerFactory.getLogger(APDUEncoder.class);

    public APDUEncoder() {
        super(APCIBase.class);
    }

    protected void encode(ChannelHandlerContext ctx, APCIBase msg, ByteBuf out) throws Exception {
        logger.trace("encode - ctx: {}, msg: {}", (Object)ctx, (Object)msg);
        if (msg instanceof UnnumberedControl) {
            this.handleUFormat((UnnumberedControl)msg, out);
        } else if (msg instanceof Supervisory) {
            this.handleSFormat((Supervisory)msg, out);
        } else if (msg instanceof InformationTransfer) {
            this.handleIFormat((InformationTransfer)msg, out);
        }
    }

    private void handleIFormat(InformationTransfer msg, ByteBuf out) {
        ByteBuf data = msg.getData();
        try {
            out = out.order(ByteOrder.LITTLE_ENDIAN);
            int len = data.readableBytes();
            if (len > 253) {
                throw new EncoderException(String.format("Packet too big - %s bytes", len));
            }
            out.ensureWritable(6 + len);
            out.writeByte(104);
            out.writeByte(4 + len);
            out.writeShort(msg.getSendSequenceNumber() << 1);
            out.writeShort(msg.getReceiveSequenceNumber() << 1);
            out.writeBytes(data);
        }
        finally {
            ReferenceCountUtil.release((Object)msg.getData());
        }
    }

    private void handleSFormat(Supervisory msg, ByteBuf out) {
        out = out.order(ByteOrder.LITTLE_ENDIAN);
        out.ensureWritable(6);
        out.writeByte(104);
        out.writeByte(4);
        byte[] byArray = new byte[2];
        byArray[0] = 1;
        out.writeBytes(byArray);
        out.writeShort(msg.getReceiveSequenceNumber() << 1);
    }

    private void handleUFormat(UnnumberedControl msg, ByteBuf out) {
        out.ensureWritable(6);
        out.writeByte(104);
        out.writeByte(4);
        out.writeByte(msg.getFunction().getNumericValue() | 3);
        out.writeZero(3);
    }
}

