/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.EncodeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.DoublePoint;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.TypeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

@ASDU(id=3, name="M_DP_NA_1", informationStructure=InformationStructure.SEQUENCE)
public class DoublePointInformationSequence
extends AbstractMessage {
    private final InformationObjectAddress startAddress;
    private final List<Value<DoublePoint>> values;

    private DoublePointInformationSequence(ASDUHeader header, InformationObjectAddress startAddress, List<Value<DoublePoint>> values) {
        super(header);
        this.startAddress = startAddress;
        this.values = values;
    }

    public InformationObjectAddress getStartAddress() {
        return this.startAddress;
    }

    public List<Value<DoublePoint>> getValues() {
        return this.values;
    }

    public static DoublePointInformationSequence parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        InformationObjectAddress startAddress = InformationObjectAddress.parse(options, data);
        ArrayList<Value<DoublePoint>> values = new ArrayList<Value<DoublePoint>>(length);
        int i = 0;
        while (i < length) {
            values.add(TypeHelper.parseDoublePointValue(options, data, false));
            ++i;
        }
        return new DoublePointInformationSequence(header, startAddress, values);
    }

    @Override
    public void encode(ProtocolOptions options, ByteBuf out) {
        EncodeHelper.encodeHeader(this, options, this.values.size(), this.header, out);
        this.startAddress.encode(options, out);
        for (Value<DoublePoint> value : this.values) {
            TypeHelper.encodeDoublePointValue(options, out, value, false);
        }
    }

    public static DoublePointInformationSequence create(InformationObjectAddress startAddress, ASDUHeader header, Value<DoublePoint> value) {
        return DoublePointInformationSequence.createInternal(startAddress, header, Collections.singletonList(value));
    }

    public static DoublePointInformationSequence create(InformationObjectAddress startAddress, ASDUHeader header, List<Value<DoublePoint>> values) {
        if (values.size() > 127) {
            throw new IllegalArgumentException(String.format("A maximum of %s values can be transmitted", 127));
        }
        return DoublePointInformationSequence.createInternal(startAddress, header, new ArrayList<Value<DoublePoint>>(values));
    }

    private static DoublePointInformationSequence createInternal(InformationObjectAddress startAddress, ASDUHeader header, List<Value<DoublePoint>> values) {
        return new DoublePointInformationSequence(header, startAddress, values);
    }
}

