/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.EncodeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.TypeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

@ASDU(id=11, name="M_ME_NB_1", informationStructure=InformationStructure.SEQUENCE)
public class MeasuredValueScaledSequence
extends AbstractMessage {
    private final InformationObjectAddress startAddress;
    private final List<Value<Short>> values;

    private MeasuredValueScaledSequence(ASDUHeader header, InformationObjectAddress startAddress, List<Value<Short>> values) {
        super(header);
        this.startAddress = startAddress;
        this.values = values;
    }

    public List<Value<Short>> getValues() {
        return this.values;
    }

    public InformationObjectAddress getStartAddress() {
        return this.startAddress;
    }

    public static MeasuredValueScaledSequence parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        InformationObjectAddress startAddress = InformationObjectAddress.parse(options, data);
        ArrayList<Value<Short>> values = new ArrayList<Value<Short>>(length);
        int i = 0;
        while (i < length) {
            values.add(TypeHelper.parseScaledValue(options, data, false));
            ++i;
        }
        return new MeasuredValueScaledSequence(header, startAddress, values);
    }

    @Override
    public void encode(ProtocolOptions options, ByteBuf out) {
        EncodeHelper.encodeHeader(this, options, this.values.size(), this.header, out);
        this.startAddress.encode(options, out);
        for (Value<Short> value : this.values) {
            TypeHelper.encodeScaledValue(options, out, value, false);
        }
    }

    public static MeasuredValueScaledSequence create(InformationObjectAddress startAddress, ASDUHeader header, Value<Short> value) {
        return MeasuredValueScaledSequence.createInternal(startAddress, header, Collections.singletonList(value));
    }

    public static MeasuredValueScaledSequence create(InformationObjectAddress startAddress, ASDUHeader header, List<Value<Short>> values) {
        if (values.size() > 127) {
            throw new IllegalArgumentException(String.format("A maximum of %s values can be transmitted", 127));
        }
        return MeasuredValueScaledSequence.createInternal(startAddress, header, new ArrayList<Value<Short>>(values));
    }

    private static MeasuredValueScaledSequence createInternal(InformationObjectAddress startAddress, ASDUHeader header, List<Value<Short>> values) {
        return new MeasuredValueScaledSequence(header, startAddress, values);
    }
}

