/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.types;

import java.util.Date;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.QualityInformation;

public class Value<T> {
    private final T value;
    private final QualityInformation qualityInformation;
    private boolean overflow;
    private long timestamp;

    public Value(T value, long timestamp, QualityInformation qualityInformation) {
        this(value, timestamp, qualityInformation, false);
    }

    public Value(T value, long timestamp, QualityInformation qualityInformation, boolean overflow) {
        this.value = value;
        this.timestamp = timestamp;
        this.qualityInformation = qualityInformation;
        this.overflow = overflow;
    }

    public boolean isOverflow() {
        return this.overflow;
    }

    public QualityInformation getQualityInformation() {
        return this.qualityInformation;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public T getValue() {
        return this.value;
    }

    public static <T> Value<T> ok(T value) {
        return new Value<T>(value, System.currentTimeMillis(), QualityInformation.OK);
    }

    public static Value<Boolean> TRUE() {
        return Value.ok(Boolean.TRUE);
    }

    public static Value<Boolean> FALSE() {
        return Value.ok(Boolean.FALSE);
    }

    public String toString() {
        return String.format("[%s: %s - %s - %4$tF %4$tH:%4$tM:%4$tS.%4$tL %4$tZ %4$tz", this.value.getClass().getSimpleName(), this.value, this.qualityInformation, new Date(this.timestamp));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.overflow ? 1231 : 1237);
        result = 31 * result + (this.qualityInformation == null ? 0 : this.qualityInformation.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Value other = (Value)obj;
        if (this.overflow != other.overflow) {
            return false;
        }
        if (this.qualityInformation == null ? other.qualityInformation != null : !this.qualityInformation.equals(other.qualityInformation)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

