/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.modbus.codec;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.eclipse.scada.protocol.modbus.io.ModbusProtocolError;
import org.eclipse.scada.protocol.modbus.message.Pdu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusTcpDecoder
extends CumulativeProtocolDecoder {
    private static final Logger logger = LoggerFactory.getLogger(ModbusTcpDecoder.class);

    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        while (in.remaining() >= 7) {
            int protocolIdentifier;
            int bodySize = in.getUnsignedShort(in.position() + 2 + 2);
            int reqBytes = 7 + bodySize - 1;
            int remaining = in.remaining();
            logger.trace("Remaining bytes: {}, required: {} (Body: {})", new Object[]{remaining, reqBytes, bodySize});
            if (remaining < reqBytes) {
                return false;
            }
            logger.trace("doDecode () frame = {}", (Object)in.getHexDump());
            int transactionIdentifier = in.getUnsignedShort();
            if (logger.isTraceEnabled()) {
                logger.trace("transaction identifier: {} ({})", (Object)transactionIdentifier, (Object)String.format("%04x", transactionIdentifier));
            }
            if ((protocolIdentifier = in.getUnsignedShort()) != 0) {
                throw new ModbusProtocolError(String.format("protocol identifier must be 0, but was: %d", protocolIdentifier));
            }
            in.getUnsignedShort();
            byte unitIdentifier = in.get();
            IoBuffer pdu = IoBuffer.allocate((int)(in.limit() - 7));
            int i = 0;
            while (i < in.limit() - 7) {
                pdu.put(in.get());
                ++i;
            }
            pdu.flip();
            out.write((Object)new Pdu(transactionIdentifier, unitIdentifier, pdu));
        }
        return false;
    }
}

