/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataListener;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataModel;
import org.eclipse.neoscada.protocol.iec60870.server.data.DefaultSubscription;
import org.eclipse.neoscada.protocol.iec60870.server.data.Stopping;
import org.eclipse.neoscada.protocol.iec60870.server.data.Subscription;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;

public abstract class AbstractBaseDataModel
implements DataModel {
    private final Set<DefaultSubscription> subscriptions = new HashSet<DefaultSubscription>();
    private final String threadName;
    private volatile int numberOfSubscriptions;
    protected ListeningScheduledExecutorService executor;

    public AbstractBaseDataModel(String threadName) {
        this.threadName = threadName;
    }

    @Override
    public synchronized Subscription subscribe(DataListener listener) {
        DefaultSubscription subscription = new DefaultSubscription(this, listener);
        this.subscriptions.add(subscription);
        this.numberOfSubscriptions = this.subscriptions.size();
        return subscription;
    }

    protected int getNumberOfSubscriptions() {
        return this.numberOfSubscriptions;
    }

    protected synchronized ListenableFuture<Void> disposeSubscription(DefaultSubscription subscription) {
        this.subscriptions.remove(subscription);
        this.numberOfSubscriptions = this.subscriptions.size();
        if (this.executor.isShutdown()) {
            return Futures.immediateFuture(null);
        }
        return this.executor.submit(() -> null);
    }

    protected synchronized void notifyChangeBoolean(ASDUAddress asduAddress, InformationObjectAddress startAddress, List<Value<Boolean>> values) {
        for (DefaultSubscription sub : this.subscriptions) {
            this.executor.execute(() -> sub.notifyChangeBoolean(asduAddress, startAddress, values));
        }
    }

    protected synchronized void notifyChangeBoolean(ASDUAddress asduAddress, List<InformationEntry<Boolean>> values) {
        for (DefaultSubscription sub : this.subscriptions) {
            this.executor.execute(() -> sub.notifyChangeBoolean(asduAddress, values));
        }
    }

    protected synchronized void notifyChangeFloat(ASDUAddress asduAddress, InformationObjectAddress startAddress, List<Value<Float>> values) {
        for (DefaultSubscription sub : this.subscriptions) {
            this.executor.execute(() -> sub.notifyChangeFloat(asduAddress, startAddress, values));
        }
    }

    protected synchronized void notifyChangeFloat(ASDUAddress asduAddress, List<InformationEntry<Float>> values) {
        for (DefaultSubscription sub : this.subscriptions) {
            this.executor.execute(() -> sub.notifyChangeFloat(asduAddress, values));
        }
    }

    protected synchronized void notifyChangeShort(ASDUAddress asduAddress, InformationObjectAddress startAddress, List<Value<Short>> values) {
        for (DefaultSubscription sub : this.subscriptions) {
            this.executor.execute(() -> sub.notifyChangeShort(asduAddress, startAddress, values));
        }
    }

    protected synchronized void notifyChangeShort(ASDUAddress asduAddress, List<InformationEntry<Short>> values) {
        for (DefaultSubscription sub : this.subscriptions) {
            this.executor.execute(() -> sub.notifyChangeShort(asduAddress, values));
        }
    }

    @Override
    public synchronized void start() {
        if (this.executor != null) {
            return;
        }
        this.executor = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory(this.threadName, false, true)));
    }

    @Override
    public synchronized Stopping stop() {
        ListeningScheduledExecutorService executor = this.executor;
        if (executor == null) {
            return Stopping.EMPTY;
        }
        this.executor = null;
        this.subscriptions.clear();
        this.numberOfSubscriptions = 0;
        executor.shutdown();
        return new Stopping((ExecutorService)executor){
            private final /* synthetic */ ExecutorService val$executor;
            {
                this.val$executor = executorService;
            }

            @Override
            public void await() throws InterruptedException {
                this.val$executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
        };
    }
}

