/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data;

import io.netty.channel.ChannelHandler;
import io.netty.channel.socket.SocketChannel;
import org.eclipse.neoscada.protocol.iec60870.apci.MessageChannel;
import org.eclipse.neoscada.protocol.iec60870.asdu.MessageManager;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MessageRegistrator;
import org.eclipse.neoscada.protocol.iec60870.server.Server;
import org.eclipse.neoscada.protocol.iec60870.server.ServerModule;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataModel;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataModuleHandler;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataModuleOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataModule
implements ServerModule {
    private static final Logger logger = LoggerFactory.getLogger(DataModule.class);
    private final DataModel dataModel;
    private final DataModuleOptions options;

    public DataModule(DataModuleOptions options, DataModel dataModel) {
        this.options = options;
        this.dataModel = dataModel;
    }

    public void initializeServer(Server server, MessageManager manager) {
        new MessageRegistrator().register(manager);
    }

    public void dispose() {
        this.dataModel.stop();
    }

    public void initializeChannel(SocketChannel channel, MessageChannel messageChannel) {
        logger.debug("Init channel: {}", (Object)channel);
        this.dataModel.start();
        channel.pipeline().addLast(new ChannelHandler[]{new DataModuleHandler(this.options, messageChannel, this.dataModel)});
    }
}

