/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data.event;

import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CauseOfTransmission;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.EventBuffer;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.MessageBuilderFactory;

public class EventQueue<T> {
    private final EventBuffer<T> buffer;
    private final MessageBuilderFactory<T> factory;

    public EventQueue(int numberOfDuplicates, MessageBuilderFactory<T> factory) {
        this.buffer = new EventBuffer(numberOfDuplicates);
        this.factory = factory;
    }

    public void append(CauseOfTransmission causeOfTransmission, ASDUAddress asduAddress, InformationObjectAddress address, Value<T> value) {
        this.buffer.append(causeOfTransmission, asduAddress, address, value);
    }

    public void append(CauseOfTransmission causeOfTransmission, ASDUAddress asduAddress, InformationObjectAddress startAddress, List<Value<T>> values) {
        this.buffer.append(causeOfTransmission, asduAddress, startAddress, values);
    }

    public void append(CauseOfTransmission causeOfTransmission, ASDUAddress asduAddress, List<InformationEntry<T>> values) {
        this.buffer.append(causeOfTransmission, asduAddress, values);
    }

    public int getCauseCounter(CauseOfTransmission causeOfTransmission, ASDUAddress asduAddress) {
        return this.buffer.getCauseCounter(causeOfTransmission, asduAddress);
    }

    public Object poll() {
        return this.buffer.poll(this.factory.create());
    }
}

