/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data.model;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CauseOfTransmission;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.server.data.BackgroundIterator;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.MessageBuilder;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.SimpleBooleanBuilder;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.SimpleFloatBuilder;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.SimpleScaledBuilder;
import org.eclipse.neoscada.protocol.iec60870.server.data.model.BackgroundModel;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundModelImpl
implements BackgroundModel {
    private static final Logger logger = LoggerFactory.getLogger(BackgroundModelImpl.class);
    private static final SimpleFloatBuilder FLOAT_BUILDER = new SimpleFloatBuilder(false);
    private static final SimpleScaledBuilder SCALED_BUILDER = new SimpleScaledBuilder(false);
    private static final SimpleBooleanBuilder BOOLEAN_BUILDER = new SimpleBooleanBuilder(false);
    private final ExecutorService backgroundExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("org.eclipse.neoscada.da.server.exporter.iec60870.DataModel/background"));
    private final Map<Integer, SortedMap<Integer, Value<?>>> cache;
    private final Object modelLock;

    public BackgroundModelImpl(SortedMap<Integer, SortedMap<Integer, Value<?>>> cache, Object modelLock) {
        this.cache = cache;
        this.modelLock = modelLock;
    }

    @Override
    public Optional<BackgroundIterator> createBackgroundIterator() {
        return Optional.of(new BackgroundIteratorImpl());
    }

    private Object proceedBackgroundScan(BackgroundState state) {
        try {
            logger.debug("Background scan - {}", (Object)state);
            Object msg = this.backgroundExecutor.submit(() -> this.internalBackgroundScan(state)).get();
            logger.debug("Background scan result - {}", msg);
            return msg;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Failed to perform background scan", e);
        }
    }

    private static MessageBuilder<?, ?> createBuilder(Object value) {
        if (value instanceof Boolean) {
            return BOOLEAN_BUILDER.create();
        }
        if (value instanceof Short) {
            return SCALED_BUILDER.create();
        }
        if (value instanceof Number) {
            return FLOAT_BUILDER.create();
        }
        throw new IllegalStateException(String.format("Value type %s is unsupported", value.getClass()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object internalBackgroundScan(BackgroundState state) {
        Object object = this.modelLock;
        synchronized (object) {
            try {
                return this.internalNext(state);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                state.asduAddressIterator = null;
                state.addressIterator = null;
                return this.internalNext(state);
            }
        }
    }

    private Object internalNext(BackgroundState state) {
        Map.Entry<Integer, Value<?>> entry;
        if (state.asduAddressIterator == null) {
            state.asduAddressIterator = this.cache.entrySet().iterator();
        }
        if (state.asduAddress == null) {
            if (!state.asduAddressIterator.hasNext()) {
                return null;
            }
            state.asduAddress = state.asduAddressIterator.next();
        }
        if (state.addressIterator == null) {
            state.addressMap = state.asduAddress.getValue();
            state.addressIterator = state.addressMap.entrySet().iterator();
        }
        MessageBuilder<?, ?> builder = null;
        do {
            if (!state.addressIterator.hasNext()) {
                state.addressIterator = null;
                state.asduAddress = null;
                if (builder != null) {
                    return builder.build();
                }
                return null;
            }
            entry = state.addressIterator.next();
            if (builder == null) {
                builder = BackgroundModelImpl.createBuilder(entry.getValue().getValue());
                builder.start(CauseOfTransmission.BACKGROUND, ASDUAddress.valueOf((int)state.asduAddress.getKey()));
            }
            if (builder.accepts(entry.getValue())) continue;
            state.addressMap = state.asduAddress.getValue().tailMap(entry.getKey());
            state.addressIterator = state.addressMap.entrySet().iterator();
            return builder.build();
        } while (builder.addEntry(InformationObjectAddress.valueOf((int)entry.getKey()), entry.getValue()));
        return builder.build();
    }

    @Override
    public Runnable dispose() {
        this.backgroundExecutor.shutdown();
        return () -> {
            try {
                this.backgroundExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private final class BackgroundIteratorImpl
    implements BackgroundIterator {
        private final BackgroundState state = new BackgroundState();

        private BackgroundIteratorImpl() {
        }

        @Override
        public Object nextMessage() {
            return BackgroundModelImpl.this.proceedBackgroundScan(this.state);
        }
    }

    private static final class BackgroundState {
        public Map.Entry<Integer, SortedMap<Integer, Value<?>>> asduAddress;
        public Iterator<Map.Entry<Integer, SortedMap<Integer, Value<?>>>> asduAddressIterator;
        public Iterator<Map.Entry<Integer, Value<?>>> addressIterator;
        public SortedMap<Integer, Value<?>> addressMap;

        private BackgroundState() {
        }

        public String toString() {
            return String.format("[asduAddress: %s, asduAddressIterator: %s, addressMap: %s, addressIterator: %s]", this.asduAddress, this.asduAddressIterator, this.addressMap, this.addressIterator);
        }
    }
}

