/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.generator.ui.popupMenus;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scada.protocol.ngp.generator.ui.Activator;
import org.eclipse.scada.protocol.ngp.generator.ui.common.GenerateAll;
import org.eclipse.scada.protocol.ngp.model.Protocol.Protocol;
import org.eclipse.scada.protocol.ngp.model.Protocol.ProtocolPackage;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public class AcceleoGenerateGeneratorAction
extends ActionDelegate
implements IActionDelegate,
IExecutableExtension {
    protected List<IFile> files;
    private String main = "org.eclipse.scada.protocol.ngp.generator.main.Generate";
    private String projectFormat;

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.files = ((IStructuredSelection)selection).toList();
        }
    }

    public void run(IAction action) {
        if (this.files != null) {
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        for (IFile model : AcceleoGenerateGeneratorAction.this.files) {
                            URI modelURI = URI.createPlatformResourceURI((String)model.getFullPath().toString(), (boolean)true);
                            Protocol protocol = AcceleoGenerateGeneratorAction.this.loadProtocol(modelURI);
                            try {
                                try {
                                    IContainer target = AcceleoGenerateGeneratorAction.this.findTarget(protocol, model.getProject());
                                    LinkedList arguments = new LinkedList();
                                    GenerateAll generator = new GenerateAll(modelURI, target, arguments, AcceleoGenerateGeneratorAction.this.main);
                                    generator.doGenerate(monitor);
                                }
                                catch (Exception e) {
                                    Status status = new Status(4, "org.eclipse.scada.protocol.ngp.generator.ui", e.getMessage(), (Throwable)e);
                                    Activator.getDefault().getLog().log((IStatus)status);
                                    AcceleoGenerateGeneratorAction.this.findProject(protocol, model.getProject()).refreshLocal(2, monitor);
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                AcceleoGenerateGeneratorAction.this.findProject(protocol, model.getProject()).refreshLocal(2, monitor);
                                throw throwable;
                            }
                            AcceleoGenerateGeneratorAction.this.findProject(protocol, model.getProject()).refreshLocal(2, monitor);
                        }
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, "org.eclipse.scada.protocol.ngp.generator.ui", e.getMessage(), (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)status);
                    }
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, operation);
            }
            catch (InvocationTargetException e) {
                Status status = new Status(4, "org.eclipse.scada.protocol.ngp.generator.ui", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
            catch (InterruptedException e) {
                Status status = new Status(4, "org.eclipse.scada.protocol.ngp.generator.ui", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    protected Protocol loadProtocol(URI modelURI) {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("protocol", new XMIResourceFactoryImpl());
        Resource resource = rs.getResource(modelURI, true);
        return (Protocol)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)ProtocolPackage.Literals.PROTOCOL);
    }

    protected IProject findProject(Protocol protocol, IProject modelProject) {
        if (this.projectFormat == null) {
            return modelProject;
        }
        IWorkspaceRoot root = modelProject.getWorkspace().getRoot();
        String projectName = String.format(this.projectFormat, protocol.getPackagePrefix(), protocol.getName());
        return root.getProject(projectName);
    }

    protected IContainer findTarget(Protocol protocol, IProject modelProject) {
        IProject project = this.findProject(protocol, modelProject);
        if (!project.exists()) {
            throw new RuntimeException(String.format("Project '%s' does not exists", project.getName()));
        }
        return project.getFolder("src");
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.main = (String)data;
        } else if (data instanceof Hashtable) {
            Object o = ((Hashtable)data).get("generatorName");
            if (o instanceof String) {
                this.main = (String)o;
            }
            if ((o = ((Hashtable)data).get("projectFormat")) instanceof String) {
                this.projectFormat = (String)o;
            }
        }
    }
}

