/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.relp.service;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.SocketChannel;
import java.net.InetSocketAddress;
import org.eclipse.scada.protocol.relp.service.ReceiverHandler;
import org.eclipse.scada.protocol.syslog.SyslogMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiverSession {
    private static final Logger logger = LoggerFactory.getLogger(ReceiverSession.class);
    private final SocketChannel channel;
    private final ChannelHandler channelHandler = new ChannelDuplexHandler(){

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof SyslogMessage) {
                ReceiverSession.this.handleMessage((SyslogMessage)msg);
            }
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ReceiverSession.this.handleOpened();
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            ReceiverSession.this.handleClosed();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.warn("Failed to process - " + ctx, cause);
            ctx.close();
        }
    };
    private final ReceiverHandler handler;

    public ReceiverSession(SocketChannel ch, ReceiverHandler handler) {
        this.channel = ch;
        this.handler = handler;
        this.channel.pipeline().addLast(new ChannelHandler[]{this.channelHandler});
    }

    protected void handleOpened() {
        this.handler.opened(this);
    }

    protected void handleMessage(SyslogMessage msg) {
        this.handler.message(this, msg);
    }

    protected void handleClosed() {
        logger.info("Session closed - ctx: {}", (Object)this.channel);
        this.handler.closed(this);
    }

    public void close() {
        this.channel.close();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.channel.remoteAddress();
    }
}

