/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataListener;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataModel;
import org.eclipse.neoscada.protocol.iec60870.server.data.DefaultSubscription;
import org.eclipse.neoscada.protocol.iec60870.server.data.Subscription;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;

public abstract class AbstractBaseDataModel
implements DataModel {
    private final Set<DefaultSubscription> subscriptions = new HashSet<DefaultSubscription>();
    private volatile int numberOfSubscriptions;
    protected final ListeningScheduledExecutorService executor;

    public AbstractBaseDataModel(String threadName) {
        this.executor = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory(threadName, false, true)));
    }

    @Override
    public synchronized Subscription subscribe(DataListener listener) {
        DefaultSubscription subscription = new DefaultSubscription(this, listener);
        this.subscriptions.add(subscription);
        this.numberOfSubscriptions = this.subscriptions.size();
        return subscription;
    }

    protected int getNumberOfSubscriptions() {
        return this.numberOfSubscriptions;
    }

    protected synchronized ListenableFuture<Void> disposeSubscription(DefaultSubscription subscription) {
        this.subscriptions.remove(subscription);
        this.numberOfSubscriptions = this.subscriptions.size();
        if (this.executor.isShutdown()) {
            return Futures.immediateFuture(null);
        }
        return this.executor.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                return null;
            }
        });
    }

    protected synchronized void notifyChangeBoolean(final ASDUAddress asduAddress, final InformationObjectAddress startAddress, final List<Value<Boolean>> values) {
        for (final DefaultSubscription sub : this.subscriptions) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    sub.notifyChangeBoolean(asduAddress, startAddress, values);
                }
            });
        }
    }

    protected synchronized void notifyChangeBoolean(final ASDUAddress asduAddress, final List<InformationEntry<Boolean>> values) {
        for (final DefaultSubscription sub : this.subscriptions) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    sub.notifyChangeBoolean(asduAddress, values);
                }
            });
        }
    }

    protected synchronized void notifyChangeFloat(final ASDUAddress asduAddress, final InformationObjectAddress startAddress, final List<Value<Float>> values) {
        for (final DefaultSubscription sub : this.subscriptions) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    sub.notifyChangeFloat(asduAddress, startAddress, values);
                }
            });
        }
    }

    protected synchronized void notifyChangeFloat(final ASDUAddress asduAddress, final List<InformationEntry<Float>> values) {
        for (final DefaultSubscription sub : this.subscriptions) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    sub.notifyChangeFloat(asduAddress, values);
                }
            });
        }
    }

    @Override
    public synchronized void dispose() {
        this.executor.shutdown();
        this.subscriptions.clear();
        this.numberOfSubscriptions = 0;
    }

    public void disposeAndWait() throws InterruptedException {
        this.dispose();
        this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }
}

