/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data;

public class DataModuleOptions {
    private int spontaneousDuplicates = 10;
    private int backgroundScanPeriod = 60000;
    private boolean booleansWithTimestamp = true;
    private boolean floatsWithTimestamp = true;

    private DataModuleOptions() {
    }

    private DataModuleOptions(DataModuleOptions other) {
        this.spontaneousDuplicates = other.spontaneousDuplicates;
        this.backgroundScanPeriod = other.backgroundScanPeriod;
        this.booleansWithTimestamp = other.booleansWithTimestamp;
        this.floatsWithTimestamp = other.floatsWithTimestamp;
    }

    public boolean isBooleansWithTimestamp() {
        return this.booleansWithTimestamp;
    }

    public boolean isFloatsWithTimestamp() {
        return this.floatsWithTimestamp;
    }

    public int getSpontaneousDuplicates() {
        return this.spontaneousDuplicates;
    }

    public boolean isSpontaneous() {
        return this.spontaneousDuplicates > 0;
    }

    public int getBackgroundScanPeriod() {
        return this.backgroundScanPeriod;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.backgroundScanPeriod;
        result = 31 * result + (this.booleansWithTimestamp ? 1231 : 1237);
        result = 31 * result + (this.floatsWithTimestamp ? 1231 : 1237);
        result = 31 * result + this.spontaneousDuplicates;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataModuleOptions other = (DataModuleOptions)obj;
        if (this.backgroundScanPeriod != other.backgroundScanPeriod) {
            return false;
        }
        if (this.booleansWithTimestamp != other.booleansWithTimestamp) {
            return false;
        }
        if (this.floatsWithTimestamp != other.floatsWithTimestamp) {
            return false;
        }
        return this.spontaneousDuplicates == other.spontaneousDuplicates;
    }

    /* synthetic */ DataModuleOptions(DataModuleOptions dataModuleOptions, DataModuleOptions dataModuleOptions2) {
        this();
    }

    /* synthetic */ DataModuleOptions(DataModuleOptions dataModuleOptions, DataModuleOptions dataModuleOptions2, DataModuleOptions dataModuleOptions3) {
        this(dataModuleOptions);
    }

    public static class Builder {
        private final DataModuleOptions value = new DataModuleOptions(null, null);

        public void setBooleansWithTimestamp(boolean booleansWithTimestamp) {
            this.value.booleansWithTimestamp = booleansWithTimestamp;
        }

        public boolean isBooleansWithTimestamp() {
            return this.value.booleansWithTimestamp;
        }

        public void setFloatsWithTimestamp(boolean floatsWithTimestamp) {
            this.value.floatsWithTimestamp = floatsWithTimestamp;
        }

        public boolean isFloatsWithTimestamp() {
            return this.value.floatsWithTimestamp;
        }

        public void setSpontaneousDuplicates(int spontaneousDuplicates) {
            this.value.spontaneousDuplicates = spontaneousDuplicates;
        }

        public int getSpontaneousDuplicates() {
            return this.value.spontaneousDuplicates;
        }

        public void setBackgroundScanPeriod(int backgroundScanPeriod) {
            this.value.backgroundScanPeriod = backgroundScanPeriod;
        }

        public int getBackgroundScanPeriod() {
            return this.value.backgroundScanPeriod;
        }

        public DataModuleOptions build() {
            return new DataModuleOptions(this.value, null, null);
        }
    }
}

