/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data.event;

import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SinglePointInformationSequence;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SinglePointInformationSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SinglePointInformationTimeSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.AbstractMessageBuilder;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.MessageBuilder;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.MessageBuilderFactory;

public class SimpleBooleanBuilder
implements MessageBuilderFactory<Boolean> {
    private final boolean withTimestamps;

    public SimpleBooleanBuilder(boolean withTimestamps) {
        this.withTimestamps = withTimestamps;
    }

    @Override
    public MessageBuilder<Boolean, ?> create() {
        return new AbstractMessageBuilder<Boolean, Object>(Boolean.class, 20, 20, this.withTimestamps ? 10 : -1){

            @Override
            public Object build() {
                this.validateStart();
                ASDUHeader header = new ASDUHeader(this.causeOfTransmission, this.asduAddress);
                if (this.isWithTimestamps()) {
                    return SinglePointInformationTimeSingle.create((ASDUHeader)header, (List)this.entries);
                }
                if (this.isContinuous()) {
                    return SinglePointInformationSequence.create((InformationObjectAddress)this.getStartAddress(), (ASDUHeader)header, this.getValues());
                }
                return SinglePointInformationSingle.create((ASDUHeader)header, (List)this.entries);
            }
        };
    }
}

