/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.relp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.CodecException;
import io.netty.util.AttributeKey;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.scada.protocol.relp.data.Frame;

public class FrameCodec
extends ChannelDuplexHandler {
    private static final AttributeKey<State> ATTR_STATE = AttributeKey.valueOf((String)"relp.frame.state");
    private static final AttributeKey<ByteBuf> ATTR_TXNR_BUFFER = AttributeKey.valueOf((String)"relp.frame.txnr.buffer");
    private static final AttributeKey<ByteBuf> ATTR_COMMAND_BUFFER = AttributeKey.valueOf((String)"relp.frame.command.buffer");
    private static final AttributeKey<ByteBuf> ATTR_LENGTH_BUFFER = AttributeKey.valueOf((String)"relp.frame.length.buffer");
    private static final AttributeKey<ByteBuf> ATTR_DATA_BUFFER = AttributeKey.valueOf((String)"relp.frame.data.buffer");
    private static final AttributeKey<Integer> ATTR_EXPECTED_LENGTH = AttributeKey.valueOf((String)"relp.expected.length");
    private static final Charset LENGTH_CHARSET = StandardCharsets.US_ASCII;
    private static final Charset TXNR_CHARSET = StandardCharsets.US_ASCII;
    private static final Charset COMMAND_CHARSET = StandardCharsets.US_ASCII;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            while (((ByteBuf)msg).isReadable()) {
                this.performRead(ctx, ((ByteBuf)msg).readByte(), (ByteBuf)msg);
            }
            ((ByteBuf)msg).release();
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.attr(ATTR_STATE).set((Object)State.TXNR);
        ctx.attr(ATTR_TXNR_BUFFER).set((Object)Unpooled.buffer());
        ctx.attr(ATTR_COMMAND_BUFFER).set((Object)Unpooled.buffer());
        ctx.attr(ATTR_LENGTH_BUFFER).set((Object)Unpooled.buffer());
        ctx.attr(ATTR_DATA_BUFFER).set((Object)Unpooled.buffer());
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ((ByteBuf)ctx.attr(ATTR_TXNR_BUFFER).getAndRemove()).release();
        ((ByteBuf)ctx.attr(ATTR_COMMAND_BUFFER).getAndRemove()).release();
        ((ByteBuf)ctx.attr(ATTR_LENGTH_BUFFER).getAndRemove()).release();
        ((ByteBuf)ctx.attr(ATTR_DATA_BUFFER).getAndRemove()).release();
        super.channelInactive(ctx);
    }

    private void performRead(ChannelHandlerContext ctx, byte b, ByteBuf msg) {
        switch ((State)((Object)ctx.attr(ATTR_STATE).get())) {
            case TXNR: {
                this.processTXNR(ctx, b);
                break;
            }
            case COMMAND: {
                this.processCOMMAND(ctx, b);
                break;
            }
            case LENGTH: {
                this.processLENGTH(ctx, b);
                break;
            }
            case DATA: {
                this.processDATA(ctx, b);
                break;
            }
            case TRAILER: {
                this.processTRAILER(ctx, b, msg);
            }
        }
    }

    private void processTRAILER(ChannelHandlerContext ctx, byte b, ByteBuf msg) {
        if (b != 10) {
            throw new CodecException(String.format("Expected trailer byte (LF) but found 0x%02X: Remaining buffer: %s", b, ByteBufUtil.hexDump((ByteBuf)msg, (int)msg.readerIndex(), (int)msg.readableBytes())));
        }
        int length = (Integer)ctx.attr(ATTR_EXPECTED_LENGTH).get();
        long txnr = Long.parseLong(((ByteBuf)ctx.attr(ATTR_TXNR_BUFFER).get()).toString(TXNR_CHARSET));
        String command = ((ByteBuf)ctx.attr(ATTR_COMMAND_BUFFER).get()).toString(COMMAND_CHARSET);
        ByteBuf data = ((ByteBuf)ctx.attr(ATTR_DATA_BUFFER).get()).readSlice(length);
        Frame frame = new Frame(txnr, command, data);
        ctx.fireChannelRead((Object)frame);
        ctx.attr(ATTR_STATE).set((Object)State.TXNR);
        ((ByteBuf)ctx.attr(ATTR_TXNR_BUFFER).get()).clear();
        ((ByteBuf)ctx.attr(ATTR_COMMAND_BUFFER).get()).clear();
        ((ByteBuf)ctx.attr(ATTR_LENGTH_BUFFER).get()).clear();
        ((ByteBuf)ctx.attr(ATTR_DATA_BUFFER).get()).clear();
    }

    private void processDATA(ChannelHandlerContext ctx, byte b) {
        ByteBuf data = (ByteBuf)ctx.attr(ATTR_DATA_BUFFER).get();
        data.writeByte((int)b);
        if (data.readableBytes() >= (Integer)ctx.attr(ATTR_EXPECTED_LENGTH).get()) {
            ctx.attr(ATTR_STATE).set((Object)State.TRAILER);
        }
    }

    private void processLENGTH(ChannelHandlerContext ctx, byte b) {
        ByteBuf lengthBuffer = (ByteBuf)ctx.attr(ATTR_LENGTH_BUFFER).get();
        if (b == 32 || lengthBuffer.readableBytes() > 0 && b == 10) {
            int length = Integer.parseInt(lengthBuffer.toString(LENGTH_CHARSET));
            ctx.attr(ATTR_EXPECTED_LENGTH).set((Object)length);
            ctx.attr(ATTR_STATE).set((Object)State.DATA);
        } else {
            lengthBuffer.writeByte((int)b);
        }
    }

    private void processCOMMAND(ChannelHandlerContext ctx, byte b) {
        if (b == 32) {
            ctx.attr(ATTR_STATE).set((Object)State.LENGTH);
        } else {
            ((ByteBuf)ctx.attr(ATTR_COMMAND_BUFFER).get()).writeByte((int)b);
        }
    }

    private void processTXNR(ChannelHandlerContext ctx, byte b) {
        if (b == 32) {
            ctx.attr(ATTR_STATE).set((Object)State.COMMAND);
        } else {
            if (b < 48 || b > 57) {
                throw new CodecException(String.format("Invalid character found: 0x%1$02x (%1$s)", b, Character.valueOf((char)b)));
            }
            ((ByteBuf)ctx.attr(ATTR_TXNR_BUFFER).get()).writeByte((int)b);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Frame) {
            this.processFrame(ctx, (Frame)msg, promise);
        }
    }

    protected void processFrame(ChannelHandlerContext ctx, Frame frame, ChannelPromise promise) {
        int length = frame.getData() == null ? 0 : frame.getData().readableBytes();
        ByteBuf data = ctx.alloc().buffer();
        data.writeBytes(String.format("%s", frame.getTransactionId()).getBytes(TXNR_CHARSET));
        data.writeByte(32);
        data.writeBytes(frame.getCommand().getBytes(COMMAND_CHARSET));
        data.writeByte(32);
        data.writeBytes(String.format("%s", length).getBytes(LENGTH_CHARSET));
        if (length > 0) {
            data.writeByte(32);
            data.writeBytes(frame.getData());
        }
        if (frame.getData() != null) {
            frame.getData().release();
        }
        data.writeByte(10);
        ctx.write((Object)data);
    }

    public static enum State {
        TXNR,
        COMMAND,
        LENGTH,
        DATA,
        TRAILER;

    }
}

