/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;

public final class EncodeHelper {
    private EncodeHelper() {
    }

    public static void encodeHeader(byte typeId, InformationStructure informationStructure, ProtocolOptions options, Integer size, ASDUHeader header, ByteBuf out) {
        byte lengthInformation = size == null ? informationStructure.encode(1) : informationStructure.encode(size);
        out.writeByte((int)typeId);
        out.writeByte((int)lengthInformation);
        header.getCauseOfTransmission().encode(options, out);
        header.getAsduAddress().encode(options, out);
    }

    public static void encodeHeader(Object message, ProtocolOptions options, Integer size, ASDUHeader header, ByteBuf out) {
        ASDU asdu = message.getClass().getAnnotation(ASDU.class);
        if (asdu == null) {
            throw new IllegalArgumentException(String.format("Message type %s does not have @%s annotation", message.getClass(), ASDU.class.getName()));
        }
        EncodeHelper.encodeHeader(asdu.id(), asdu.informationStructure(), options, size, header, out);
    }
}

