/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.EncodeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.TypeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

@ASDU(id=1, name="M_SP_NA_1", informationStructure=InformationStructure.SEQUENCE)
public class SinglePointInformationSequence
extends AbstractMessage {
    private final InformationObjectAddress startAddress;
    private final List<Value<Boolean>> values;

    private SinglePointInformationSequence(ASDUHeader header, InformationObjectAddress startAddress, List<Value<Boolean>> values) {
        super(header);
        this.startAddress = startAddress;
        this.values = values;
    }

    public InformationObjectAddress getStartAddress() {
        return this.startAddress;
    }

    public List<Value<Boolean>> getValues() {
        return this.values;
    }

    public static SinglePointInformationSequence parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        InformationObjectAddress startAddress = InformationObjectAddress.parse(options, data);
        ArrayList<Value<Boolean>> values = new ArrayList<Value<Boolean>>(length);
        int i = 0;
        while (i < length) {
            values.add(TypeHelper.parseBooleanValue(options, data, false));
            ++i;
        }
        return new SinglePointInformationSequence(header, startAddress, values);
    }

    @Override
    public void encode(ProtocolOptions options, ByteBuf out) {
        EncodeHelper.encodeHeader(this, options, this.values.size(), this.header, out);
        this.startAddress.encode(options, out);
        for (Value<Boolean> value : this.values) {
            TypeHelper.encodeBooleanValue(options, out, value, false);
        }
    }

    public static SinglePointInformationSequence create(InformationObjectAddress startAddress, ASDUHeader header, Value<Boolean> value) {
        return SinglePointInformationSequence.createInternal(startAddress, header, Collections.singletonList(value));
    }

    public static SinglePointInformationSequence create(InformationObjectAddress startAddress, ASDUHeader header, List<Value<Boolean>> values) {
        if (values.size() > 127) {
            throw new IllegalArgumentException(String.format("A maximum of %s values can be transmitted", 127));
        }
        return SinglePointInformationSequence.createInternal(startAddress, header, new ArrayList<Value<Boolean>>(values));
    }

    private static SinglePointInformationSequence createInternal(InformationObjectAddress startAddress, ASDUHeader header, List<Value<Boolean>> values) {
        return new SinglePointInformationSequence(header, startAddress, values);
    }
}

