/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.types;

import io.netty.buffer.ByteBuf;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Causes;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.StandardCause;

public class CauseOfTransmission {
    private static final int CAUSE_MASK = 63;
    private static final int ACK_BIT = 256;
    private static final int TEST_BIT = 128;
    private Cause cause;
    private boolean test;
    private boolean positive;
    private byte sourceAddress;
    public static CauseOfTransmission ACTIVATED = new CauseOfTransmission(StandardCause.ACTIVATED);
    public static CauseOfTransmission REQUEST = new CauseOfTransmission(StandardCause.REQUEST);
    public static CauseOfTransmission BACKGROUND = new CauseOfTransmission(StandardCause.BACKGROUND);

    private CauseOfTransmission() {
    }

    public CauseOfTransmission(Cause cause) {
        this(cause, (byte)0);
    }

    public CauseOfTransmission(Cause cause, Byte sourceAddress) {
        this(cause, sourceAddress, true, false);
    }

    public CauseOfTransmission(Cause cause, Byte sourceAddress, boolean acknowledge, boolean test) {
        this.cause = cause;
        this.sourceAddress = sourceAddress == null ? (byte)0 : sourceAddress;
        this.positive = acknowledge;
        this.test = test;
    }

    public Cause getCause() {
        return this.cause;
    }

    private void setCause(Cause cause) {
        this.cause = cause;
    }

    public boolean isTest() {
        return this.test;
    }

    private void setTest(boolean test) {
        this.test = test;
    }

    public boolean isPositive() {
        return this.positive;
    }

    private void setPositive(boolean positive) {
        this.positive = positive;
    }

    public byte getSourceAddress() {
        return this.sourceAddress;
    }

    private void setSourceAddress(byte sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    public static CauseOfTransmission parse(ProtocolOptions options, ByteBuf data) {
        CauseOfTransmission result = new CauseOfTransmission();
        byte first = options.getCauseOfTransmissionType().readCause(data);
        result.setCause(Causes.valueOf(first & 0x3F));
        result.setTest((first & 0x80) > 0);
        result.setPositive((first & 0x100) == 0);
        result.setSourceAddress(options.getCauseOfTransmissionType().readOriginatorAddress(data));
        return result;
    }

    public void encode(ProtocolOptions options, ByteBuf out) {
        byte first = 0;
        if (this.test) {
            first = (byte)(first | 0x80);
        }
        if (!this.positive) {
            first = (byte)(first | 0x100);
        }
        first = (byte)(first | this.cause.getValue() & 0x3F);
        options.getCauseOfTransmissionType().write(first, this.sourceAddress, out);
    }

    public String toString() {
        return String.format("[%s:%s(0x%02x):%s%s]", this.cause, this.sourceAddress & 0xFF, this.sourceAddress, this.test ? "T" : "", this.positive ? "A" : "");
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.positive ? 1231 : 1237);
        result = 31 * result + (byte)(this.cause == null ? 0 : (byte)this.cause.getValue());
        result = 31 * result + this.sourceAddress;
        result = 31 * result + (this.test ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CauseOfTransmission other = (CauseOfTransmission)obj;
        if (this.positive != other.positive) {
            return false;
        }
        if (this.cause == null ? other.cause != null : other.cause == null || this.cause.getValue() != other.cause.getValue()) {
            return false;
        }
        if (this.sourceAddress != other.sourceAddress) {
            return false;
        }
        return this.test == other.test;
    }
}

