/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.client.data;

import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.Executor;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.DoublePointInformationSequence;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.DoublePointInformationSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.DoublePointInformationTimeSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueScaledSequence;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueScaledSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueScaledTimeSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueShortFloatingPointSequence;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueShortFloatingPointSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueShortFloatingPointTimeSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SinglePointInformationSequence;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SinglePointInformationSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SinglePointInformationTimeSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataHandler;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataListener;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleContext;

public class DataProcessor
implements DataHandler {
    private final DataListener listener;
    private final Executor executor;

    public DataProcessor(Executor executor, DataListener listener) {
        this.executor = executor;
        this.listener = listener;
    }

    @Override
    public void activated(DataModuleContext dataModuleContext, ChannelHandlerContext ctx) {
        dataModuleContext.requestStartData();
        dataModuleContext.startInterrogation(ASDUAddress.BROADCAST, (short)20);
    }

    @Override
    public void started() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DataProcessor.this.listener.started();
            }
        });
    }

    @Override
    public void disconnected() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DataProcessor.this.listener.disconnected();
            }
        });
    }

    protected void fireEntry(final ASDUAddress asduAddress, final InformationObjectAddress address, final Value<?> value) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DataProcessor.this.listener.update(asduAddress, address, value);
            }
        });
    }

    @Override
    public void process(SinglePointInformationTimeSingle msg) {
        for (InformationEntry entry : msg.getEntries()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), entry.getAddress(), entry.getValue());
        }
    }

    @Override
    public void process(SinglePointInformationSingle msg) {
        for (InformationEntry entry : msg.getEntries()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), entry.getAddress(), entry.getValue());
        }
    }

    @Override
    public void process(SinglePointInformationSequence msg) {
        int i = msg.getStartAddress().getAddress();
        for (Value value : msg.getValues()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), InformationObjectAddress.valueOf((int)i), value);
            ++i;
        }
    }

    @Override
    public void process(DoublePointInformationTimeSingle msg) {
        for (InformationEntry entry : msg.getEntries()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), entry.getAddress(), entry.getValue());
        }
    }

    @Override
    public void process(DoublePointInformationSingle msg) {
        for (InformationEntry entry : msg.getEntries()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), entry.getAddress(), entry.getValue());
        }
    }

    @Override
    public void process(DoublePointInformationSequence msg) {
        int i = msg.getStartAddress().getAddress();
        for (Value value : msg.getValues()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), InformationObjectAddress.valueOf((int)i), value);
            ++i;
        }
    }

    @Override
    public void process(MeasuredValueShortFloatingPointTimeSingle msg) {
        for (InformationEntry entry : msg.getEntries()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), entry.getAddress(), entry.getValue());
        }
    }

    @Override
    public void process(MeasuredValueShortFloatingPointSingle msg) {
        for (InformationEntry entry : msg.getEntries()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), entry.getAddress(), entry.getValue());
        }
    }

    @Override
    public void process(MeasuredValueShortFloatingPointSequence msg) {
        int i = msg.getStartAddress().getAddress();
        for (Value value : msg.getValues()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), InformationObjectAddress.valueOf((int)i), value);
            ++i;
        }
    }

    @Override
    public void process(MeasuredValueScaledTimeSingle msg) {
        for (InformationEntry entry : msg.getEntries()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), entry.getAddress(), entry.getValue());
        }
    }

    @Override
    public void process(MeasuredValueScaledSingle msg) {
        for (InformationEntry entry : msg.getEntries()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), entry.getAddress(), entry.getValue());
        }
    }

    @Override
    public void process(MeasuredValueScaledSequence msg) {
        int i = msg.getStartAddress().getAddress();
        for (Value value : msg.getValues()) {
            this.fireEntry(msg.getHeader().getAsduAddress(), InformationObjectAddress.valueOf((int)i), value);
            ++i;
        }
    }
}

