/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.modbus.slave;

import java.nio.ByteOrder;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.protocol.modbus.Constants;
import org.eclipse.scada.protocol.modbus.message.BaseMessage;
import org.eclipse.scada.protocol.modbus.message.ReadRequest;
import org.eclipse.scada.protocol.modbus.message.WriteMultiDataRequest;
import org.eclipse.scada.protocol.modbus.message.WriteSingleDataRequest;
import org.eclipse.scada.protocol.modbus.slave.AnalogType;
import org.eclipse.scada.protocol.modbus.slave.DigitalType;
import org.eclipse.scada.protocol.modbus.slave.ModbusRequestException;
import org.eclipse.scada.protocol.modbus.slave.SessionContext;
import org.eclipse.scada.protocol.modbus.slave.Slave;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSlave
implements Slave {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDataSlave.class);
    private final ByteOrder order;

    public AbstractDataSlave() {
        this(Constants.DEFAULT_BYTE_ORDER);
    }

    public AbstractDataSlave(ByteOrder order) {
        this.order = order;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void handleMessage(SessionContext ctx, BaseMessage baseMessage) {
        block18: {
            try {
                if (baseMessage instanceof ReadRequest) {
                    ReadRequest msg = (ReadRequest)baseMessage;
                    byte fc = msg.getFunctionCode();
                    switch (fc) {
                        case 1: 
                        case 2: {
                            boolean[] data = this.handleReadDigital(fc == 1 ? DigitalType.COIL : DigitalType.DISCRETE, msg.getStartAddress(), msg.getQuantity());
                            if (data == null) break;
                            ctx.sendReadReply(baseMessage, data);
                            return;
                        }
                        case 3: 
                        case 4: {
                            int[] data = this.handleReadAnalog(fc == 3 ? AnalogType.HOLDING : AnalogType.INPUT, msg.getStartAddress(), msg.getQuantity());
                            if (data == null) break;
                            ctx.sendReadReply(baseMessage, data, this.order);
                            return;
                        }
                        default: {
                            ctx.sendExceptionReply(baseMessage, 1);
                            return;
                        }
                    }
                    ctx.sendExceptionReply(baseMessage, 2);
                    break block18;
                }
                if (baseMessage instanceof WriteSingleDataRequest) {
                    WriteSingleDataRequest msg = (WriteSingleDataRequest)baseMessage;
                    byte fc = msg.getFunctionCode();
                    switch (fc) {
                        case 5: {
                            this.handleDigitalWrite(msg.getAddress(), new boolean[]{msg.isTrue()});
                            ctx.sendWriteReply(msg);
                            return;
                        }
                        case 6: {
                            this.processAnalogWrite(msg.getAddress(), 1, msg.getData());
                            ctx.sendWriteReply(msg);
                            return;
                        }
                    }
                    ctx.sendExceptionReply(baseMessage, 1);
                    return;
                }
                if (baseMessage instanceof WriteMultiDataRequest) {
                    WriteMultiDataRequest msg = (WriteMultiDataRequest)baseMessage;
                    byte fc = msg.getFunctionCode();
                    switch (fc) {
                        case 15: {
                            this.processDigitalWrite(msg);
                            ctx.sendWriteReply(msg);
                            break block18;
                        }
                        case 16: {
                            this.processAnalogWrite(msg.getStartAddress(), msg.getNumRegisters(), msg.getData());
                            ctx.sendWriteReply(msg);
                            return;
                        }
                        default: {
                            ctx.sendExceptionReply(baseMessage, 1);
                            return;
                        }
                    }
                }
                ctx.sendExceptionReply(baseMessage, 1);
            }
            catch (ModbusRequestException e) {
                logger.debug("Modbus request exception", (Throwable)e);
                ctx.sendExceptionReply(baseMessage, e.getExceptionCode());
            }
            catch (Exception e) {
                logger.debug("Failed to handle message", (Throwable)e);
                ctx.sendExceptionReply(baseMessage, 4);
            }
        }
    }

    private void processAnalogWrite(int startAddress, int numRegisters, byte[] rawData) {
        int[] regs = new int[numRegisters];
        IoBuffer data = IoBuffer.wrap((byte[])rawData);
        data.order(this.order);
        int i = 0;
        while (i < numRegisters) {
            regs[i] = data.getUnsignedShort();
            ++i;
        }
        this.handleAnalogWrite(startAddress, regs);
    }

    private void processDigitalWrite(WriteMultiDataRequest msg) {
        boolean[] regs = new boolean[msg.getNumRegisters()];
        byte[] data = msg.getData();
        int i = 0;
        while (i < msg.getNumRegisters()) {
            regs[i] = (data[i >> 8] & 1 << i % 8) > 0;
            ++i;
        }
        this.handleDigitalWrite(msg.getStartAddress(), regs);
    }

    protected abstract boolean[] handleReadDigital(DigitalType var1, int var2, int var3) throws ModbusRequestException;

    protected abstract int[] handleReadAnalog(AnalogType var1, int var2, int var3) throws ModbusRequestException;

    protected abstract void handleAnalogWrite(int var1, int[] var2) throws ModbusRequestException;

    protected abstract void handleDigitalWrite(int var1, boolean[] var2) throws ModbusRequestException;
}

