/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.nebula.grid;

import java.util.Map;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class GridCopyKeyListener
implements KeyListener {
    private final Clipboard clipboard;

    public GridCopyKeyListener(Display display) {
        this.clipboard = new Clipboard(display);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if ((e.stateMask & 0x40000) != 0 && e.keyCode == 99) {
            Grid grid = (Grid)e.widget;
            this.copySelectionToClipboard(grid);
        }
    }

    public void copySelectionToClipboard(Grid grid) {
        String selectionText = this.getSelectionAsText(grid);
        if (selectionText == null || selectionText.isEmpty()) {
            return;
        }
        Object[] data = new String[]{selectionText};
        TextTransfer[] dataTypes = new TextTransfer[]{TextTransfer.getInstance()};
        this.clipboard.setContents(data, (Transfer[])dataTypes);
    }

    public String getSelectionAsText(Grid grid) {
        Point[] cellSelection = grid.getCellSelection();
        StringBuilder selection = new StringBuilder();
        int minRow = Integer.MAX_VALUE;
        int minColumn = Integer.MAX_VALUE;
        int maxRow = Integer.MIN_VALUE;
        int maxColumn = Integer.MIN_VALUE;
        Point[] pointArray = cellSelection;
        int n = cellSelection.length;
        int n2 = 0;
        while (n2 < n) {
            Point point = pointArray[n2];
            int row = point.y;
            int col = point.x;
            if (row < minRow) {
                minRow = row;
            }
            if (row > maxRow) {
                maxRow = row;
            }
            if (col < minColumn) {
                minColumn = col;
            }
            if (col > maxColumn) {
                maxColumn = col;
            }
            ++n2;
        }
        int columnSize = maxColumn - minColumn + 1;
        int rowSize = maxRow - minRow + 1;
        String[][] tableSelection = this.initializeTableSelection(grid, cellSelection, columnSize, rowSize, minColumn, minRow);
        int i = 0;
        while (i < rowSize) {
            int j = 0;
            while (j < columnSize) {
                String text = tableSelection[j][i];
                if (j != 0) {
                    selection.append('\t');
                }
                if (text != null) {
                    selection.append(text);
                }
                ++j;
            }
            if (i != rowSize - 1) {
                selection.append('\n');
            }
            ++i;
        }
        return selection.toString();
    }

    private String[][] initializeTableSelection(Grid grid, Point[] cellSelection, int columnSize, int rowSize, int minColumn, int minRow) {
        String[][] tableSelection = new String[columnSize][rowSize];
        int i = 0;
        while (i < cellSelection.length) {
            String text;
            int column = cellSelection[i].x;
            int row = cellSelection[i].y;
            tableSelection[column - minColumn][row - minRow] = text = this.getText(grid, column, row);
            ++i;
        }
        return tableSelection;
    }

    private String getText(Grid grid, int column, int row) {
        GridItem item = grid.getItem(row);
        Map copyAlternative = (Map)item.getData("org.eclipse.emf.ecp.edit.spi.swt.table.copyStringAlternative");
        if (copyAlternative != null && copyAlternative.containsKey(column)) {
            return (String)copyAlternative.get(column);
        }
        String text = item.getText(column);
        return text;
    }
}

